/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.array;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.io.Writable;

public class ShortArrayWritable
implements Writable {
    private short[] array;
    private int length = 0;

    public ShortArrayWritable() {
    }

    public ShortArrayWritable(short[] array) {
        this.array = array;
        this.length = array.length;
    }

    public ShortArrayWritable(short[] array, int length) {
        this.array = array;
        this.length = length;
    }

    public ShortArrayWritable(int size) {
        this.array = new short[size];
    }

    public void readFields(DataInput in) throws IOException {
        this.length = in.readInt();
        this.array = new short[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.array[i] = in.readShort();
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.length);
        for (int i = 0; i < this.length; ++i) {
            out.writeShort(this.array[i]);
        }
    }

    public short[] getClone() {
        short[] copy = new short[this.length];
        System.arraycopy(this.array, 0, copy, 0, this.length);
        return copy;
    }

    public short[] getArray() {
        return this.array;
    }

    public void setArray(short[] array) {
        if (array == null) {
            this.array = new short[0];
            this.length = 0;
            return;
        }
        this.array = array;
        this.length = array.length;
    }

    public void setArray(short[] array, int length) {
        this.array = array;
        this.length = length;
    }

    public short get(int i) {
        return this.array[i];
    }

    public void set(int i, short v) {
        this.array[i] = v;
    }

    public int size() {
        return this.length;
    }

    public String toString() {
        return Arrays.toString(this.array);
    }
}

