/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import tl.lin.data.map.HMapIV;
import tl.lin.data.map.MapIV;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HMapIVW<V extends Writable>
extends HMapIV<V>
implements Writable {
    private static final long serialVersionUID = 2532109344100674110L;

    public void readFields(DataInput in) throws IOException {
        this.clear();
        int numEntries = in.readInt();
        if (numEntries == 0) {
            return;
        }
        String valueClassName = in.readUTF();
        try {
            Class<?> valueClass = Class.forName(valueClassName);
            for (int i = 0; i < numEntries; ++i) {
                int k = in.readInt();
                Writable objV = (Writable)valueClass.newInstance();
                objV.readFields(in);
                this.put(k, objV);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.size() == 0) {
            return;
        }
        Set entries = this.entrySet();
        MapIV.Entry first = entries.iterator().next();
        Writable objV = (Writable)first.getValue();
        out.writeUTF(objV.getClass().getCanonicalName());
        for (MapIV.Entry e : this.entrySet()) {
            out.writeInt(e.getKey());
            ((Writable)e.getValue()).write(out);
        }
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        this.write(dataOut);
        return bytesOut.toByteArray();
    }

    public static <T extends WritableComparable<?>> HMapIVW<T> create(DataInput in) throws IOException {
        HMapIVW m = new HMapIVW();
        m.readFields(in);
        return m;
    }

    public static <T extends WritableComparable<?>> HMapIVW<T> create(byte[] bytes) throws IOException {
        return HMapIVW.create(new DataInputStream(new ByteArrayInputStream(bytes)));
    }
}

