/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import tl.lin.data.map.MapKI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HMapKI<K extends Comparable<?>>
implements MapKI<K>,
Cloneable,
Serializable {
    static final int DEFAULT_INITIAL_CAPACITY = 1024;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry<K>[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    private transient Set<MapKI.Entry<K>> entrySet = null;
    volatile transient Set<K> keySet = null;
    volatile transient Collection<Integer> values = null;
    private static final long serialVersionUID = 362498820763181265L;

    public HMapKI(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
        this.init();
    }

    public HMapKI(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public HMapKI() {
        this.loadFactor = 0.75f;
        this.threshold = 768;
        this.table = new Entry[1024];
        this.init();
    }

    public HMapKI(MapKI<? extends K> m) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 1024), 0.75f);
        super.putAllForCreate(m);
    }

    void init() {
    }

    static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int get(K key) {
        if (key == null) {
            return this.getForNullKey();
        }
        int hash = HMapKI.hash(key.hashCode());
        Entry<K> e = this.table[HMapKI.indexFor(hash, this.table.length)];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key.equals(k))) {
                return e.value;
            }
            e = e.next;
        }
        return 0;
    }

    private int getForNullKey() {
        Entry<K> e = this.table[0];
        while (e != null) {
            if (e.key == null) {
                return e.value;
            }
            e = e.next;
        }
        return 0;
    }

    @Override
    public boolean containsKey(K key) {
        return this.getEntry(key) != null;
    }

    final Entry<K> getEntry(Object key) {
        int hash = HMapKI.hash(key.hashCode());
        Entry<K> e = this.table[HMapKI.indexFor(hash, this.table.length)];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public int put(K key, int value) {
        if (key == null) {
            return this.putForNullKey(value);
        }
        int hash = HMapKI.hash(key.hashCode());
        int i = HMapKI.indexFor(hash, this.table.length);
        Entry<K> e = this.table[i];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key.equals(k))) {
                int oldValue = e.value;
                e.value = value;
                e.recordAccess(this);
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(hash, key, value, i);
        return 0;
    }

    private int putForNullKey(int value) {
        Entry<K> e = this.table[0];
        while (e != null) {
            if (e.key == null) {
                int oldValue = value;
                e.value = value;
                e.recordAccess(this);
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(0, null, value, 0);
        return 0;
    }

    private void putForCreate(K key, int value) {
        int hash = key == null ? 0 : HMapKI.hash(key.hashCode());
        int i = HMapKI.indexFor(hash, this.table.length);
        Entry<K> e = this.table[i];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        this.createEntry(hash, key, value, i);
    }

    private void putAllForCreate(MapKI<? extends K> m) {
        for (MapKI.Entry<K> e : m.entrySet()) {
            this.putForCreate((Comparable)e.getKey(), e.getValue());
        }
    }

    void resize(int newCapacity) {
        Entry<K>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(Entry<K>[] newTable) {
        Entry<K>[] src = this.table;
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            Entry next;
            Entry<K> e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = e.next;
                int i = HMapKI.indexFor(e.hash, newCapacity);
                e.next = newTable[i];
                newTable[i] = e;
            } while ((e = next) != null);
        }
    }

    @Override
    public void putAll(MapKI<? extends K> m) {
        int numKeysToBeAdded = m.size();
        if (numKeysToBeAdded == 0) {
            return;
        }
        if (numKeysToBeAdded > this.threshold) {
            int newCapacity;
            int targetCapacity = (int)((float)numKeysToBeAdded / this.loadFactor + 1.0f);
            if (targetCapacity > 0x40000000) {
                targetCapacity = 0x40000000;
            }
            for (newCapacity = this.table.length; newCapacity < targetCapacity; newCapacity <<= 1) {
            }
            if (newCapacity > this.table.length) {
                this.resize(newCapacity);
            }
        }
        for (MapKI.Entry<K> e : m.entrySet()) {
            this.put((K)((Comparable)e.getKey()), e.getValue());
        }
    }

    @Override
    public int remove(K key) {
        Entry<K> e = this.removeEntryForKey(key);
        if (e != null) {
            return e.value;
        }
        throw new NoSuchElementException();
    }

    final Entry<K> removeEntryForKey(Object key) {
        Entry<K> prev;
        int hash = key == null ? 0 : HMapKI.hash(key.hashCode());
        int i = HMapKI.indexFor(hash, this.table.length);
        Entry<K> e = prev = this.table[i];
        while (e != null) {
            Object k;
            Entry next = e.next;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    final Entry<K> removeMapping(Object o) {
        Entry<K> prev;
        MapKI.Entry entry = (MapKI.Entry)o;
        Object key = entry.getKey();
        int hash = key == null ? 0 : HMapKI.hash(key.hashCode());
        int i = HMapKI.indexFor(hash, this.table.length);
        Entry<K> e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (e.hash == hash && e.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    @Override
    public void clear() {
        ++this.modCount;
        Entry<K>[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean containsValue(int value) {
        Entry<K>[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            Entry<K> e = tab[i];
            while (e != null) {
                if (value == e.value) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public Object clone() {
        HMapKI result = null;
        try {
            result = (HMapKI)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        result.table = new Entry[this.table.length];
        result.entrySet = null;
        result.modCount = 0;
        result.size = 0;
        result.init();
        result.putAllForCreate(this);
        return result;
    }

    void addEntry(int hash, K key, int value, int bucketIndex) {
        Entry<K> e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry<K>(hash, key, value, e);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int hash, K key, int value, int bucketIndex) {
        Entry<K> e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry<K>(hash, key, value, e);
        ++this.size;
    }

    Iterator<K> newKeyIterator() {
        return new KeyIterator();
    }

    Iterator<Integer> newValueIterator() {
        return new ValueIterator();
    }

    Iterator<MapKI.Entry<K>> newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<Integer> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<MapKI.Entry<K>> entrySet() {
        return this.entrySet0();
    }

    private Set<MapKI.Entry<K>> entrySet0() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Iterator<MapKI.Entry<K>> i = this.size > 0 ? this.entrySet0().iterator() : null;
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.size);
        if (i != null) {
            while (i.hasNext()) {
                MapKI.Entry<K> e = i.next();
                s.writeObject(e.getKey());
                s.writeInt(e.getValue());
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.table = new Entry[numBuckets];
        this.init();
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            Comparable key = (Comparable)s.readObject();
            int value = s.readInt();
            this.putForCreate(key, value);
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    public String toString() {
        Iterator<MapKI.Entry<K>> i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            MapKI.Entry<K> e = i.next();
            Comparable key = (Comparable)e.getKey();
            int value = e.getValue();
            sb.append(key);
            sb.append('=');
            sb.append(value);
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }

    @Override
    public void plus(MapKI<K> m) {
        for (MapKI.Entry<K> e : m.entrySet()) {
            Comparable key = (Comparable)e.getKey();
            if (this.containsKey((K)key)) {
                this.put((K)key, this.get((K)key) + e.getValue());
                continue;
            }
            this.put((K)key, e.getValue());
        }
    }

    @Override
    public long dot(MapKI<K> m) {
        int s = 0;
        for (MapKI.Entry<K> e : m.entrySet()) {
            Comparable key = (Comparable)e.getKey();
            if (!this.containsKey((K)key)) continue;
            s += this.get((K)key) * e.getValue();
        }
        return s;
    }

    @Override
    public void increment(K key) {
        if (this.containsKey(key)) {
            this.put(key, this.get(key) + 1);
        } else {
            this.put(key, 1);
        }
    }

    @Override
    public void increment(K key, int value) {
        if (this.containsKey(key)) {
            this.put(key, this.get(key) + value);
        } else {
            this.put(key, value);
        }
    }

    public MapKI.Entry<K>[] getEntriesSortedByValue() {
        if (this.size() == 0) {
            return null;
        }
        Entry[] entries = new Entry[this.size()];
        int i = 0;
        Entry<K> next = null;
        int index = 0;
        while (index < this.table.length && (next = this.table[index++]) == null) {
        }
        while (next != null) {
            Entry<K> e = next;
            next = e.next;
            next = e.next;
            if (next == null) {
                while (index < this.table.length && (next = this.table[index++]) == null) {
                }
            }
            entries[i++] = e;
        }
        Arrays.sort(entries, new Comparator<MapKI.Entry<K>>(){

            @Override
            public int compare(MapKI.Entry<K> e1, MapKI.Entry<K> e2) {
                if (e1.getValue() > e2.getValue()) {
                    return -1;
                }
                if (e1.getValue() < e2.getValue()) {
                    return 1;
                }
                if (e1.getKey() == e2.getKey()) {
                    return 0;
                }
                return ((Comparable)e1.getKey()).compareTo(e2.getKey());
            }
        });
        return entries;
    }

    public MapKI.Entry<K>[] getEntriesSortedByValue(int n) {
        MapKI.Entry<K>[] entries = this.getEntriesSortedByValue();
        if (entries == null) {
            return null;
        }
        if (entries.length < n) {
            return entries;
        }
        return Arrays.copyOfRange(entries, 0, n);
    }

    public MapKI.Entry<K>[] getEntriesSortedByKey() {
        if (this.size() == 0) {
            return null;
        }
        Entry[] entries = new Entry[this.size()];
        int i = 0;
        Entry<K> next = null;
        int index = 0;
        while (index < this.table.length && (next = this.table[index++]) == null) {
        }
        while (next != null) {
            Entry<K> e = next;
            next = e.next;
            next = e.next;
            if (next == null) {
                while (index < this.table.length && (next = this.table[index++]) == null) {
                }
            }
            entries[i++] = e;
        }
        Arrays.sort(entries, new Comparator<MapKI.Entry<K>>(){

            @Override
            public int compare(MapKI.Entry<K> e1, MapKI.Entry<K> e2) {
                return ((Comparable)e1.getKey()).compareTo(e2.getKey());
            }
        });
        return entries;
    }

    public MapKI.Entry<K>[] getEntriesSortedByKey(int n) {
        MapKI.Entry<K>[] entries = this.getEntriesSortedByKey();
        if (entries == null) {
            return null;
        }
        if (entries.length < n) {
            return entries;
        }
        return Arrays.copyOfRange(entries, 0, n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntrySet
    extends AbstractSet<MapKI.Entry<K>> {
        private EntrySet() {
        }

        @Override
        public Iterator<MapKI.Entry<K>> iterator() {
            return HMapKI.this.newEntryIterator();
        }

        @Override
        public int size() {
            return HMapKI.this.size;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            MapKI.Entry e = (MapKI.Entry)o;
            Entry candidate = HMapKI.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Values
    extends AbstractCollection<Integer> {
        private Values() {
        }

        @Override
        public Iterator<Integer> iterator() {
            return HMapKI.this.newValueIterator();
        }

        @Override
        public int size() {
            return HMapKI.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return HMapKI.this.containsValue((Integer)o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return HMapKI.this.newKeyIterator();
        }

        @Override
        public int size() {
            return HMapKI.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return HMapKI.this.containsKey((Comparable)o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntryIterator
    extends HashIterator<MapKI.Entry<K>> {
        private EntryIterator() {
        }

        @Override
        public MapKI.Entry<K> next() {
            return this.nextEntry();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeyIterator
    extends HashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return (Comparable)this.nextEntry().getKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ValueIterator
    extends HashIterator<Integer> {
        private ValueIterator() {
        }

        @Override
        public Integer next() {
            return this.nextEntry().value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class HashIterator<E>
    implements Iterator<E> {
        Entry<K> next;
        int expectedModCount;
        int index;
        Entry<K> current;

        HashIterator() {
            this.expectedModCount = HMapKI.this.modCount;
            if (HMapKI.this.size > 0) {
                Entry<K>[] t = HMapKI.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry<K> nextEntry() {
            if (HMapKI.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = e.next;
            if (this.next == null) {
                Entry<K>[] t = HMapKI.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
            this.current = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (HMapKI.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Object k = this.current.key;
            this.current = null;
            HMapKI.this.removeEntryForKey(k);
            this.expectedModCount = HMapKI.this.modCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Entry<K>
    implements MapKI.Entry<K> {
        final K key;
        int value;
        Entry<K> next;
        final int hash;

        Entry(int h, K k, int v, Entry<K> n) {
            this.value = v;
            this.next = n;
            this.key = k;
            this.hash = h;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final int getValue() {
            return this.value;
        }

        @Override
        public final int setValue(int newValue) {
            int oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            int v2;
            int v1;
            Object k2;
            MapKI.Entry e = (MapKI.Entry)o;
            K k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && (v1 = this.getValue()) == (v2 = e.getValue());
        }

        @Override
        public final int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ this.value;
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        void recordAccess(MapKI<K> m) {
        }

        void recordRemoval(MapKI<K> m) {
        }
    }
}

