/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import tl.lin.data.map.MapKS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HMapKS<K>
implements MapKS<K>,
Cloneable,
Serializable {
    static final int DEFAULT_INITIAL_CAPACITY = 1024;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry<K>[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    private transient Set<MapKS.Entry<K>> entrySet = null;
    volatile transient Set<K> keySet = null;
    volatile transient Collection<Short> values = null;
    private static final long serialVersionUID = 362498820763181265L;

    public HMapKS(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
        this.init();
    }

    public HMapKS(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public HMapKS() {
        this.loadFactor = 0.75f;
        this.threshold = 768;
        this.table = new Entry[1024];
        this.init();
    }

    public HMapKS(MapKS<? extends K> m) {
        this(Math.max((int)((float)m.size() / 0.75f) + 1, 1024), 0.75f);
        super.putAllForCreate(m);
    }

    void init() {
    }

    static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public short get(K key) {
        if (key == null) {
            return this.getForNullKey();
        }
        int hash = HMapKS.hash(key.hashCode());
        Entry<K> e = this.table[HMapKS.indexFor(hash, this.table.length)];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key.equals(k))) {
                return e.value;
            }
            e = e.next;
        }
        return 0;
    }

    private short getForNullKey() {
        Entry<K> e = this.table[0];
        while (e != null) {
            if (e.key == null) {
                return e.value;
            }
            e = e.next;
        }
        return 0;
    }

    @Override
    public boolean containsKey(K key) {
        return this.getEntry(key) != null;
    }

    final Entry<K> getEntry(Object key) {
        int hash = key == null ? 0 : HMapKS.hash(key.hashCode());
        Entry<K> e = this.table[HMapKS.indexFor(hash, this.table.length)];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    @Override
    public short put(K key, short value) {
        if (key == null) {
            return this.putForNullKey(value);
        }
        int hash = HMapKS.hash(key.hashCode());
        int i = HMapKS.indexFor(hash, this.table.length);
        Entry<K> e = this.table[i];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key.equals(k))) {
                short oldValue = e.value;
                e.value = value;
                e.recordAccess(this);
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(hash, key, value, i);
        return 0;
    }

    private short putForNullKey(short value) {
        Entry<K> e = this.table[0];
        while (e != null) {
            if (e.key == null) {
                short oldValue = e.value;
                e.value = value;
                e.recordAccess(this);
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        this.addEntry(0, null, value, 0);
        return 0;
    }

    private void putForCreate(K key, short value) {
        int hash = key == null ? 0 : HMapKS.hash(key.hashCode());
        int i = HMapKS.indexFor(hash, this.table.length);
        Entry<K> e = this.table[i];
        while (e != null) {
            Object k;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        this.createEntry(hash, key, value, i);
    }

    private void putAllForCreate(MapKS<? extends K> m) {
        for (MapKS.Entry<K> e : m.entrySet()) {
            this.putForCreate(e.getKey(), e.getValue());
        }
    }

    void resize(int newCapacity) {
        Entry<K>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(newTable);
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    void transfer(Entry<K>[] newTable) {
        Entry<K>[] src = this.table;
        int newCapacity = newTable.length;
        for (int j = 0; j < src.length; ++j) {
            Entry next;
            Entry<K> e = src[j];
            if (e == null) continue;
            src[j] = null;
            do {
                next = e.next;
                int i = HMapKS.indexFor(e.hash, newCapacity);
                e.next = newTable[i];
                newTable[i] = e;
            } while ((e = next) != null);
        }
    }

    @Override
    public void putAll(MapKS<? extends K> m) {
        int numKeysToBeAdded = m.size();
        if (numKeysToBeAdded == 0) {
            return;
        }
        if (numKeysToBeAdded > this.threshold) {
            int newCapacity;
            int targetCapacity = (int)((float)numKeysToBeAdded / this.loadFactor + 1.0f);
            if (targetCapacity > 0x40000000) {
                targetCapacity = 0x40000000;
            }
            for (newCapacity = this.table.length; newCapacity < targetCapacity; newCapacity <<= 1) {
            }
            if (newCapacity > this.table.length) {
                this.resize(newCapacity);
            }
        }
        for (MapKS.Entry<K> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public short remove(K key) {
        Entry<K> e = this.removeEntryForKey(key);
        if (e != null) {
            return e.value;
        }
        throw new NoSuchElementException();
    }

    final Entry<K> removeEntryForKey(Object key) {
        Entry<K> prev;
        int hash = key == null ? 0 : HMapKS.hash(key.hashCode());
        int i = HMapKS.indexFor(hash, this.table.length);
        Entry<K> e = prev = this.table[i];
        while (e != null) {
            Object k;
            Entry next = e.next;
            if (e.hash == hash && ((k = e.key) == key || key != null && key.equals(k))) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    final Entry<K> removeMapping(Object o) {
        Entry<K> prev;
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        MapKS.Entry entry = (MapKS.Entry)o;
        Object key = entry.getKey();
        int hash = key == null ? 0 : HMapKS.hash(key.hashCode());
        int i = HMapKS.indexFor(hash, this.table.length);
        Entry<K> e = prev = this.table[i];
        while (e != null) {
            Entry next = e.next;
            if (e.hash == hash && e.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    this.table[i] = next;
                } else {
                    prev.next = next;
                }
                e.recordRemoval(this);
                return e;
            }
            prev = e;
            e = next;
        }
        return e;
    }

    @Override
    public void clear() {
        ++this.modCount;
        Entry<K>[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean containsValue(short value) {
        Entry<K>[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            Entry<K> e = tab[i];
            while (e != null) {
                if (value == e.value) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public Object clone() {
        HMapKS result = null;
        try {
            result = (HMapKS)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        result.table = new Entry[this.table.length];
        result.entrySet = null;
        result.modCount = 0;
        result.size = 0;
        result.init();
        result.putAllForCreate(this);
        return result;
    }

    void addEntry(int hash, K key, short value, int bucketIndex) {
        Entry<K> e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry<K>(hash, key, value, e);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int hash, K key, short value, int bucketIndex) {
        Entry<K> e = this.table[bucketIndex];
        this.table[bucketIndex] = new Entry<K>(hash, key, value, e);
        ++this.size;
    }

    Iterator<K> newKeyIterator() {
        return new KeyIterator();
    }

    Iterator<Short> newValueIterator() {
        return new ValueIterator();
    }

    Iterator<MapKS.Entry<K>> newEntryIterator() {
        return new EntryIterator();
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<Short> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    public Set<MapKS.Entry<K>> entrySet() {
        return this.entrySet0();
    }

    private Set<MapKS.Entry<K>> entrySet0() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Iterator<MapKS.Entry<K>> i = this.size > 0 ? this.entrySet0().iterator() : null;
        s.defaultWriteObject();
        s.writeInt(this.table.length);
        s.writeInt(this.size);
        if (i != null) {
            while (i.hasNext()) {
                MapKS.Entry<K> e = i.next();
                s.writeObject(e.getKey());
                s.writeShort(e.getValue());
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int numBuckets = s.readInt();
        this.table = new Entry[numBuckets];
        this.init();
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = s.readObject();
            short value = s.readShort();
            this.putForCreate(key, value);
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    public String toString() {
        Iterator<MapKS.Entry<K>> i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            MapKS.Entry<K> e = i.next();
            K key = e.getKey();
            short value = e.getValue();
            sb.append(key);
            sb.append('=');
            sb.append(value);
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }

    @Override
    public void plus(MapKS<K> m) {
        for (MapKS.Entry<K> e : m.entrySet()) {
            K key = e.getKey();
            if (this.containsKey(key)) {
                this.put(key, (short)(this.get(key) + e.getValue()));
                continue;
            }
            this.put(key, e.getValue());
        }
    }

    @Override
    public long dot(MapKS<K> m) {
        int s = 0;
        for (MapKS.Entry<K> e : m.entrySet()) {
            K key = e.getKey();
            if (!this.containsKey(key)) continue;
            s += this.get(key) * e.getValue();
        }
        return s;
    }

    @Override
    public void increment(K key) {
        if (this.containsKey(key)) {
            this.put(key, (short)(this.get(key) + 1));
        } else {
            this.put(key, (short)1);
        }
    }

    @Override
    public void increment(K key, short value) {
        if (this.containsKey(key)) {
            this.put(key, (short)(this.get(key) + value));
        } else {
            this.put(key, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntrySet
    extends AbstractSet<MapKS.Entry<K>> {
        private EntrySet() {
        }

        @Override
        public Iterator<MapKS.Entry<K>> iterator() {
            return HMapKS.this.newEntryIterator();
        }

        @Override
        public int size() {
            return HMapKS.this.size;
        }

        @Override
        public boolean contains(Object o) {
            MapKS.Entry e = (MapKS.Entry)o;
            Entry candidate = HMapKS.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Values
    extends AbstractCollection<Short> {
        private Values() {
        }

        @Override
        public Iterator<Short> iterator() {
            return HMapKS.this.newValueIterator();
        }

        @Override
        public int size() {
            return HMapKS.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return HMapKS.this.containsValue((Short)o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return HMapKS.this.newKeyIterator();
        }

        @Override
        public int size() {
            return HMapKS.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return HMapKS.this.containsKey(o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntryIterator
    extends HashIterator<MapKS.Entry<K>> {
        private EntryIterator() {
        }

        @Override
        public MapKS.Entry<K> next() {
            return this.nextEntry();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class KeyIterator
    extends HashIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ValueIterator
    extends HashIterator<Short> {
        private ValueIterator() {
        }

        @Override
        public Short next() {
            return this.nextEntry().value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class HashIterator<E>
    implements Iterator<E> {
        Entry<K> next;
        int expectedModCount;
        int index;
        Entry<K> current;

        HashIterator() {
            this.expectedModCount = HMapKS.this.modCount;
            if (HMapKS.this.size > 0) {
                Entry<K>[] t = HMapKS.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
        }

        @Override
        public final boolean hasNext() {
            return this.next != null;
        }

        final Entry<K> nextEntry() {
            if (HMapKS.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = e.next;
            if (this.next == null) {
                Entry<K>[] t = HMapKS.this.table;
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
            this.current = e;
            return e;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (HMapKS.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Object k = this.current.key;
            this.current = null;
            HMapKS.this.removeEntryForKey(k);
            this.expectedModCount = HMapKS.this.modCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Entry<K>
    implements MapKS.Entry<K> {
        final K key;
        short value;
        Entry<K> next;
        final int hash;

        Entry(int h, K k, short v, Entry<K> n) {
            this.value = v;
            this.next = n;
            this.key = k;
            this.hash = h;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final short getValue() {
            return this.value;
        }

        @Override
        public final short setValue(short newValue) {
            short oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            short v2;
            short v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            MapKS.Entry e = (MapKS.Entry)o;
            K k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && (v1 = this.getValue()) == (v2 = e.getValue());
        }

        @Override
        public final int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ this.value;
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        void recordAccess(HMapKS<K> m) {
        }

        void recordRemoval(HMapKS<K> m) {
        }
    }
}

