/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.pair;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PairOfIntFloat
implements WritableComparable<PairOfIntFloat> {
    private int leftElement;
    private float rightElement;

    public PairOfIntFloat() {
    }

    public PairOfIntFloat(int left, float right) {
        this.set(left, right);
    }

    public void readFields(DataInput in) throws IOException {
        this.leftElement = in.readInt();
        this.rightElement = in.readFloat();
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.leftElement);
        out.writeFloat(this.rightElement);
    }

    public int getLeftElement() {
        return this.leftElement;
    }

    public float getRightElement() {
        return this.rightElement;
    }

    public int getKey() {
        return this.leftElement;
    }

    public float getValue() {
        return this.rightElement;
    }

    public void set(int left, float right) {
        this.leftElement = left;
        this.rightElement = right;
    }

    public boolean equals(Object obj) {
        PairOfIntFloat pair = (PairOfIntFloat)obj;
        return this.leftElement == pair.getLeftElement() && this.rightElement == pair.getRightElement();
    }

    public int compareTo(PairOfIntFloat pair) {
        int pl = pair.getLeftElement();
        float pr = pair.getRightElement();
        if (this.leftElement == pl) {
            if (this.rightElement < pr) {
                return -1;
            }
            if (this.rightElement > pr) {
                return 1;
            }
            return 0;
        }
        if (this.leftElement < pl) {
            return -1;
        }
        return 1;
    }

    public int hashCode() {
        return (int)((float)this.leftElement + this.rightElement);
    }

    public String toString() {
        return "(" + this.leftElement + ", " + this.rightElement + ")";
    }

    public PairOfIntFloat clone() {
        return new PairOfIntFloat(this.leftElement, this.rightElement);
    }

    static {
        WritableComparator.define(PairOfIntFloat.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(PairOfIntFloat.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            int thatLeftValue;
            int thisLeftValue = Comparator.readInt((byte[])b1, (int)s1);
            if (thisLeftValue == (thatLeftValue = Comparator.readInt((byte[])b2, (int)s2))) {
                float thatRightValue;
                float thisRightValue = Comparator.readFloat((byte[])b1, (int)(s1 + 4));
                return thisRightValue < (thatRightValue = Comparator.readFloat((byte[])b2, (int)(s2 + 4))) ? -1 : (thisRightValue == thatRightValue ? 0 : 1);
            }
            return thisLeftValue < thatLeftValue ? -1 : (thisLeftValue == thatLeftValue ? 0 : 1);
        }
    }
}

