/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.pair;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PairOfLongs
implements WritableComparable<PairOfLongs> {
    private long leftElement;
    private long rightElement;

    public PairOfLongs() {
    }

    public PairOfLongs(long left, long right) {
        this.set(left, right);
    }

    public void readFields(DataInput in) throws IOException {
        this.leftElement = in.readLong();
        this.rightElement = in.readLong();
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.leftElement);
        out.writeLong(this.rightElement);
    }

    public long getLeftElement() {
        return this.leftElement;
    }

    public long getRightElement() {
        return this.rightElement;
    }

    public long getKey() {
        return this.leftElement;
    }

    public long getValue() {
        return this.rightElement;
    }

    public void set(long left, long right) {
        this.leftElement = left;
        this.rightElement = right;
    }

    public boolean equals(Object obj) {
        PairOfLongs pair = (PairOfLongs)obj;
        return this.leftElement == pair.getLeftElement() && this.rightElement == pair.getRightElement();
    }

    public int compareTo(PairOfLongs pair) {
        long pl = pair.getLeftElement();
        long pr = pair.getRightElement();
        if (this.leftElement == pl) {
            if (this.rightElement < pr) {
                return -1;
            }
            if (this.rightElement > pr) {
                return 1;
            }
            return 0;
        }
        if (this.leftElement < pl) {
            return -1;
        }
        return 1;
    }

    public int hashCode() {
        return (int)this.leftElement & (int)this.rightElement;
    }

    public String toString() {
        return "(" + this.leftElement + ", " + this.rightElement + ")";
    }

    public PairOfLongs clone() {
        return new PairOfLongs(this.leftElement, this.rightElement);
    }

    static {
        WritableComparator.define(PairOfLongs.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(PairOfLongs.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            long thatLeftValue;
            long thisLeftValue = Comparator.readLong((byte[])b1, (int)s1);
            if (thisLeftValue == (thatLeftValue = Comparator.readLong((byte[])b2, (int)s2))) {
                long thatRightValue;
                long thisRightValue = Comparator.readLong((byte[])b1, (int)(s1 + 8));
                return thisRightValue < (thatRightValue = Comparator.readLong((byte[])b2, (int)(s2 + 8))) ? -1 : (thisRightValue == thatRightValue ? 0 : 1);
            }
            return thisLeftValue < thatLeftValue ? -1 : (thisLeftValue == thatLeftValue ? 0 : 1);
        }
    }
}

