/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.pair;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PairOfStrings
implements WritableComparable<PairOfStrings> {
    private String leftElement;
    private String rightElement;

    public PairOfStrings() {
    }

    public PairOfStrings(String left, String right) {
        this.set(left, right);
    }

    public void readFields(DataInput in) throws IOException {
        this.leftElement = Text.readString((DataInput)in);
        this.rightElement = Text.readString((DataInput)in);
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.leftElement);
        Text.writeString((DataOutput)out, (String)this.rightElement);
    }

    public String getLeftElement() {
        return this.leftElement;
    }

    public String getRightElement() {
        return this.rightElement;
    }

    public String getKey() {
        return this.leftElement;
    }

    public String getValue() {
        return this.rightElement;
    }

    public void set(String left, String right) {
        this.leftElement = left;
        this.rightElement = right;
    }

    public boolean equals(Object obj) {
        PairOfStrings pair = (PairOfStrings)obj;
        return this.leftElement.equals(pair.getLeftElement()) && this.rightElement.equals(pair.getRightElement());
    }

    public int compareTo(PairOfStrings pair) {
        String pl = pair.getLeftElement();
        String pr = pair.getRightElement();
        if (this.leftElement.equals(pl)) {
            return this.rightElement.compareTo(pr);
        }
        return this.leftElement.compareTo(pl);
    }

    public int hashCode() {
        return this.leftElement.hashCode() + this.rightElement.hashCode();
    }

    public String toString() {
        return "(" + this.leftElement + ", " + this.rightElement + ")";
    }

    public PairOfStrings clone() {
        return new PairOfStrings(this.leftElement, this.rightElement);
    }

    static {
        WritableComparator.define(PairOfStrings.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(PairOfStrings.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            try {
                int firstVIntL1 = WritableUtils.decodeVIntSize((byte)b1[s1]);
                int firstVIntL2 = WritableUtils.decodeVIntSize((byte)b2[s2]);
                int firstStrL1 = Comparator.readVInt((byte[])b1, (int)s1);
                int firstStrL2 = Comparator.readVInt((byte[])b2, (int)s2);
                int cmp = Comparator.compareBytes((byte[])b1, (int)(s1 + firstVIntL1), (int)firstStrL1, (byte[])b2, (int)(s2 + firstVIntL2), (int)firstStrL2);
                if (cmp != 0) {
                    return cmp;
                }
                int secondVIntL1 = WritableUtils.decodeVIntSize((byte)b1[s1 + firstVIntL1 + firstStrL1]);
                int secondVIntL2 = WritableUtils.decodeVIntSize((byte)b2[s2 + firstVIntL2 + firstStrL2]);
                int secondStrL1 = Comparator.readVInt((byte[])b1, (int)(s1 + firstVIntL1 + firstStrL1));
                int secondStrL2 = Comparator.readVInt((byte[])b2, (int)(s2 + firstVIntL2 + firstStrL2));
                return Comparator.compareBytes((byte[])b1, (int)(s1 + firstVIntL1 + firstStrL1 + secondVIntL1), (int)secondStrL1, (byte[])b2, (int)(s2 + firstVIntL2 + firstStrL2 + secondVIntL2), (int)secondStrL2);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

