/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.queue;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.PriorityQueue;
import tl.lin.data.pair.PairOfIntFloat;

public class TopScoredInts
implements Writable {
    private ScoredIntPriorityQueue queue;
    private int maxElements;

    public TopScoredInts() {
        this(10);
    }

    public TopScoredInts(int n) {
        this.queue = new ScoredIntPriorityQueue(n);
        this.maxElements = n;
    }

    public void add(int n, float f) {
        this.queue.insert(new PairOfIntFloat(n, f));
    }

    public int getMaxElements() {
        return this.maxElements;
    }

    public int size() {
        return this.queue.size();
    }

    public PairOfIntFloat[] extractAll() {
        int len = this.queue.size();
        PairOfIntFloat[] arr = new PairOfIntFloat[len];
        for (int i = 0; i < len; ++i) {
            arr[len - 1 - i] = (PairOfIntFloat)this.queue.pop();
        }
        return arr;
    }

    public void readFields(DataInput in) throws IOException {
        this.maxElements = in.readInt();
        this.queue = new ScoredIntPriorityQueue(this.maxElements);
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            int k = in.readInt();
            float v = in.readFloat();
            this.add(k, v);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.maxElements);
        int sz = this.size();
        out.writeInt(sz);
        for (int i = 0; i < sz; ++i) {
            PairOfIntFloat pair = (PairOfIntFloat)this.queue.pop();
            out.writeInt(pair.getKey());
            out.writeFloat(pair.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScoredIntPriorityQueue
    extends PriorityQueue<PairOfIntFloat> {
        private ScoredIntPriorityQueue(int maxSize) {
            super.initialize(maxSize);
        }

        protected boolean lessThan(Object obj0, Object obj1) {
            if (((PairOfIntFloat)obj0).getValue() == ((PairOfIntFloat)obj1).getValue()) {
                return ((PairOfIntFloat)obj0).getKey() < ((PairOfIntFloat)obj1).getKey();
            }
            return ((PairOfIntFloat)obj0).getValue() < ((PairOfIntFloat)obj1).getValue();
        }
    }
}

