/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.array;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.io.WritableComparable;
import tl.lin.data.array.ArrayListOfDoubles;

public class ArrayListOfDoublesWritable
extends ArrayListOfDoubles
implements WritableComparable<ArrayListOfDoublesWritable> {
    public ArrayListOfDoublesWritable() {
    }

    public ArrayListOfDoublesWritable(int initialCapacity) {
        super(initialCapacity);
    }

    public ArrayListOfDoublesWritable(ArrayListOfDoublesWritable other) {
        this.size = other.size();
        this.array = Arrays.copyOf(other.getArray(), this.size);
    }

    public ArrayListOfDoublesWritable(double[] arr) {
        super(arr);
    }

    public void readFields(DataInput in) throws IOException {
        this.clear();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.add(i, in.readDouble());
        }
    }

    public void write(DataOutput out) throws IOException {
        int size = this.size();
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeDouble(this.get(i));
        }
    }

    @Override
    public String toString() {
        return this.toString(this.size());
    }

    public static ArrayListOfDoublesWritable fromArrayListOfDoubles(ArrayListOfDoubles arr) {
        ArrayListOfDoublesWritable list = new ArrayListOfDoublesWritable();
        list.array = Arrays.copyOf(arr.getArray(), arr.size());
        list.size = arr.size();
        return list;
    }

    public int compareTo(ArrayListOfDoublesWritable obj) {
        ArrayListOfDoublesWritable other = obj;
        if (this.isEmpty()) {
            if (other.isEmpty()) {
                return 0;
            }
            return -1;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (other.size() <= i) {
                return 1;
            }
            if (this.get(i) < other.get(i)) {
                return -1;
            }
            if (!(this.get(i) > other.get(i))) continue;
            return 1;
        }
        if (other.size() > this.size()) {
            return -1;
        }
        return 0;
    }
}

