/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.array;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Iterator;
import java.util.RandomAccess;

public class ArrayListOfFloats
implements RandomAccess,
Cloneable,
Iterable<Float> {
    protected transient float[] array;
    protected int size = 0;
    private static final int INITIAL_CAPACITY_DEFAULT = 10;

    public ArrayListOfFloats(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.array = new float[initialCapacity];
        this.size = 0;
    }

    public ArrayListOfFloats() {
        this(10);
    }

    public ArrayListOfFloats(float[] a) {
        Preconditions.checkNotNull((Object)a);
        this.array = Arrays.copyOf(a, a.length);
        this.size = this.array.length;
    }

    public ArrayListOfFloats(int first, int last) {
        this(last - first);
        int j = 0;
        for (int i = first; i < last; ++i) {
            this.add(j++, i);
        }
    }

    public void trimToSize() {
        int oldCapacity = this.array.length;
        if (this.size < oldCapacity) {
            this.array = Arrays.copyOf(this.array, this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.array.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.array = Arrays.copyOf(this.array, newCapacity);
        }
    }

    public int size() {
        return this.size;
    }

    public void setSize(int sz) {
        this.ensureCapacity(sz);
        this.size = sz;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(float n) {
        return this.indexOf(n) >= 0;
    }

    public int indexOf(float n) {
        for (int i = 0; i < this.size; ++i) {
            if (n != this.array[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(float n) {
        for (int i = this.size - 1; i >= 0; --i) {
            if (n != this.array[i]) continue;
            return i;
        }
        return -1;
    }

    public ArrayListOfFloats clone() {
        return new ArrayListOfFloats(Arrays.copyOf(this.array, this.size()));
    }

    public float get(int index) {
        return this.array[index];
    }

    public float set(int index, float element) {
        if (index >= this.array.length) {
            this.ensureCapacity(index + 1);
        }
        if (index >= this.size) {
            this.size = index + 1;
        }
        float oldValue = this.array[index];
        this.array[index] = element;
        return oldValue;
    }

    public ArrayListOfFloats add(float e) {
        this.ensureCapacity(this.size + 1);
        this.array[this.size++] = e;
        return this;
    }

    public ArrayListOfFloats add(int index, float element) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        this.array[index] = element;
        ++this.size;
        return this;
    }

    public float remove(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        float oldValue = this.array[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.array, index + 1, this.array, index, numMoved);
        }
        --this.size;
        return oldValue;
    }

    public void clear() {
        this.size = 0;
        this.array = new float[10];
    }

    public float[] getArray() {
        return this.array;
    }

    @Override
    public Iterator<Float> iterator() {
        return new Iterator<Float>(){
            int cnt = 0;

            @Override
            public boolean hasNext() {
                return this.cnt < ArrayListOfFloats.this.size();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Float next() {
                return Float.valueOf(ArrayListOfFloats.this.get(this.cnt++));
            }
        };
    }

    public String toString(int n) {
        StringBuilder s = new StringBuilder();
        s.append("[");
        int sz = this.size() > n ? n : this.size;
        for (int i = 0; i < sz; ++i) {
            s.append(this.get(i));
            if (i >= sz - 1) continue;
            s.append(", ");
        }
        s.append(this.size() > n ? String.format(" ... (%d more) ]", this.size() - n) : "]");
        return s.toString();
    }

    public String toString() {
        return this.toString(10);
    }

    public void sort() {
        this.trimToSize();
        Arrays.sort(this.getArray());
    }

    public ArrayListOfFloats intersection(ArrayListOfFloats other) {
        ArrayListOfFloats result = new ArrayListOfFloats();
        int curPos = 0;
        if (this.size() < other.size()) {
            int len = this.size();
            for (int i = 0; i < len; ++i) {
                float elt = this.get(i);
                while (curPos < other.size() && other.get(curPos) < elt) {
                    ++curPos;
                }
                if (curPos >= other.size()) {
                    return result;
                }
                if (other.get(curPos) != elt) continue;
                result.add(elt);
            }
        } else {
            int len = other.size();
            for (int i = 0; i < len; ++i) {
                float elt = other.get(i);
                while (curPos < this.size() && this.get(curPos) < elt) {
                    ++curPos;
                }
                if (curPos >= this.size()) {
                    return result;
                }
                if (this.get(curPos) != elt) continue;
                result.add(elt);
            }
        }
        return result;
    }

    public ArrayListOfFloats merge(ArrayListOfFloats sortedLst) {
        ArrayListOfFloats result = new ArrayListOfFloats();
        int indA = 0;
        int indB = 0;
        while (indA < this.size() || indB < sortedLst.size()) {
            if (indA == this.size()) {
                result.add(sortedLst.get(indB++));
                continue;
            }
            if (indB == sortedLst.size()) {
                result.add(this.get(indA++));
                continue;
            }
            if (this.get(indA) < sortedLst.get(indB)) {
                result.add(this.get(indA++));
                continue;
            }
            result.add(sortedLst.get(indB++));
        }
        return result;
    }

    public ArrayListOfFloats subList(int start, int end) {
        ArrayListOfFloats sublst = new ArrayListOfFloats(end - start + 1);
        for (int i = start; i <= end; ++i) {
            sublst.add(this.get(i));
        }
        return sublst;
    }

    public void addUnique(int[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            int elt = arr[i];
            if (this.contains(elt)) continue;
            this.add(elt);
        }
    }

    public void shiftLastNToTop(int n) {
        if (n >= this.size) {
            return;
        }
        int j = 0;
        for (int i = this.size - n; i < this.size; ++i) {
            this.array[j] = this.array[i];
            ++j;
        }
        this.size = n;
    }

    public boolean equals(Object obj) {
        ArrayListOfFloats other = (ArrayListOfFloats)obj;
        if (this.isEmpty()) {
            return other.isEmpty();
        }
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) < other.get(i)) {
                return false;
            }
            if (!(this.get(i) > other.get(i))) continue;
            return false;
        }
        return true;
    }
}

