/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.array;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.io.WritableComparable;
import tl.lin.data.array.ArrayListOfShorts;

public class ArrayListOfShortsWritable
extends ArrayListOfShorts
implements WritableComparable<ArrayListOfShortsWritable> {
    public ArrayListOfShortsWritable() {
    }

    public ArrayListOfShortsWritable(int initialCapacity) {
        super(initialCapacity);
    }

    public ArrayListOfShortsWritable(short first, short last) {
        super(first, last);
    }

    public ArrayListOfShortsWritable(ArrayListOfShortsWritable other) {
        this.size = other.size();
        this.array = Arrays.copyOf(other.getArray(), this.size);
    }

    public ArrayListOfShortsWritable(short[] arr) {
        super(arr);
    }

    public void readFields(DataInput in) throws IOException {
        this.clear();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.add(i, in.readShort());
        }
    }

    public void write(DataOutput out) throws IOException {
        int size = this.size();
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeShort(this.get(i));
        }
    }

    @Override
    public String toString() {
        return this.toString(this.size());
    }

    public static ArrayListOfShortsWritable fromArrayListOfShorts(ArrayListOfShorts a) {
        ArrayListOfShortsWritable list = new ArrayListOfShortsWritable();
        list.array = Arrays.copyOf(a.getArray(), a.size());
        list.size = a.size();
        return list;
    }

    public int compareTo(ArrayListOfShortsWritable obj) {
        ArrayListOfShortsWritable other = obj;
        if (this.isEmpty()) {
            if (other.isEmpty()) {
                return 0;
            }
            return -1;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (other.size() <= i) {
                return 1;
            }
            if (this.get(i) < other.get(i)) {
                return -1;
            }
            if (this.get(i) <= other.get(i)) continue;
            return 1;
        }
        if (other.size() > this.size()) {
            return -1;
        }
        return 0;
    }
}

