/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.array;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.io.Writable;

public class LongArrayWritable
implements Writable {
    private long[] array;
    private int length = 0;

    public LongArrayWritable() {
    }

    public LongArrayWritable(long[] array) {
        this.array = array;
        this.length = array.length;
    }

    public LongArrayWritable(long[] array, int length) {
        this.array = array;
        this.length = length;
    }

    public LongArrayWritable(int size) {
        this.array = new long[size];
    }

    public void readFields(DataInput in) throws IOException {
        this.length = in.readInt();
        this.array = new long[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.array[i] = in.readLong();
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.length);
        for (int i = 0; i < this.length; ++i) {
            out.writeLong(this.array[i]);
        }
    }

    public long[] getClone() {
        long[] copy = new long[this.length];
        System.arraycopy(this.array, 0, copy, 0, this.length);
        return copy;
    }

    public long[] getArray() {
        return this.array;
    }

    public void setArray(long[] array) {
        if (array == null) {
            this.array = new long[0];
            this.length = 0;
            return;
        }
        this.array = array;
        this.length = array.length;
    }

    public void setArray(long[] array, int length) {
        this.array = array;
        this.length = length;
    }

    public long get(int i) {
        return this.array[i];
    }

    public void set(int i, long v) {
        this.array[i] = v;
    }

    public int size() {
        return this.length;
    }

    public String toString() {
        return Arrays.toString(this.array);
    }
}

