/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import tl.lin.data.map.HMapKI;
import tl.lin.data.map.MapKI;

public class HMapKIW<K extends WritableComparable<?>>
extends HMapKI<K>
implements Writable {
    private static final long serialVersionUID = -495714688553572924L;

    public void readFields(DataInput in) throws IOException {
        this.clear();
        int numEntries = in.readInt();
        if (numEntries == 0) {
            return;
        }
        String keyClassName = in.readUTF();
        try {
            Class<?> keyClass = Class.forName(keyClassName);
            for (int i = 0; i < numEntries; ++i) {
                WritableComparable objK = (WritableComparable)keyClass.newInstance();
                objK.readFields(in);
                int s = in.readInt();
                this.put(objK, s);
            }
        }
        catch (Exception e) {
            throw new IOException("Unable to create HMapKIW!");
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.size() == 0) {
            return;
        }
        Set entries = this.entrySet();
        MapKI.Entry first = entries.iterator().next();
        WritableComparable objK = (WritableComparable)first.getKey();
        out.writeUTF(objK.getClass().getCanonicalName());
        for (MapKI.Entry e : this.entrySet()) {
            ((WritableComparable)e.getKey()).write(out);
            out.writeInt(e.getValue());
        }
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        this.write(dataOut);
        return bytesOut.toByteArray();
    }

    public static <T extends WritableComparable<?>> HMapKIW<T> create(DataInput in) throws IOException {
        HMapKIW m = new HMapKIW();
        m.readFields(in);
        return m;
    }

    public static <T extends WritableComparable<?>> HMapKIW<T> create(byte[] bytes) throws IOException {
        return HMapKIW.create(new DataInputStream(new ByteArrayInputStream(bytes)));
    }
}

