/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.pair;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;

public class PairOfStringFloat
implements WritableComparable<PairOfStringFloat> {
    private String leftElement;
    private float rightElement;

    public PairOfStringFloat() {
    }

    public PairOfStringFloat(String left, float right) {
        this.set(left, right);
    }

    public void readFields(DataInput in) throws IOException {
        this.leftElement = Text.readString((DataInput)in);
        this.rightElement = in.readFloat();
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.leftElement);
        out.writeFloat(this.rightElement);
    }

    public String getLeftElement() {
        return this.leftElement;
    }

    public float getRightElement() {
        return this.rightElement;
    }

    public String getKey() {
        return this.leftElement;
    }

    public float getValue() {
        return this.rightElement;
    }

    public void set(String left, float right) {
        this.leftElement = left;
        this.rightElement = right;
    }

    public boolean equals(Object obj) {
        PairOfStringFloat pair = (PairOfStringFloat)obj;
        return this.leftElement.equals(pair.getLeftElement()) && this.rightElement == pair.getRightElement();
    }

    public int compareTo(PairOfStringFloat pair) {
        String pl = pair.getLeftElement();
        float pr = pair.getRightElement();
        if (this.leftElement.equals(pl)) {
            if (this.rightElement == pr) {
                return 0;
            }
            return this.rightElement < pr ? -1 : 1;
        }
        return this.leftElement.compareTo(pl);
    }

    public int hashCode() {
        return this.leftElement.hashCode() + (int)this.rightElement;
    }

    public String toString() {
        return "(" + this.leftElement + ", " + this.rightElement + ")";
    }

    public PairOfStringFloat clone() {
        return new PairOfStringFloat(this.leftElement, this.rightElement);
    }

    static {
        WritableComparator.define(PairOfStringFloat.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(PairOfStringFloat.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            try {
                float thatRightValue;
                int firstVIntL1 = WritableUtils.decodeVIntSize((byte)b1[s1]);
                int firstVIntL2 = WritableUtils.decodeVIntSize((byte)b2[s2]);
                int firstStrL1 = Comparator.readVInt((byte[])b1, (int)s1);
                int firstStrL2 = Comparator.readVInt((byte[])b2, (int)s2);
                int cmp = Comparator.compareBytes((byte[])b1, (int)(s1 + firstVIntL1), (int)firstStrL1, (byte[])b2, (int)(s2 + firstVIntL2), (int)firstStrL2);
                if (cmp != 0) {
                    return cmp;
                }
                float thisRightValue = Comparator.readFloat((byte[])b1, (int)(s1 + firstVIntL1 + firstStrL1));
                return thisRightValue < (thatRightValue = Comparator.readFloat((byte[])b2, (int)(s2 + firstVIntL2 + firstStrL2))) ? -1 : (thisRightValue == thatRightValue ? 0 : 1);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

