/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.pair;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class PairOfWritables<L extends Writable, R extends Writable>
implements Writable {
    private L leftElement;
    private R rightElement;

    public PairOfWritables() {
    }

    public PairOfWritables(L left, R right) {
        this.leftElement = left;
        this.rightElement = right;
    }

    public void readFields(DataInput in) throws IOException {
        String keyClassName = in.readUTF();
        String valueClassName = in.readUTF();
        try {
            Class<?> keyClass = Class.forName(keyClassName);
            this.leftElement = (Writable)keyClass.newInstance();
            Class<?> valueClass = Class.forName(valueClassName);
            this.rightElement = (Writable)valueClass.newInstance();
            this.leftElement.readFields(in);
            this.rightElement.readFields(in);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create PairOfWritables!");
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.leftElement.getClass().getCanonicalName());
        out.writeUTF(this.rightElement.getClass().getCanonicalName());
        this.leftElement.write(out);
        this.rightElement.write(out);
    }

    public L getLeftElement() {
        return this.leftElement;
    }

    public R getRightElement() {
        return this.rightElement;
    }

    public L getKey() {
        return this.leftElement;
    }

    public R getValue() {
        return this.rightElement;
    }

    public void set(L left, R right) {
        this.leftElement = left;
        this.rightElement = right;
    }

    public String toString() {
        return "(" + this.leftElement + ", " + this.rightElement + ")";
    }
}

