/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import tl.lin.data.array.ArrayListWritable;
import tl.lin.data.array.IntArrayWritable;
import tl.lin.data.map.HMapIVW;
import tl.lin.data.pair.PairOfInts;
import tl.lin.data.pair.PairOfStringInt;
import tl.lin.data.pair.PairOfStrings;
import tl.lin.data.pair.PairOfWritables;

public class IntegratedExampleTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        PairOfWritables data = new PairOfWritables((Writable)new PairOfStringInt("foo", 42), (Writable)new IntArrayWritable(new int[]{1, 2, 3, 4, 5}));
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        data.write((DataOutput)dataOut);
        PairOfWritables reconstructed = new PairOfWritables();
        reconstructed.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((Object)data.getLeftElement(), (Object)reconstructed.getLeftElement());
        Assert.assertTrue((boolean)Arrays.equals(((IntArrayWritable)data.getRightElement()).getArray(), ((IntArrayWritable)reconstructed.getRightElement()).getArray()));
    }

    @org.junit.Test
    public void testBasic2() throws IOException {
        ArrayListWritable data = new ArrayListWritable();
        data.add((Object)new PairOfInts(1, 2));
        data.add((Object)new PairOfInts(3, 4));
        data.add((Object)new PairOfInts(5, 6));
        data.add((Object)new PairOfInts(7, 8));
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        data.write((DataOutput)dataOut);
        ArrayListWritable reconstructed = new ArrayListWritable();
        reconstructed.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        for (int i = 0; i < data.size(); ++i) {
            Assert.assertEquals((Object)data.get(i), (Object)reconstructed.get(i));
        }
    }

    @org.junit.Test
    public void testBasic3() throws IOException {
        HMapIVW data = new HMapIVW();
        data.put(1, (Object)new PairOfStrings("a", "b"));
        data.put(2, (Object)new PairOfStrings("foo", "bar"));
        data.put(4, (Object)new PairOfStrings("alpha", "beta"));
        data.put(42, (Object)new PairOfStrings("four", "two"));
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        data.write((DataOutput)dataOut);
        HMapIVW reconstructed = new HMapIVW();
        reconstructed.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        for (int i = 0; i < data.size(); ++i) {
            Assert.assertEquals((Object)data.get(i), (Object)reconstructed.get(i));
        }
    }

    public static Test suite() {
        return new JUnit4TestAdapter(IntegratedExampleTest.class);
    }
}

