/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.array;

import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import tl.lin.data.array.ArrayListOfFloats;

public class ArrayListOfFloatsTest {
    float neg_one = -1.0f;
    float zero = 0.0f;
    float one = 1.0f;
    float two = 2.0f;
    float three = 3.0f;
    float four = 4.0f;
    float five = 5.0f;
    float six = 6.0f;
    float seven = 7.0f;
    float nine = 9.0f;

    @org.junit.Test
    public void testInitialSize() {
        ArrayListOfFloats a = new ArrayListOfFloats();
        Assert.assertEquals((long)0L, (long)a.size());
    }

    @org.junit.Test
    public void testSetBounds() {
        ArrayListOfFloats a = new ArrayListOfFloats(10);
        Assert.assertEquals((long)0L, (long)a.size());
        a.set(0, 1.0f);
        Assert.assertEquals((long)1L, (long)a.size());
        a.set(5, 1.0f);
        Assert.assertEquals((long)6L, (long)a.size());
        a.set(1, 1.0f);
        Assert.assertEquals((long)6L, (long)a.size());
        a.set(9, 1.0f);
        Assert.assertEquals((long)10L, (long)a.size());
        a.set(99, 1.0f);
        Assert.assertEquals((long)100L, (long)a.size());
        a.set(0, 2.0f);
        Assert.assertEquals((long)100L, (long)a.size());
    }

    @org.junit.Test
    public void testRemoveWithinBounds() {
        ArrayListOfFloats a = new ArrayListOfFloats();
        a.add(this.one).add(this.three).add(this.five).add(this.seven);
        Assert.assertTrue((this.one == a.remove(0) ? 1 : 0) != 0);
        Assert.assertTrue((this.three == a.get(0) ? 1 : 0) != 0);
        Assert.assertTrue((this.five == a.get(1) ? 1 : 0) != 0);
        Assert.assertTrue((this.five == a.remove(1) ? 1 : 0) != 0);
        Assert.assertTrue((this.seven == a.get(2) ? 1 : 0) != 0);
    }

    @org.junit.Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testRemoveOutOfBounds() {
        ArrayListOfFloats a = new ArrayListOfFloats();
        a.add(this.one).add(this.three).add(this.five).add(this.seven);
        a.remove(4);
    }

    @org.junit.Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testRemoveOutOfBounds2() {
        ArrayListOfFloats a = new ArrayListOfFloats();
        a.add(this.neg_one);
        a.remove(-1);
    }

    @org.junit.Test
    public void testBasic1() {
        int i;
        int size = 100000;
        Random r = new Random();
        float[] floats = new float[size];
        ArrayListOfFloats list = new ArrayListOfFloats();
        for (i = 0; i < size; ++i) {
            float k = r.nextFloat();
            list.add(k);
            floats[i] = k;
        }
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((double)floats[i], (double)list.get(i), (double)1.0E-4);
        }
    }

    @org.junit.Test
    public void testArrayConstructor() {
        float[] arr = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
        Assert.assertEquals((long)5L, (long)arr.length);
        ArrayListOfFloats list = new ArrayListOfFloats(arr);
        list.remove(2);
        Assert.assertEquals((double)1.0, (double)arr[0], (double)1.0E-5);
        Assert.assertEquals((double)2.0, (double)arr[1], (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)arr[2], (double)1.0E-5);
        Assert.assertEquals((double)4.0, (double)arr[3], (double)1.0E-5);
        Assert.assertEquals((double)5.0, (double)arr[4], (double)1.0E-5);
    }

    @org.junit.Test
    public void testRemove() {
        ArrayListOfFloats list = new ArrayListOfFloats();
        for (int i = 0; i < 10; ++i) {
            list.add((float)i);
        }
        list.remove(list.indexOf(5.0f));
        Assert.assertEquals((long)9L, (long)list.size());
        Assert.assertEquals((double)0.0, (double)list.get(0), (double)1.0E-5);
        Assert.assertEquals((double)1.0, (double)list.get(1), (double)1.0E-5);
        Assert.assertEquals((double)2.0, (double)list.get(2), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)list.get(3), (double)1.0E-5);
        Assert.assertEquals((double)4.0, (double)list.get(4), (double)1.0E-5);
        Assert.assertEquals((double)6.0, (double)list.get(5), (double)1.0E-5);
        Assert.assertEquals((double)7.0, (double)list.get(6), (double)1.0E-5);
        Assert.assertEquals((double)8.0, (double)list.get(7), (double)1.0E-5);
        Assert.assertEquals((double)9.0, (double)list.get(8), (double)1.0E-5);
        list.remove(list.indexOf(9.0f));
        Assert.assertEquals((long)8L, (long)list.size);
        Assert.assertEquals((double)0.0, (double)list.get(0), (double)1.0E-5);
        Assert.assertEquals((double)1.0, (double)list.get(1), (double)1.0E-5);
        Assert.assertEquals((double)2.0, (double)list.get(2), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)list.get(3), (double)1.0E-5);
        Assert.assertEquals((double)4.0, (double)list.get(4), (double)1.0E-5);
        Assert.assertEquals((double)6.0, (double)list.get(5), (double)1.0E-5);
        Assert.assertEquals((double)7.0, (double)list.get(6), (double)1.0E-5);
        Assert.assertEquals((double)8.0, (double)list.get(7), (double)1.0E-5);
    }

    @org.junit.Test
    public void testUpdate() {
        int i;
        int size = 100000;
        Random r = new Random();
        float[] floats = new float[size];
        ArrayListOfFloats list = new ArrayListOfFloats();
        for (i = 0; i < size; ++i) {
            float k = r.nextFloat();
            list.add(k);
            floats[i] = k;
        }
        Assert.assertEquals((long)size, (long)list.size());
        for (i = 0; i < size; ++i) {
            list.set(i, floats[i] + 1.0f);
        }
        Assert.assertEquals((long)size, (long)list.size());
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((double)(floats[i] + 1.0f), (double)list.get(i), (double)1.0E-4);
        }
    }

    @org.junit.Test
    public void testTrim1() {
        int i;
        int size = 89;
        Random r = new Random();
        float[] floats = new float[size];
        ArrayListOfFloats list = new ArrayListOfFloats();
        for (i = 0; i < size; ++i) {
            float k = r.nextFloat();
            list.add(k);
            floats[i] = k;
        }
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((double)floats[i], (double)list.get(i), (double)1.0E-4);
        }
        float[] rawArray = list.getArray();
        int lenBefore = rawArray.length;
        list.trimToSize();
        float[] rawArrayAfter = list.getArray();
        int lenAfter = rawArrayAfter.length;
        Assert.assertEquals((long)89L, (long)lenAfter);
        Assert.assertTrue((lenBefore > lenAfter ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testClone() {
        int i;
        int size = 100000;
        Random r = new Random();
        float[] floats = new float[size];
        ArrayListOfFloats list1 = new ArrayListOfFloats();
        for (int i2 = 0; i2 < size; ++i2) {
            float k = r.nextFloat();
            list1.add(k);
            floats[i2] = k;
        }
        ArrayListOfFloats list2 = list1.clone();
        Assert.assertEquals((long)size, (long)list1.size());
        Assert.assertEquals((long)size, (long)list2.size());
        for (i = 0; i < size; ++i) {
            list2.set(i, floats[i] + 1.0f);
        }
        Assert.assertEquals((long)size, (long)list1.size());
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((double)floats[i], (double)list1.get(i), (double)1.0E-4);
        }
        Assert.assertEquals((long)size, (long)list1.size());
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((double)(floats[i] + 1.0f), (double)list2.get(i), (double)1.0E-4);
        }
    }

    @org.junit.Test
    public void testToString() {
        float v;
        int i;
        int size = 10;
        Random r = new Random();
        ArrayListOfFloats list = new ArrayListOfFloats();
        for (int i2 = 0; i2 < size; ++i2) {
            list.add(r.nextFloat());
        }
        String out = list.toString();
        for (i = 0; i < size; ++i) {
            v = list.get(i);
            Assert.assertTrue((out.indexOf(new Float(v).toString()) != -1 ? 1 : 0) != 0);
        }
        for (i = 0; i < size; ++i) {
            list.add(r.nextFloat());
        }
        out = list.toString();
        for (i = size; i < size + size; ++i) {
            v = list.get(i);
            Assert.assertTrue((out.indexOf(new Float(v).toString()) == -1 ? 1 : 0) != 0);
        }
        Assert.assertTrue((out.indexOf(size + " more") != -1 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testIterable() {
        int i;
        int size = 1000;
        Random r = new Random();
        float[] floats = new float[size];
        ArrayListOfFloats list = new ArrayListOfFloats();
        for (i = 0; i < size; ++i) {
            float k = r.nextFloat();
            list.add(k);
            floats[i] = k;
        }
        i = 0;
        for (Float v : list) {
            Assert.assertEquals((double)floats[i++], (double)v.floatValue(), (double)1.0E-4);
        }
    }

    @org.junit.Test
    public void testSetSize() {
        ArrayListOfFloats list = new ArrayListOfFloats();
        list.add(5.0f);
        Assert.assertEquals((long)1L, (long)list.size);
        Assert.assertEquals((double)5.0, (double)list.get(0), (double)1.0E-5);
        list.setSize(5);
        Assert.assertEquals((long)5L, (long)list.size);
        Assert.assertEquals((double)0.0, (double)list.get(1), (double)1.0E-5);
        Assert.assertEquals((double)0.0, (double)list.get(2), (double)1.0E-5);
        Assert.assertEquals((double)0.0, (double)list.get(3), (double)1.0E-5);
        Assert.assertEquals((double)0.0, (double)list.get(4), (double)1.0E-5);
        list.add(12.0f);
        Assert.assertEquals((long)6L, (long)list.size);
        Assert.assertEquals((double)12.0, (double)list.get(5), (double)1.0E-5);
    }

    @org.junit.Test
    public void testSort() {
        ArrayListOfFloats a = new ArrayListOfFloats();
        Assert.assertEquals((long)0L, (long)a.size());
        a.add(5.2f).add(6.0f).add(5.9f).add(4.1f);
        Assert.assertEquals((long)4L, (long)a.size());
        a.sort();
        Assert.assertEquals((long)4L, (long)a.size());
        Assert.assertTrue((Math.abs((double)a.get(0) - 4.1) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs((double)a.get(1) - 5.2) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue((Math.abs((double)a.get(2) - 5.9) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Math.abs(a.get(3) - 6.0f) < 1.0E-4 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testIntersection1() {
        ArrayListOfFloats a = new ArrayListOfFloats();
        a.add(5.0f).add(3.0f).add(1.0f);
        a.sort();
        ArrayListOfFloats b = new ArrayListOfFloats();
        b.add(0.0f).add(1.0f).add(2.0f).add(3.0f);
        ArrayListOfFloats c = a.intersection(b);
        Assert.assertTrue(((double)Math.abs(1.0f - c.get(0)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Math.abs(3.0f - c.get(1)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Math.abs(2 - c.size()) < 1.0E-4 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testIntersection2() {
        ArrayListOfFloats a = new ArrayListOfFloats();
        a.add(5.0f);
        ArrayListOfFloats b = new ArrayListOfFloats();
        b.add(0.0f).add(1.0f).add(2.0f).add(3.0f);
        ArrayListOfFloats c = a.intersection(b);
        Assert.assertTrue((c.size() == 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testIntersection3() {
        ArrayListOfFloats a = new ArrayListOfFloats();
        a.add(3.0f).add(5.0f).add(7.0f).add(8.0f).add(9.0f);
        ArrayListOfFloats b = new ArrayListOfFloats();
        b.add(0.0f).add(1.0f).add(2.0f).add(3.0f);
        ArrayListOfFloats c = a.intersection(b);
        Assert.assertTrue(((double)Math.abs(3.0f - c.get(0)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)c.size());
    }

    @org.junit.Test
    public void testMerge1() {
        ArrayListOfFloats a = new ArrayListOfFloats();
        a.add(3.0f);
        a.add(7.0f);
        a.add(10.0f);
        ArrayListOfFloats b = new ArrayListOfFloats();
        b.add(0.0f);
        b.add(4.0f);
        b.add(9.0f);
        ArrayListOfFloats c = a.merge(b);
        Assert.assertEquals((long)6L, (long)c.size());
        Assert.assertTrue(((double)Math.abs(0.0f - c.get(0)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Math.abs(3.0f - c.get(1)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Math.abs(4.0f - c.get(2)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Math.abs(7.0f - c.get(3)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Math.abs(9.0f - c.get(4)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Math.abs(10.0f - c.get(5)) < 1.0E-4 ? 1 : 0) != 0);
        ArrayListOfFloats c2 = b.merge(a);
        Assert.assertEquals((Object)c, (Object)c2);
    }

    @org.junit.Test
    public void testMerge2() {
        ArrayListOfFloats a = new ArrayListOfFloats();
        a.add(3.0f);
        a.add(7.0f);
        a.add(10.0f);
        ArrayListOfFloats b = new ArrayListOfFloats();
        b.add(11.0f);
        b.add(19.0f);
        b.add(21.0f);
        ArrayListOfFloats c = a.merge(b);
        Assert.assertEquals((long)6L, (long)c.size());
        Assert.assertTrue(((double)Math.abs(3.0f - c.get(0)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Math.abs(7.0f - c.get(1)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Math.abs(10.0f - c.get(2)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Math.abs(11.0f - c.get(3)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Math.abs(19.0f - c.get(4)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Math.abs(21.0f - c.get(5)) < 1.0E-4 ? 1 : 0) != 0);
        ArrayListOfFloats c2 = b.merge(a);
        Assert.assertEquals((Object)c, (Object)c2);
    }

    @org.junit.Test
    public void testMerge3() {
        ArrayListOfFloats a = new ArrayListOfFloats();
        a.add(3.0f);
        a.add(7.0f);
        a.add(10.0f);
        ArrayListOfFloats b = new ArrayListOfFloats();
        ArrayListOfFloats c = a.merge(b);
        Assert.assertEquals((Object)c, (Object)a);
        ArrayListOfFloats c2 = b.merge(a);
        Assert.assertEquals((Object)c, (Object)c2);
    }

    @org.junit.Test
    public void testSubList() {
        ArrayListOfFloats a = new ArrayListOfFloats(new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f});
        ArrayListOfFloats c = a.subList(1, 5);
        Assert.assertEquals((long)5L, (long)c.size());
        Assert.assertTrue(((double)Math.abs(2.0f - c.get(0)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Math.abs(3.0f - c.get(1)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Math.abs(4.0f - c.get(2)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Math.abs(5.0f - c.get(3)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Math.abs(6.0f - c.get(4)) < 1.0E-4 ? 1 : 0) != 0);
        a.clear();
        Assert.assertEquals((long)5L, (long)c.size());
        Assert.assertTrue(((double)Math.abs(2.0f - c.get(0)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Math.abs(3.0f - c.get(1)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Math.abs(4.0f - c.get(2)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Math.abs(5.0f - c.get(3)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Math.abs(6.0f - c.get(4)) < 1.0E-4 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testAddUnique() {
        ArrayListOfFloats a = new ArrayListOfFloats(new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f});
        a.addUnique(new int[]{8, 0, 2, 5, -1, 11, 9});
        Assert.assertEquals((long)12L, (long)a.size());
        Assert.assertTrue(((double)Math.abs(0.0f - a.get(8)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Math.abs(-1.0f - a.get(9)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Math.abs(11.0f - a.get(10)) < 1.0E-4 ? 1 : 0) != 0);
        Assert.assertTrue(((double)Math.abs(9.0f - a.get(11)) < 1.0E-4 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testShift() {
        int i;
        int size = 100;
        int shift = 10;
        ArrayListOfFloats list = new ArrayListOfFloats();
        for (i = 0; i < size; ++i) {
            list.add((float)i);
        }
        list.shiftLastNToTop(shift);
        for (i = 0; i < list.size(); ++i) {
            Assert.assertTrue(((double)Math.abs((float)(size - shift + i) - list.get(i)) < 0.001 ? 1 : 0) != 0);
        }
        list.add((float)size);
        Assert.assertEquals((long)(shift + 1), (long)list.size());
        Assert.assertTrue(((double)Math.abs((float)size - list.get(shift)) < 0.001 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(ArrayListOfFloatsTest.class);
    }
}

