/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.array;

import java.io.IOException;
import java.util.List;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import tl.lin.data.array.ArrayListOfIntsWritable;
import tl.lin.data.pair.PairOfWritables;
import tl.lin.data.util.SequenceFileUtils;

public class ArrayListOfIntsWritableTest {
    int neg_one = -1;
    int zero = 0;
    int one = 1;
    int two = 2;
    int three = 3;
    int four = 4;
    int five = 5;
    int six = 6;
    int seven = 7;
    int nine = 9;

    @org.junit.Test
    public void testToString() {
        Assert.assertEquals((Object)"[1, 2, 3, 4, 5, 6, 7, 8, 9, 10]", (Object)new ArrayListOfIntsWritable(1, 11).toString());
        Assert.assertEquals((Object)"[1, 2, 3, 4, 5 ... (5 more) ]", (Object)new ArrayListOfIntsWritable(1, 11).toString(5));
        Assert.assertEquals((Object)"[1, 2, 3, 4, 5]", (Object)new ArrayListOfIntsWritable(1, 6).toString());
        Assert.assertEquals((Object)"[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11]", (Object)new ArrayListOfIntsWritable(1, 12).toString());
        Assert.assertEquals((Object)"[]", (Object)new ArrayListOfIntsWritable().toString());
    }

    @org.junit.Test
    public void testReadWrite() throws IOException {
        ArrayListOfIntsWritable arr = new ArrayListOfIntsWritable();
        arr.add(0, 1).add(1, 3).add(2, 5).add(3, 7);
        Configuration conf = new Configuration();
        Path tmp = new Path("tmp");
        FileSystem.get((Configuration)conf).delete(tmp, true);
        try {
            SequenceFile.Writer w = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)tmp), SequenceFile.Writer.keyClass(IntWritable.class), SequenceFile.Writer.valueClass(ArrayListOfIntsWritable.class)});
            w.append((Writable)new IntWritable(1), (Writable)arr);
            w.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
        List listOfKeysPairs = SequenceFileUtils.readFile((Path)tmp);
        FileSystem.get((Configuration)conf).delete(tmp, true);
        Assert.assertTrue((listOfKeysPairs.size() == 1 ? 1 : 0) != 0);
        ArrayListOfIntsWritable arrRead = (ArrayListOfIntsWritable)((PairOfWritables)listOfKeysPairs.get(0)).getRightElement();
        Assert.assertEquals((long)4L, (long)arrRead.size());
        Assert.assertEquals((long)1L, (long)arrRead.get(0));
        Assert.assertEquals((long)3L, (long)arrRead.get(1));
        Assert.assertEquals((long)5L, (long)arrRead.get(2));
        Assert.assertEquals((long)7L, (long)arrRead.get(3));
        arrRead.remove(0);
        arrRead.remove(0);
        arrRead.remove(1);
        Assert.assertEquals((long)1L, (long)arrRead.size());
        Assert.assertEquals((long)5L, (long)arrRead.get(0));
    }

    @org.junit.Test
    public void testCopyConstructor() {
        ArrayListOfIntsWritable a = new ArrayListOfIntsWritable();
        a.add(1).add(3).add(5);
        ArrayListOfIntsWritable b = new ArrayListOfIntsWritable(a);
        a.remove(0);
        Assert.assertEquals((long)1L, (long)b.get(0));
        Assert.assertEquals((long)3L, (long)b.get(1));
        Assert.assertEquals((long)5L, (long)b.get(2));
    }

    @org.junit.Test
    public void testCompare() {
        ArrayListOfIntsWritable a = new ArrayListOfIntsWritable();
        a.add(this.one).add(this.three).add(this.five);
        ArrayListOfIntsWritable b = new ArrayListOfIntsWritable();
        b.add(this.one).add(this.three).add(this.five).add(this.seven);
        Assert.assertTrue((b.compareTo(a) > 0 ? 1 : 0) != 0);
        b.remove(3);
        Assert.assertTrue((b.compareTo(a) == 0 ? 1 : 0) != 0);
        b.remove(2);
        Assert.assertTrue((b.compareTo(a) < 0 ? 1 : 0) != 0);
        ArrayListOfIntsWritable c = new ArrayListOfIntsWritable();
        Assert.assertTrue((b.compareTo(c) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((c.compareTo(a) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((a.compareTo(c) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((c.compareTo(b) < 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testCompare2() {
        ArrayListOfIntsWritable a = new ArrayListOfIntsWritable();
        a.add(this.one).add(this.three).add(this.six);
        ArrayListOfIntsWritable b = new ArrayListOfIntsWritable();
        b.add(this.one).add(this.three).add(this.four);
        Assert.assertTrue((a.compareTo(b) > 0 ? 1 : 0) != 0);
        ArrayListOfIntsWritable c = new ArrayListOfIntsWritable();
        c.add(this.one).add(this.three).add(this.four).add(this.nine);
        Assert.assertTrue((c.compareTo(a) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((b.compareTo(c) < 0 ? 1 : 0) != 0);
        ArrayListOfIntsWritable d = new ArrayListOfIntsWritable();
        d.add(this.two).add(this.four);
        ArrayListOfIntsWritable e = new ArrayListOfIntsWritable();
        e.add(this.zero).add(this.two);
        Assert.assertTrue((d.compareTo(a) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((d.compareTo(b) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((d.compareTo(c) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compareTo(a) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compareTo(b) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compareTo(c) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((e.compareTo(d) < 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testIO() {
        ArrayListOfIntsWritable a1 = new ArrayListOfIntsWritable();
        ArrayListOfIntsWritable a2 = new ArrayListOfIntsWritable();
        ArrayListOfIntsWritable a3 = new ArrayListOfIntsWritable();
        a1.add(1);
        a1.add(2);
        a2.add(3);
        Configuration conf = new Configuration();
        try {
            SequenceFile.Writer w = SequenceFile.createWriter((Configuration)conf, (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)new Path("tmp")), SequenceFile.Writer.keyClass(ArrayListOfIntsWritable.class), SequenceFile.Writer.valueClass(IntWritable.class)});
            w.append((Writable)a1, (Writable)new IntWritable(1));
            w.append((Writable)a2, (Writable)new IntWritable(2));
            w.append((Writable)a3, (Writable)new IntWritable(3));
            w.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
        try {
            SequenceFile.Reader reader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)new Path("tmp"))});
            ArrayListOfIntsWritable key = (ArrayListOfIntsWritable)reader.getKeyClass().newInstance();
            IntWritable value = (IntWritable)reader.getValueClass().newInstance();
            while (reader.next((Writable)key, (Writable)value)) {
                value.get();
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalAccessException e) {
            Assert.assertTrue((boolean)false);
            e.printStackTrace();
        }
    }

    public static Test suite() {
        return new JUnit4TestAdapter(ArrayListOfIntsWritableTest.class);
    }
}

