/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.array;

import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import tl.lin.data.array.ArrayListOfLongs;

public class ArrayListOfLongsTest {
    long neg_one = -1L;
    long zero = 0L;
    long one = 1L;
    long two = 2L;
    long three = 3L;
    long four = 4L;
    long five = 5L;
    long six = 6L;
    long seven = 7L;
    long nine = 9L;

    @org.junit.Test
    public void testInitialSize() {
        ArrayListOfLongs a = new ArrayListOfLongs();
        Assert.assertEquals((long)0L, (long)a.size());
    }

    @org.junit.Test
    public void testSetBounds() {
        ArrayListOfLongs a = new ArrayListOfLongs(10);
        Assert.assertEquals((long)0L, (long)a.size());
        a.set(0, 1L);
        Assert.assertEquals((long)1L, (long)a.size());
        a.set(5, 1L);
        Assert.assertEquals((long)6L, (long)a.size());
        a.set(1, 1L);
        Assert.assertEquals((long)6L, (long)a.size());
        a.set(9, 1L);
        Assert.assertEquals((long)10L, (long)a.size());
        a.set(99, 1L);
        Assert.assertEquals((long)100L, (long)a.size());
        a.set(0, 2L);
        Assert.assertEquals((long)100L, (long)a.size());
    }

    @org.junit.Test
    public void testRemoveWithinBounds() {
        ArrayListOfLongs a = new ArrayListOfLongs();
        a.add(this.one).add(this.three).add(this.five).add(this.seven);
        Assert.assertTrue((this.one == a.remove(0) ? 1 : 0) != 0);
        Assert.assertTrue((this.three == a.get(0) ? 1 : 0) != 0);
        Assert.assertTrue((this.five == a.get(1) ? 1 : 0) != 0);
        Assert.assertTrue((this.five == a.remove(1) ? 1 : 0) != 0);
        Assert.assertTrue((this.seven == a.get(2) ? 1 : 0) != 0);
    }

    @org.junit.Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testRemoveOutOfBounds() {
        ArrayListOfLongs a = new ArrayListOfLongs();
        a.add(this.one).add(this.three).add(this.five).add(this.seven);
        a.remove(4);
    }

    @org.junit.Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testRemoveOutOfBounds2() {
        ArrayListOfLongs a = new ArrayListOfLongs();
        a.add(this.neg_one);
        a.remove(-1);
    }

    @org.junit.Test
    public void testBasic1() {
        int i;
        int size = 100000;
        Random r = new Random();
        long[] ints = new long[size];
        ArrayListOfLongs list = new ArrayListOfLongs();
        for (i = 0; i < size; ++i) {
            long k = r.nextLong();
            list.add(k);
            ints[i] = k;
        }
        for (i = 0; i < size; ++i) {
            long v = list.get(i);
            Assert.assertEquals((long)ints[i], (long)v);
        }
    }

    @org.junit.Test
    public void testArrayConstructor() {
        long[] arr = new long[]{1L, 2L, 3L, 4L, 5L};
        Assert.assertEquals((long)5L, (long)arr.length);
        ArrayListOfLongs list = new ArrayListOfLongs(arr);
        list.remove(2);
        Assert.assertEquals((long)1L, (long)arr[0]);
        Assert.assertEquals((long)2L, (long)arr[1]);
        Assert.assertEquals((long)3L, (long)arr[2]);
        Assert.assertEquals((long)4L, (long)arr[3]);
        Assert.assertEquals((long)5L, (long)arr[4]);
    }

    @org.junit.Test
    public void testRemove() {
        ArrayListOfLongs list = new ArrayListOfLongs();
        for (int i = 0; i < 10; ++i) {
            list.add((long)i);
        }
        list.remove(list.indexOf(5L));
        Assert.assertEquals((long)9L, (long)list.size());
        Assert.assertEquals((long)0L, (long)list.get(0));
        Assert.assertEquals((long)1L, (long)list.get(1));
        Assert.assertEquals((long)2L, (long)list.get(2));
        Assert.assertEquals((long)3L, (long)list.get(3));
        Assert.assertEquals((long)4L, (long)list.get(4));
        Assert.assertEquals((long)6L, (long)list.get(5));
        Assert.assertEquals((long)7L, (long)list.get(6));
        Assert.assertEquals((long)8L, (long)list.get(7));
        Assert.assertEquals((long)9L, (long)list.get(8));
        list.remove(list.indexOf(9L));
        Assert.assertEquals((long)8L, (long)list.size());
        Assert.assertEquals((long)0L, (long)list.get(0));
        Assert.assertEquals((long)1L, (long)list.get(1));
        Assert.assertEquals((long)2L, (long)list.get(2));
        Assert.assertEquals((long)3L, (long)list.get(3));
        Assert.assertEquals((long)4L, (long)list.get(4));
        Assert.assertEquals((long)6L, (long)list.get(5));
        Assert.assertEquals((long)7L, (long)list.get(6));
        Assert.assertEquals((long)8L, (long)list.get(7));
    }

    @org.junit.Test
    public void testUpdate() {
        int i;
        int size = 100000;
        Random r = new Random();
        long[] longs = new long[size];
        ArrayListOfLongs list = new ArrayListOfLongs();
        for (i = 0; i < size; ++i) {
            long k = r.nextLong();
            list.add(k);
            longs[i] = k;
        }
        Assert.assertEquals((long)size, (long)list.size());
        for (i = 0; i < size; ++i) {
            list.set(i, longs[i] + 1L);
        }
        Assert.assertEquals((long)size, (long)list.size());
        for (i = 0; i < size; ++i) {
            long v = list.get(i);
            Assert.assertEquals((long)(longs[i] + 1L), (long)v);
        }
    }

    @org.junit.Test
    public void testTrim1() {
        int i;
        int size = 89;
        Random r = new Random();
        long[] longs = new long[size];
        ArrayListOfLongs list = new ArrayListOfLongs();
        for (i = 0; i < size; ++i) {
            long k = r.nextLong();
            list.add(k);
            longs[i] = k;
        }
        for (i = 0; i < size; ++i) {
            long v = list.get(i);
            Assert.assertEquals((long)longs[i], (long)v);
        }
        long[] rawArray = list.getArray();
        int lenBefore = rawArray.length;
        list.trimToSize();
        long[] rawArrayAfter = list.getArray();
        int lenAfter = rawArrayAfter.length;
        Assert.assertEquals((long)89L, (long)lenAfter);
        Assert.assertTrue((lenBefore > lenAfter ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testClone() {
        int i;
        int size = 100000;
        Random r = new Random();
        long[] longs = new long[size];
        ArrayListOfLongs list1 = new ArrayListOfLongs();
        for (int i2 = 0; i2 < size; ++i2) {
            long k = r.nextLong();
            list1.add(k);
            longs[i2] = k;
        }
        ArrayListOfLongs list2 = list1.clone();
        Assert.assertEquals((long)size, (long)list1.size());
        Assert.assertEquals((long)size, (long)list2.size());
        for (i = 0; i < size; ++i) {
            list2.set(i, longs[i] + 1L);
        }
        Assert.assertEquals((long)size, (long)list1.size());
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((long)longs[i], (long)list1.get(i));
        }
        Assert.assertEquals((long)size, (long)list1.size());
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((long)(longs[i] + 1L), (long)list2.get(i));
        }
    }

    @org.junit.Test
    public void testToString1() {
        Assert.assertEquals((Object)"[1, 2, 3, 4, 5, 6, 7, 8, 9, 10]", (Object)new ArrayListOfLongs(1, 11).toString());
        Assert.assertEquals((Object)"[1, 2, 3, 4, 5 ... (5 more) ]", (Object)new ArrayListOfLongs(1, 11).toString(5));
        Assert.assertEquals((Object)"[1, 2, 3, 4, 5]", (Object)new ArrayListOfLongs(1, 6).toString());
        Assert.assertEquals((Object)"[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11]", (Object)new ArrayListOfLongs(1, 12).toString(11));
        Assert.assertEquals((Object)"[]", (Object)new ArrayListOfLongs().toString());
    }

    @org.junit.Test
    public void testToString2() {
        long v;
        int i;
        int size = 10;
        Random r = new Random();
        ArrayListOfLongs list = new ArrayListOfLongs();
        while (list.size < size) {
            long next = r.nextLong();
            if (list.contains(next)) continue;
            list.add(next);
        }
        String out = list.toString();
        for (i = 0; i < size; ++i) {
            v = list.get(i);
            Assert.assertTrue((out.indexOf(new Long(v).toString()) != -1 ? 1 : 0) != 0);
        }
        while (list.size < size * 2) {
            long next = r.nextLong();
            if (list.contains(next)) continue;
            list.add(next);
        }
        out = list.toString();
        for (i = size; i < size + size; ++i) {
            v = list.get(i);
            Assert.assertTrue((out.indexOf(new Long(v).toString()) == -1 ? 1 : 0) != 0);
        }
        Assert.assertTrue((out.indexOf(size + " more") != -1 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testIterable() {
        int i;
        int size = 1000;
        Random r = new Random();
        long[] longs = new long[size];
        ArrayListOfLongs list = new ArrayListOfLongs();
        for (i = 0; i < size; ++i) {
            long k = r.nextLong();
            list.add(k);
            longs[i] = k;
        }
        i = 0;
        for (Long v : list) {
            Assert.assertEquals((long)longs[i++], (long)v);
        }
    }

    @org.junit.Test
    public void testSetSize() {
        ArrayListOfLongs list = new ArrayListOfLongs();
        list.add(5L);
        Assert.assertEquals((long)1L, (long)list.size);
        Assert.assertEquals((long)5L, (long)list.get(0));
        list.setSize(5);
        Assert.assertEquals((long)5L, (long)list.size);
        Assert.assertEquals((long)0L, (long)list.get(1));
        Assert.assertEquals((long)0L, (long)list.get(2));
        Assert.assertEquals((long)0L, (long)list.get(3));
        Assert.assertEquals((long)0L, (long)list.get(4));
        list.add(12L);
        Assert.assertEquals((long)6L, (long)list.size);
        Assert.assertEquals((long)12L, (long)list.get(5));
    }

    @org.junit.Test
    public void testSort() {
        ArrayListOfLongs a = new ArrayListOfLongs();
        Assert.assertEquals((long)0L, (long)a.size());
        a.add(5L).add(6L).add(1L).add(4L);
        Assert.assertEquals((long)4L, (long)a.size());
        a.sort();
        Assert.assertEquals((long)4L, (long)a.size());
        Assert.assertEquals((long)1L, (long)a.get(0));
        Assert.assertEquals((long)4L, (long)a.get(1));
        Assert.assertEquals((long)5L, (long)a.get(2));
        Assert.assertEquals((long)6L, (long)a.get(3));
    }

    @org.junit.Test
    public void testIntersection1() {
        ArrayListOfLongs a = new ArrayListOfLongs();
        a.add(5L).add(3L).add(1L);
        a.sort();
        ArrayListOfLongs b = new ArrayListOfLongs();
        b.add(0L).add(1L).add(2L).add(3L);
        ArrayListOfLongs c = a.intersection(b);
        Assert.assertEquals((long)1L, (long)c.get(0));
        Assert.assertEquals((long)3L, (long)c.get(1));
        Assert.assertEquals((long)2L, (long)c.size());
    }

    @org.junit.Test
    public void testIntersection2() {
        ArrayListOfLongs a = new ArrayListOfLongs();
        a.add(5L);
        ArrayListOfLongs b = new ArrayListOfLongs();
        b.add(0L).add(1L).add(2L).add(3L);
        ArrayListOfLongs c = a.intersection(b);
        Assert.assertTrue((c.size() == 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testIntersection3() {
        ArrayListOfLongs a = new ArrayListOfLongs();
        a.add(3L).add(5L).add(7L).add(8L).add(9L);
        ArrayListOfLongs b = new ArrayListOfLongs();
        b.add(0L).add(1L).add(2L).add(3L);
        ArrayListOfLongs c = a.intersection(b);
        Assert.assertEquals((long)3L, (long)c.get(0));
        Assert.assertEquals((long)1L, (long)c.size());
    }

    @org.junit.Test
    public void testIntersection4() {
        ArrayListOfLongs a = new ArrayListOfLongs();
        a.add(3L);
        ArrayListOfLongs b = new ArrayListOfLongs();
        b.add(0L);
        ArrayListOfLongs c = a.intersection(b);
        Assert.assertEquals((long)0L, (long)c.size());
    }

    @org.junit.Test
    public void testMerge1() {
        ArrayListOfLongs a = new ArrayListOfLongs();
        a.add(3L);
        a.add(7L);
        a.add(10L);
        ArrayListOfLongs b = new ArrayListOfLongs();
        b.add(0L);
        b.add(4L);
        b.add(9L);
        ArrayListOfLongs c = a.merge(b);
        Assert.assertEquals((long)6L, (long)c.size());
        Assert.assertEquals((long)0L, (long)c.get(0));
        Assert.assertEquals((long)3L, (long)c.get(1));
        Assert.assertEquals((long)4L, (long)c.get(2));
        Assert.assertEquals((long)7L, (long)c.get(3));
        Assert.assertEquals((long)9L, (long)c.get(4));
        Assert.assertEquals((long)10L, (long)c.get(5));
        ArrayListOfLongs c2 = b.merge(a);
        Assert.assertEquals((Object)c, (Object)c2);
    }

    @org.junit.Test
    public void testMerge2() {
        ArrayListOfLongs a = new ArrayListOfLongs();
        a.add(3L);
        a.add(7L);
        a.add(10L);
        ArrayListOfLongs b = new ArrayListOfLongs();
        b.add(11L);
        b.add(19L);
        b.add(21L);
        ArrayListOfLongs c = a.merge(b);
        Assert.assertEquals((long)6L, (long)c.size());
        Assert.assertEquals((long)3L, (long)c.get(0));
        Assert.assertEquals((long)7L, (long)c.get(1));
        Assert.assertEquals((long)10L, (long)c.get(2));
        Assert.assertEquals((long)11L, (long)c.get(3));
        Assert.assertEquals((long)19L, (long)c.get(4));
        Assert.assertEquals((long)21L, (long)c.get(5));
        ArrayListOfLongs c2 = b.merge(a);
        Assert.assertEquals((Object)c, (Object)c2);
    }

    @org.junit.Test
    public void testMerge3() {
        ArrayListOfLongs a = new ArrayListOfLongs();
        a.add(3L);
        a.add(7L);
        a.add(10L);
        ArrayListOfLongs b = new ArrayListOfLongs();
        ArrayListOfLongs c = a.merge(b);
        Assert.assertEquals((Object)c, (Object)a);
        ArrayListOfLongs c2 = b.merge(a);
        Assert.assertEquals((Object)c, (Object)c2);
    }

    @org.junit.Test
    public void testSubList() {
        ArrayListOfLongs a = new ArrayListOfLongs(new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L});
        ArrayListOfLongs b = a.subList(1, 5);
        Assert.assertEquals((long)5L, (long)b.size());
        Assert.assertEquals((long)2L, (long)b.get(0));
        Assert.assertEquals((long)3L, (long)b.get(1));
        Assert.assertEquals((long)4L, (long)b.get(2));
        Assert.assertEquals((long)5L, (long)b.get(3));
        Assert.assertEquals((long)6L, (long)b.get(4));
        a.clear();
        Assert.assertEquals((long)5L, (long)b.size());
        Assert.assertEquals((long)2L, (long)b.get(0));
        Assert.assertEquals((long)3L, (long)b.get(1));
        Assert.assertEquals((long)4L, (long)b.get(2));
        Assert.assertEquals((long)5L, (long)b.get(3));
        Assert.assertEquals((long)6L, (long)b.get(4));
    }

    @org.junit.Test
    public void testAddUnique() {
        ArrayListOfLongs a = new ArrayListOfLongs(new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L});
        a.addUnique(new long[]{8L, 0L, 2L, 5L, -1L, 11L, 9L});
        Assert.assertEquals((long)12L, (long)a.size());
        Assert.assertEquals((long)0L, (long)a.get(8));
        Assert.assertEquals((long)-1L, (long)a.get(9));
        Assert.assertEquals((long)11L, (long)a.get(10));
        Assert.assertEquals((long)9L, (long)a.get(11));
    }

    public static Test suite() {
        return new JUnit4TestAdapter(ArrayListOfLongsTest.class);
    }
}

