/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.array;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import tl.lin.data.array.ArrayListWritableComparable;

public class ArrayListWritableComparableTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        ArrayListWritableComparable list = new ArrayListWritableComparable();
        list.add((Object)new Text("hi"));
        list.add((Object)new Text("there"));
        Assert.assertEquals((Object)((Text)list.get(0)).toString(), (Object)"hi");
        Assert.assertEquals((Object)((Text)list.get(1)).toString(), (Object)"there");
    }

    @org.junit.Test
    public void testSerialize1() throws IOException {
        ArrayListWritableComparable list = new ArrayListWritableComparable();
        list.add((Object)new Text("hi"));
        list.add((Object)new Text("there"));
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        list.write((DataOutput)dataOut);
        ArrayListWritableComparable newList = new ArrayListWritableComparable();
        newList.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((Object)((Text)newList.get(0)).toString(), (Object)"hi");
        Assert.assertEquals((Object)((Text)newList.get(1)).toString(), (Object)"there");
    }

    @org.junit.Test
    public void testSerialize2() throws IOException {
        ArrayListWritableComparable list = new ArrayListWritableComparable();
        list.add((Object)new FloatWritable(0.3f));
        list.add((Object)new FloatWritable(3244.2f));
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        list.write((DataOutput)dataOut);
        ArrayListWritableComparable newList = new ArrayListWritableComparable();
        newList.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertTrue((((FloatWritable)newList.get(0)).get() == 0.3f ? 1 : 0) != 0);
        Assert.assertTrue((((FloatWritable)newList.get(1)).get() == 3244.2f ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testToString() {
        ArrayListWritableComparable list = new ArrayListWritableComparable();
        list.add((Object)new Text("hi"));
        list.add((Object)new Text("there"));
        Assert.assertEquals((Object)list.toString(), (Object)"[hi, there]");
    }

    @org.junit.Test
    public void testClear() {
        ArrayListWritableComparable list = new ArrayListWritableComparable();
        list.add((Object)new Text("hi"));
        list.add((Object)new Text("there"));
        list.clear();
        Assert.assertEquals((long)list.size(), (long)0L);
    }

    @org.junit.Test
    public void testEmpty() throws IOException {
        ArrayListWritableComparable list = new ArrayListWritableComparable();
        Assert.assertTrue((list.size() == 0 ? 1 : 0) != 0);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        list.write((DataOutput)dataOut);
        ArrayListWritableComparable newList = new ArrayListWritableComparable();
        newList.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertTrue((newList.size() == 0 ? 1 : 0) != 0);
        newList.add((Object)new Text("Hey"));
        Assert.assertEquals((Object)newList.get(0), (Object)new Text("Hey"));
    }

    @org.junit.Test
    public void testListMethods() {
        IntWritable a = new IntWritable(1);
        IntWritable b = new IntWritable(2);
        IntWritable c = new IntWritable(3);
        IntWritable d = new IntWritable(4);
        IntWritable e = new IntWritable(5);
        ArrayListWritableComparable list = new ArrayListWritableComparable();
        Assert.assertTrue((boolean)list.isEmpty());
        list.add((Object)a);
        list.add((Object)b);
        list.add((Object)c);
        list.add((Object)d);
        list.add((Object)e);
        int pos = 0;
        for (IntWritable i : list) {
            Assert.assertEquals((Object)i, (Object)list.get(pos));
            ++pos;
        }
        Assert.assertTrue((list.indexOf((Object)d) == 3 ? 1 : 0) != 0);
        list.add(2, (Object)a);
        Assert.assertTrue((list.lastIndexOf((Object)a) == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)list.get(2), (Object)list.get(0));
        Assert.assertTrue((list.size() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)list.contains((Object)c));
        Assert.assertTrue((!list.contains((Object)new IntWritable(123)) ? 1 : 0) != 0);
        ArrayList<IntWritable> otherList = new ArrayList<IntWritable>();
        otherList.add(a);
        otherList.add(b);
        otherList.add(c);
        Assert.assertTrue((boolean)list.containsAll(otherList));
        otherList.add(new IntWritable(200));
        Assert.assertTrue((!list.containsAll(otherList) ? 1 : 0) != 0);
        Assert.assertEquals((Object)a, otherList.remove(0));
        Assert.assertTrue((boolean)list.remove((Object)d));
    }

    @org.junit.Test
    public void testSorting1() {
        ArrayListWritableComparable list1 = new ArrayListWritableComparable();
        ArrayListWritableComparable list2 = new ArrayListWritableComparable();
        list1.add((Object)new Text("a"));
        Assert.assertTrue((list1.compareTo(list2) > 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testSorting2() {
        ArrayListWritableComparable list1 = new ArrayListWritableComparable();
        ArrayListWritableComparable list2 = new ArrayListWritableComparable();
        list1.add((Object)new Text("a"));
        list2.add((Object)new Text("b"));
        Assert.assertTrue((list1.compareTo(list2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((list2.compareTo(list1) > 0 ? 1 : 0) != 0);
        list2.clear();
        list2.add((Object)new Text("a"));
        Assert.assertTrue((list1.compareTo(list2) == 0 ? 1 : 0) != 0);
        list1.add((Object)new Text("a"));
        list2.add((Object)new Text("b"));
        Assert.assertTrue((list1.compareTo(list2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((list2.compareTo(list1) > 0 ? 1 : 0) != 0);
        list1.add((Object)new Text("a"));
        Assert.assertTrue((list1.compareTo(list2) < 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testSorting3() {
        ArrayListWritableComparable list1 = new ArrayListWritableComparable();
        ArrayListWritableComparable list2 = new ArrayListWritableComparable();
        ArrayListWritableComparable list3 = new ArrayListWritableComparable();
        list1.add((Object)new Text("a"));
        list2.add((Object)new Text("a"));
        list2.add((Object)new Text("a"));
        list3.add((Object)new Text("a"));
        list3.add((Object)new Text("a"));
        Assert.assertTrue((list2.compareTo(list3) == 0 ? 1 : 0) != 0);
        list3.add((Object)new Text("a"));
        Assert.assertTrue((list1.compareTo(list2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((list1.compareTo(list3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((list2.compareTo(list1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((list2.compareTo(list3) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((list3.compareTo(list1) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((list3.compareTo(list2) > 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(ArrayListWritableComparableTest.class);
    }
}

