/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.array;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import tl.lin.data.array.ArrayListWritable;

public class ArrayListWritableTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        ArrayListWritable list = new ArrayListWritable();
        list.add((Object)new Text("hi"));
        list.add((Object)new Text("there"));
        Assert.assertEquals((Object)((Text)list.get(0)).toString(), (Object)"hi");
        Assert.assertEquals((Object)((Text)list.get(1)).toString(), (Object)"there");
    }

    @org.junit.Test
    public void testSerialize1() throws IOException {
        ArrayListWritable list = new ArrayListWritable();
        list.add((Object)new Text("hi"));
        list.add((Object)new Text("there"));
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        list.write((DataOutput)dataOut);
        ArrayListWritable newList = new ArrayListWritable();
        newList.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((Object)((Text)newList.get(0)).toString(), (Object)"hi");
        Assert.assertEquals((Object)((Text)newList.get(1)).toString(), (Object)"there");
    }

    @org.junit.Test
    public void testSerialize2() throws IOException {
        ArrayListWritable list = new ArrayListWritable();
        list.add((Object)new FloatWritable(0.3f));
        list.add((Object)new FloatWritable(3244.2f));
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        list.write((DataOutput)dataOut);
        ArrayListWritable newList = new ArrayListWritable();
        newList.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertTrue((((FloatWritable)newList.get(0)).get() == 0.3f ? 1 : 0) != 0);
        Assert.assertTrue((((FloatWritable)newList.get(1)).get() == 3244.2f ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testSerialize3() throws IOException {
        ArrayListWritable list = new ArrayListWritable();
        list.add((Object)new Text("hi"));
        list.add((Object)new IntWritable(1));
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        list.write((DataOutput)dataOut);
        ArrayListWritable newList = new ArrayListWritable();
        newList.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        try {
            Assert.assertEquals((Object)((Writable)newList.get(0)).toString(), (Object)"hi");
            IntWritable i = (IntWritable)newList.get(1);
            Assert.assertEquals((long)i.get(), (long)1L);
            Assert.assertTrue((boolean)false);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @org.junit.Test
    public void testToString() {
        ArrayListWritable list = new ArrayListWritable();
        list.add((Object)new Text("hi"));
        list.add((Object)new Text("there"));
        Assert.assertEquals((Object)list.toString(), (Object)"[hi, there]");
    }

    @org.junit.Test
    public void testClear() {
        ArrayListWritable list = new ArrayListWritable();
        list.add((Object)new Text("hi"));
        list.add((Object)new Text("there"));
        list.clear();
        Assert.assertEquals((long)list.size(), (long)0L);
    }

    @org.junit.Test
    public void testEmpty() throws IOException {
        ArrayListWritable list = new ArrayListWritable();
        Assert.assertTrue((list.size() == 0 ? 1 : 0) != 0);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        list.write((DataOutput)dataOut);
        ArrayListWritable newList = new ArrayListWritable();
        newList.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertTrue((newList.size() == 0 ? 1 : 0) != 0);
        newList.add((Object)new Text("Hey"));
        Assert.assertEquals((Object)newList.get(0), (Object)new Text("Hey"));
    }

    @org.junit.Test
    public void testListMethods() {
        IntWritable a = new IntWritable(1);
        IntWritable b = new IntWritable(2);
        IntWritable c = new IntWritable(3);
        IntWritable d = new IntWritable(4);
        IntWritable e = new IntWritable(5);
        ArrayListWritable list = new ArrayListWritable();
        Assert.assertTrue((boolean)list.isEmpty());
        list.add((Object)a);
        list.add((Object)b);
        list.add((Object)c);
        list.add((Object)d);
        list.add((Object)e);
        int pos = 0;
        for (IntWritable i : list) {
            Assert.assertEquals((Object)i, (Object)list.get(pos));
            ++pos;
        }
        Assert.assertTrue((list.indexOf((Object)d) == 3 ? 1 : 0) != 0);
        list.add(2, (Object)a);
        Assert.assertTrue((list.lastIndexOf((Object)a) == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)list.get(2), (Object)list.get(0));
        Assert.assertTrue((list.size() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)list.contains((Object)c));
        Assert.assertTrue((!list.contains((Object)new IntWritable(123)) ? 1 : 0) != 0);
        ArrayList<IntWritable> otherList = new ArrayList<IntWritable>();
        otherList.add(a);
        otherList.add(b);
        otherList.add(c);
        Assert.assertTrue((boolean)list.containsAll(otherList));
        otherList.add(new IntWritable(200));
        Assert.assertTrue((!list.containsAll(otherList) ? 1 : 0) != 0);
        Assert.assertEquals((Object)a, otherList.remove(0));
        Assert.assertTrue((boolean)list.remove((Object)d));
    }

    public static Test suite() {
        return new JUnit4TestAdapter(ArrayListWritableTest.class);
    }
}

