/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.array;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import tl.lin.data.array.LongArrayWritable;

public class LongArrayWritableTest {
    @org.junit.Test
    public void testBasic1() throws IOException {
        LongArrayWritable array1 = new LongArrayWritable(new long[]{1L, 3L, 53L, 97L, 286L});
        Assert.assertEquals((long)1L, (long)array1.get(0));
        Assert.assertEquals((long)3L, (long)array1.get(1));
        Assert.assertEquals((long)53L, (long)array1.get(2));
        Assert.assertEquals((long)97L, (long)array1.get(3));
        Assert.assertEquals((long)286L, (long)array1.get(4));
        Assert.assertEquals((long)5L, (long)array1.size());
        LongArrayWritable array2 = new LongArrayWritable(new long[]{1L, 3L, 53L, 97L, 286L}, 3);
        Assert.assertEquals((long)1L, (long)array2.get(0));
        Assert.assertEquals((long)3L, (long)array2.get(1));
        Assert.assertEquals((long)53L, (long)array2.get(2));
        Assert.assertEquals((long)3L, (long)array2.size());
        LongArrayWritable array3 = new LongArrayWritable(new long[0]);
        Assert.assertEquals((long)0L, (long)array3.size());
    }

    @org.junit.Test
    public void testBasic2() throws IOException {
        LongArrayWritable array = new LongArrayWritable();
        Assert.assertEquals((long)0L, (long)array.size());
        long[] list1 = new long[]{1L, 3L, 53L, 97L, 286L};
        array.setArray(list1);
        Assert.assertEquals((long)1L, (long)array.get(0));
        Assert.assertEquals((long)3L, (long)array.get(1));
        Assert.assertEquals((long)53L, (long)array.get(2));
        Assert.assertEquals((long)97L, (long)array.get(3));
        Assert.assertEquals((long)286L, (long)array.get(4));
        Assert.assertEquals((long)list1.length, (long)array.size());
        array.set(0, 2L);
        array.set(3, -5L);
        Assert.assertEquals((long)2L, (long)array.get(0));
        Assert.assertEquals((long)-5L, (long)array.get(3));
        long[] list2 = new long[]{9L, -1L, 6L, 22L, 76L};
        array.setArray(list2, 3);
        Assert.assertEquals((long)9L, (long)array.get(0));
        Assert.assertEquals((long)-1L, (long)array.get(1));
        Assert.assertEquals((long)6L, (long)array.get(2));
        Assert.assertEquals((long)3L, (long)array.size());
        array.setArray(null);
        Assert.assertEquals((long)0L, (long)array.size());
        Assert.assertEquals((long)0L, (long)array.getArray().length);
    }

    @org.junit.Test
    public void testSerialize1() throws IOException {
        LongArrayWritable array = new LongArrayWritable(new long[]{1L, 3L, 53L, 97L, 286L});
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        array.write((DataOutput)dataOut);
        LongArrayWritable array2 = new LongArrayWritable();
        array2.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((long)5L, (long)array2.size());
        Assert.assertEquals((long)1L, (long)array2.get(0));
        Assert.assertEquals((long)3L, (long)array2.get(1));
        Assert.assertEquals((long)53L, (long)array2.get(2));
        Assert.assertEquals((long)97L, (long)array2.get(3));
        Assert.assertEquals((long)286L, (long)array2.get(4));
    }

    @org.junit.Test
    public void testSerialize2() throws IOException {
        LongArrayWritable array = new LongArrayWritable(new long[]{1L, 3L, 53L, 97L, 286L}, 4);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        array.write((DataOutput)dataOut);
        LongArrayWritable array2 = new LongArrayWritable();
        array2.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((long)4L, (long)array2.size());
        Assert.assertEquals((long)1L, (long)array2.get(0));
        Assert.assertEquals((long)3L, (long)array2.get(1));
        Assert.assertEquals((long)53L, (long)array2.get(2));
        Assert.assertEquals((long)97L, (long)array2.get(3));
    }

    @org.junit.Test
    public void testSerialize3() throws IOException {
        LongArrayWritable array = new LongArrayWritable(new long[]{1L, 2L, 3L, 4L, 5L});
        ByteArrayOutputStream bytesOut1 = new ByteArrayOutputStream();
        DataOutputStream dataOut1 = new DataOutputStream(bytesOut1);
        array.write((DataOutput)dataOut1);
        LongArrayWritable array2 = new LongArrayWritable();
        array2.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut1.toByteArray())));
        Assert.assertEquals((long)5L, (long)array2.size());
        Assert.assertEquals((long)1L, (long)array2.get(0));
        Assert.assertEquals((long)2L, (long)array2.get(1));
        Assert.assertEquals((long)3L, (long)array2.get(2));
        Assert.assertEquals((long)4L, (long)array2.get(3));
        Assert.assertEquals((long)5L, (long)array2.get(4));
        array.setArray(new long[]{6L, 7L});
        ByteArrayOutputStream bytesOut2 = new ByteArrayOutputStream();
        DataOutputStream dataOut2 = new DataOutputStream(bytesOut2);
        array.write((DataOutput)dataOut2);
        LongArrayWritable array3 = new LongArrayWritable();
        array3.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut2.toByteArray())));
        Assert.assertEquals((long)2L, (long)array3.size());
        Assert.assertEquals((long)6L, (long)array3.get(0));
        Assert.assertEquals((long)7L, (long)array3.get(1));
    }

    @org.junit.Test
    public void testSerializeEmpty() throws IOException {
        LongArrayWritable array = new LongArrayWritable();
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        array.write((DataOutput)dataOut);
        LongArrayWritable array2 = new LongArrayWritable();
        array2.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((long)0L, (long)array2.size());
        Assert.assertTrue((array2.getArray() != null ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)array2.getArray().length);
    }

    @org.junit.Test
    public void testClone1() throws IOException {
        LongArrayWritable array = new LongArrayWritable(new long[]{1L, 3L, 53L, 97L, 286L});
        Assert.assertEquals((long)1L, (long)array.get(0));
        Assert.assertEquals((long)3L, (long)array.get(1));
        Assert.assertEquals((long)53L, (long)array.get(2));
        Assert.assertEquals((long)97L, (long)array.get(3));
        Assert.assertEquals((long)286L, (long)array.get(4));
        Assert.assertEquals((long)5L, (long)array.size());
        long[] p = array.getClone();
        p[0] = 8L;
        p[1] = 7L;
        p[2] = -4L;
        Assert.assertEquals((long)1L, (long)array.get(0));
        Assert.assertEquals((long)3L, (long)array.get(1));
        Assert.assertEquals((long)53L, (long)array.get(2));
        Assert.assertEquals((long)5L, (long)array.size());
    }

    @org.junit.Test
    public void testClone2() throws IOException {
        LongArrayWritable array = new LongArrayWritable(new long[]{1L, 3L, 53L, 97L, 286L}, 2);
        Assert.assertEquals((long)1L, (long)array.get(0));
        Assert.assertEquals((long)3L, (long)array.get(1));
        Assert.assertEquals((long)2L, (long)array.size());
        long[] p = array.getClone();
        Assert.assertEquals((long)2L, (long)p.length);
        p[0] = 8L;
        p[1] = 7L;
        Assert.assertEquals((long)1L, (long)array.get(0));
        Assert.assertEquals((long)3L, (long)array.get(1));
        Assert.assertEquals((long)2L, (long)array.size());
    }

    public static Test suite() {
        return new JUnit4TestAdapter(LongArrayWritableTest.class);
    }
}

