/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.fd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.junit.Assert;
import tl.lin.data.fd.Int2IntFrequencyDistribution;
import tl.lin.data.fd.SortableEntries;
import tl.lin.data.pair.PairOfInts;

public class Int2IntFrequencyDistributionTestBase {
    protected void test1Common(Int2IntFrequencyDistribution fd) {
        Assert.assertEquals((long)0L, (long)fd.get(1));
        fd.increment(1);
        fd.increment(2);
        fd.increment(3);
        fd.increment(2);
        fd.increment(3);
        fd.increment(3);
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)6L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)1L, (long)fd.get(1));
        Assert.assertEquals((long)2L, (long)fd.get(2));
        Assert.assertEquals((long)3L, (long)fd.get(3));
        Assert.assertEquals((double)0.1666666716337204, (double)fd.computeRelativeFrequency(1), (double)1.0E-5);
        Assert.assertEquals((double)0.3333333432674408, (double)fd.computeRelativeFrequency(2), (double)1.0E-5);
        Assert.assertEquals((double)0.5, (double)fd.computeRelativeFrequency(3), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.1666666716337204), (double)fd.computeLogRelativeFrequency(1), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.3333333432674408), (double)fd.computeLogRelativeFrequency(2), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.5), (double)fd.computeLogRelativeFrequency(3), (double)1.0E-5);
        fd.decrement(3);
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)5L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)1L, (long)fd.get(1));
        Assert.assertEquals((long)2L, (long)fd.get(2));
        Assert.assertEquals((long)2L, (long)fd.get(3));
        Assert.assertEquals((double)0.2f, (double)fd.computeRelativeFrequency(1), (double)1.0E-5);
        Assert.assertEquals((double)0.4f, (double)fd.computeRelativeFrequency(2), (double)1.0E-5);
        Assert.assertEquals((double)0.4f, (double)fd.computeRelativeFrequency(3), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.2f), (double)fd.computeLogRelativeFrequency(1), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.4f), (double)fd.computeLogRelativeFrequency(2), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.4f), (double)fd.computeLogRelativeFrequency(3), (double)1.0E-5);
        fd.decrement(1);
        Assert.assertEquals((long)2L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)4L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)0L, (long)fd.get(1));
        Assert.assertEquals((long)2L, (long)fd.get(2));
        Assert.assertEquals((long)2L, (long)fd.get(3));
        Assert.assertEquals((double)0.5, (double)fd.computeRelativeFrequency(2), (double)1.0E-5);
        Assert.assertEquals((double)0.5, (double)fd.computeRelativeFrequency(3), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.5), (double)fd.computeLogRelativeFrequency(2), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.5), (double)fd.computeLogRelativeFrequency(3), (double)1.0E-5);
    }

    protected void test2Common(Int2IntFrequencyDistribution fd) {
        fd.increment(1);
        fd.increment(1);
        fd.increment(2);
        fd.increment(3);
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)4L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get(1));
        Assert.assertEquals((long)1L, (long)fd.get(2));
        Assert.assertEquals((long)1L, (long)fd.get(3));
        fd.set(4, 5);
        Assert.assertEquals((long)4L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)9L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get(1));
        Assert.assertEquals((long)1L, (long)fd.get(2));
        Assert.assertEquals((long)1L, (long)fd.get(3));
        Assert.assertEquals((long)5L, (long)fd.get(4));
        fd.set(1, 5);
        Assert.assertEquals((long)4L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)12L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)5L, (long)fd.get(1));
        Assert.assertEquals((long)1L, (long)fd.get(2));
        Assert.assertEquals((long)1L, (long)fd.get(3));
        Assert.assertEquals((long)5L, (long)fd.get(4));
        fd.increment(3);
        fd.increment(3);
        fd.increment(3);
        Assert.assertEquals((long)4L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)15L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)5L, (long)fd.get(1));
        Assert.assertEquals((long)1L, (long)fd.get(2));
        Assert.assertEquals((long)4L, (long)fd.get(3));
        Assert.assertEquals((long)5L, (long)fd.get(4));
        fd.set(3, 1);
        Assert.assertEquals((long)4L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)12L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)5L, (long)fd.get(1));
        Assert.assertEquals((long)1L, (long)fd.get(2));
        Assert.assertEquals((long)1L, (long)fd.get(3));
        Assert.assertEquals((long)5L, (long)fd.get(4));
    }

    protected void test3Common(Int2IntFrequencyDistribution fd) {
        fd.increment(1);
        fd.increment(1);
        fd.increment(2);
        fd.increment(3);
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)4L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get(1));
        Assert.assertEquals((long)1L, (long)fd.get(2));
        Assert.assertEquals((long)1L, (long)fd.get(3));
        fd.clear();
        Assert.assertEquals((long)0L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)0L, (long)fd.getSumOfCounts());
    }

    protected void testFailedDecrement1Common(Int2IntFrequencyDistribution fd) {
        fd.increment(1);
        Assert.assertEquals((long)1L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)1L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)1L, (long)fd.get(1));
        fd.decrement(1);
        Assert.assertEquals((long)0L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)0L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)0L, (long)fd.get(1));
        fd.decrement(1);
    }

    protected void testFailedDecrement2Common(Int2IntFrequencyDistribution fd) {
        fd.increment(1, 1000);
        Assert.assertEquals((long)1L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)1000L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)1000L, (long)fd.get(1));
        fd.decrement(1, 997);
        Assert.assertEquals((long)1L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)3L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)3L, (long)fd.get(1));
        fd.decrement(1, 3);
        Assert.assertEquals((long)0L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)0L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)0L, (long)fd.get(1));
        fd.increment(1, 3);
        fd.decrement(1, 4);
    }

    protected void testMultiIncrementDecrementCommon(Int2IntFrequencyDistribution fd) {
        fd.increment(1, 2);
        fd.increment(2, 3);
        fd.increment(3, 4);
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)9L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get(1));
        Assert.assertEquals((long)3L, (long)fd.get(2));
        Assert.assertEquals((long)4L, (long)fd.get(3));
        fd.decrement(2, 2);
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)7L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get(1));
        Assert.assertEquals((long)1L, (long)fd.get(2));
        Assert.assertEquals((long)4L, (long)fd.get(3));
    }

    protected void testGetFrequencySortedEventsCommon(Int2IntFrequencyDistribution fd) {
        fd.set(1, 5);
        fd.set(4, 2);
        fd.set(2, 5);
        fd.set(5, 2);
        fd.set(6, 1);
        fd.set(3, 5);
        Assert.assertEquals((long)6L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)20L, (long)fd.getSumOfCounts());
        List list = fd.getEntries(SortableEntries.Order.ByRightElementDescending);
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((PairOfInts)list.get(0)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfInts)list.get(0)).getRightElement());
        Assert.assertEquals((long)2L, (long)((PairOfInts)list.get(1)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfInts)list.get(1)).getRightElement());
        Assert.assertEquals((long)3L, (long)((PairOfInts)list.get(2)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfInts)list.get(2)).getRightElement());
        Assert.assertEquals((long)4L, (long)((PairOfInts)list.get(3)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfInts)list.get(3)).getRightElement());
        Assert.assertEquals((long)5L, (long)((PairOfInts)list.get(4)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfInts)list.get(4)).getRightElement());
        Assert.assertEquals((long)6L, (long)((PairOfInts)list.get(5)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfInts)list.get(5)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByRightElementAscending);
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals((long)6L, (long)((PairOfInts)list.get(0)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfInts)list.get(0)).getRightElement());
        Assert.assertEquals((long)4L, (long)((PairOfInts)list.get(1)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfInts)list.get(1)).getRightElement());
        Assert.assertEquals((long)5L, (long)((PairOfInts)list.get(2)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfInts)list.get(2)).getRightElement());
        Assert.assertEquals((long)1L, (long)((PairOfInts)list.get(3)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfInts)list.get(3)).getRightElement());
        Assert.assertEquals((long)2L, (long)((PairOfInts)list.get(4)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfInts)list.get(4)).getRightElement());
        Assert.assertEquals((long)3L, (long)((PairOfInts)list.get(5)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfInts)list.get(5)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByRightElementDescending, 4);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((PairOfInts)list.get(0)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfInts)list.get(0)).getRightElement());
        Assert.assertEquals((long)2L, (long)((PairOfInts)list.get(1)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfInts)list.get(1)).getRightElement());
        Assert.assertEquals((long)3L, (long)((PairOfInts)list.get(2)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfInts)list.get(2)).getRightElement());
        Assert.assertEquals((long)4L, (long)((PairOfInts)list.get(3)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfInts)list.get(3)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByRightElementAscending, 4);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((long)6L, (long)((PairOfInts)list.get(0)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfInts)list.get(0)).getRightElement());
        Assert.assertEquals((long)4L, (long)((PairOfInts)list.get(1)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfInts)list.get(1)).getRightElement());
        Assert.assertEquals((long)5L, (long)((PairOfInts)list.get(2)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfInts)list.get(2)).getRightElement());
        Assert.assertEquals((long)1L, (long)((PairOfInts)list.get(3)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfInts)list.get(3)).getRightElement());
    }

    protected void testGetSortedEventsCommon(Int2IntFrequencyDistribution fd) {
        fd.set(1, 1);
        fd.set(4, 3);
        fd.set(2, 4);
        fd.set(5, 7);
        fd.set(6, 9);
        fd.set(3, 2);
        Assert.assertEquals((long)6L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)26L, (long)fd.getSumOfCounts());
        List list = fd.getEntries(SortableEntries.Order.ByLeftElementAscending);
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((PairOfInts)list.get(0)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfInts)list.get(0)).getRightElement());
        Assert.assertEquals((long)2L, (long)((PairOfInts)list.get(1)).getLeftElement());
        Assert.assertEquals((long)4L, (long)((PairOfInts)list.get(1)).getRightElement());
        Assert.assertEquals((long)3L, (long)((PairOfInts)list.get(2)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfInts)list.get(2)).getRightElement());
        Assert.assertEquals((long)4L, (long)((PairOfInts)list.get(3)).getLeftElement());
        Assert.assertEquals((long)3L, (long)((PairOfInts)list.get(3)).getRightElement());
        Assert.assertEquals((long)5L, (long)((PairOfInts)list.get(4)).getLeftElement());
        Assert.assertEquals((long)7L, (long)((PairOfInts)list.get(4)).getRightElement());
        Assert.assertEquals((long)6L, (long)((PairOfInts)list.get(5)).getLeftElement());
        Assert.assertEquals((long)9L, (long)((PairOfInts)list.get(5)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByLeftElementDescending);
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals((long)6L, (long)((PairOfInts)list.get(0)).getLeftElement());
        Assert.assertEquals((long)9L, (long)((PairOfInts)list.get(0)).getRightElement());
        Assert.assertEquals((long)5L, (long)((PairOfInts)list.get(1)).getLeftElement());
        Assert.assertEquals((long)7L, (long)((PairOfInts)list.get(1)).getRightElement());
        Assert.assertEquals((long)4L, (long)((PairOfInts)list.get(2)).getLeftElement());
        Assert.assertEquals((long)3L, (long)((PairOfInts)list.get(2)).getRightElement());
        Assert.assertEquals((long)3L, (long)((PairOfInts)list.get(3)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfInts)list.get(3)).getRightElement());
        Assert.assertEquals((long)2L, (long)((PairOfInts)list.get(4)).getLeftElement());
        Assert.assertEquals((long)4L, (long)((PairOfInts)list.get(4)).getRightElement());
        Assert.assertEquals((long)1L, (long)((PairOfInts)list.get(5)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfInts)list.get(5)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByLeftElementAscending, 4);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((PairOfInts)list.get(0)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfInts)list.get(0)).getRightElement());
        Assert.assertEquals((long)2L, (long)((PairOfInts)list.get(1)).getLeftElement());
        Assert.assertEquals((long)4L, (long)((PairOfInts)list.get(1)).getRightElement());
        Assert.assertEquals((long)3L, (long)((PairOfInts)list.get(2)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfInts)list.get(2)).getRightElement());
        Assert.assertEquals((long)4L, (long)((PairOfInts)list.get(3)).getLeftElement());
        Assert.assertEquals((long)3L, (long)((PairOfInts)list.get(3)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByLeftElementDescending, 4);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((long)6L, (long)((PairOfInts)list.get(0)).getLeftElement());
        Assert.assertEquals((long)9L, (long)((PairOfInts)list.get(0)).getRightElement());
        Assert.assertEquals((long)5L, (long)((PairOfInts)list.get(1)).getLeftElement());
        Assert.assertEquals((long)7L, (long)((PairOfInts)list.get(1)).getRightElement());
        Assert.assertEquals((long)4L, (long)((PairOfInts)list.get(2)).getLeftElement());
        Assert.assertEquals((long)3L, (long)((PairOfInts)list.get(2)).getRightElement());
        Assert.assertEquals((long)3L, (long)((PairOfInts)list.get(3)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfInts)list.get(3)).getRightElement());
    }

    protected void testIterableCommon(Int2IntFrequencyDistribution fd) {
        fd.set(1, 1);
        fd.set(4, 3);
        fd.set(2, 4);
        fd.set(5, 7);
        fd.set(6, 9);
        fd.set(3, 2);
        Assert.assertEquals((long)6L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)26L, (long)fd.getSumOfCounts());
        TreeSet<PairOfInts> list = new TreeSet<PairOfInts>();
        for (PairOfInts pair : fd) {
            list.add(pair.clone());
        }
        Assert.assertEquals((long)6L, (long)list.size());
        Iterator iter = list.iterator();
        PairOfInts e = (PairOfInts)iter.next();
        Assert.assertEquals((long)1L, (long)e.getLeftElement());
        Assert.assertEquals((long)1L, (long)e.getRightElement());
        e = (PairOfInts)iter.next();
        Assert.assertEquals((long)2L, (long)e.getLeftElement());
        Assert.assertEquals((long)4L, (long)e.getRightElement());
        e = (PairOfInts)iter.next();
        Assert.assertEquals((long)3L, (long)e.getLeftElement());
        Assert.assertEquals((long)2L, (long)e.getRightElement());
        e = (PairOfInts)iter.next();
        Assert.assertEquals((long)4L, (long)e.getLeftElement());
        Assert.assertEquals((long)3L, (long)e.getRightElement());
        e = (PairOfInts)iter.next();
        Assert.assertEquals((long)5L, (long)e.getLeftElement());
        Assert.assertEquals((long)7L, (long)e.getRightElement());
        e = (PairOfInts)iter.next();
        Assert.assertEquals((long)6L, (long)e.getLeftElement());
        Assert.assertEquals((long)9L, (long)e.getRightElement());
    }

    protected void testSerialization(Int2IntFrequencyDistribution fd, Class<? extends Int2IntFrequencyDistribution> cls) throws Exception {
        fd.set(1, 1);
        fd.set(4, 3);
        fd.set(2, 4);
        fd.set(5, 7);
        fd.set(6, 9);
        fd.set(3, 2);
        Assert.assertEquals((long)6L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)26L, (long)fd.getSumOfCounts());
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        fd.write((DataOutput)dataOut);
        Int2IntFrequencyDistribution reconstructed = cls.newInstance();
        reconstructed.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertFalse((fd == reconstructed ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)reconstructed.get(1));
        Assert.assertEquals((long)3L, (long)reconstructed.get(4));
        Assert.assertEquals((long)4L, (long)reconstructed.get(2));
        Assert.assertEquals((long)7L, (long)reconstructed.get(5));
        Assert.assertEquals((long)9L, (long)reconstructed.get(6));
        Assert.assertEquals((long)2L, (long)reconstructed.get(3));
        Assert.assertEquals((long)6L, (long)reconstructed.getNumberOfEvents());
        Assert.assertEquals((long)26L, (long)reconstructed.getSumOfCounts());
    }
}

