/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.fd;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.junit.Assert;
import tl.lin.data.fd.Object2LongFrequencyDistribution;
import tl.lin.data.fd.SortableEntries;
import tl.lin.data.pair.PairOfObjectLong;

public class Object2LongFrequencyDistributionTestBase {
    protected void test1Common(Object2LongFrequencyDistribution<String> fd) {
        Assert.assertEquals((long)0L, (long)fd.get((Comparable)((Object)"a")));
        fd.increment((Comparable)((Object)"a"));
        fd.increment((Comparable)((Object)"b"));
        fd.increment((Comparable)((Object)"c"));
        fd.increment((Comparable)((Object)"b"));
        fd.increment((Comparable)((Object)"c"));
        fd.increment((Comparable)((Object)"c"));
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)6L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"a")));
        Assert.assertEquals((long)2L, (long)fd.get((Comparable)((Object)"b")));
        Assert.assertEquals((long)3L, (long)fd.get((Comparable)((Object)"c")));
        Assert.assertEquals((double)0.16666666666666666, (double)fd.computeRelativeFrequency((Comparable)((Object)"a")), (double)1.0E-5);
        Assert.assertEquals((double)0.3333333333333333, (double)fd.computeRelativeFrequency((Comparable)((Object)"b")), (double)1.0E-5);
        Assert.assertEquals((double)0.5, (double)fd.computeRelativeFrequency((Comparable)((Object)"c")), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.16666666666666666), (double)fd.computeLogRelativeFrequency((Comparable)((Object)"a")), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.3333333333333333), (double)fd.computeLogRelativeFrequency((Comparable)((Object)"b")), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.5), (double)fd.computeLogRelativeFrequency((Comparable)((Object)"c")), (double)1.0E-5);
        fd.decrement((Comparable)((Object)"c"));
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)5L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"a")));
        Assert.assertEquals((long)2L, (long)fd.get((Comparable)((Object)"b")));
        Assert.assertEquals((long)2L, (long)fd.get((Comparable)((Object)"c")));
        Assert.assertEquals((double)0.2, (double)fd.computeRelativeFrequency((Comparable)((Object)"a")), (double)1.0E-5);
        Assert.assertEquals((double)0.4, (double)fd.computeRelativeFrequency((Comparable)((Object)"b")), (double)1.0E-5);
        Assert.assertEquals((double)0.4, (double)fd.computeRelativeFrequency((Comparable)((Object)"c")), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.2), (double)fd.computeLogRelativeFrequency((Comparable)((Object)"a")), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.4), (double)fd.computeLogRelativeFrequency((Comparable)((Object)"b")), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.4), (double)fd.computeLogRelativeFrequency((Comparable)((Object)"c")), (double)1.0E-5);
        fd.decrement((Comparable)((Object)"a"));
        Assert.assertEquals((long)2L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)4L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)0L, (long)fd.get((Comparable)((Object)"a")));
        Assert.assertEquals((long)2L, (long)fd.get((Comparable)((Object)"b")));
        Assert.assertEquals((long)2L, (long)fd.get((Comparable)((Object)"c")));
        Assert.assertEquals((double)0.5, (double)fd.computeRelativeFrequency((Comparable)((Object)"b")), (double)1.0E-5);
        Assert.assertEquals((double)0.5, (double)fd.computeRelativeFrequency((Comparable)((Object)"c")), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.5), (double)fd.computeLogRelativeFrequency((Comparable)((Object)"b")), (double)1.0E-5);
        Assert.assertEquals((double)Math.log(0.5), (double)fd.computeLogRelativeFrequency((Comparable)((Object)"c")), (double)1.0E-5);
        Set set = fd.keySet();
        Assert.assertEquals((long)2L, (long)set.size());
        Assert.assertFalse((boolean)set.contains("a"));
        Assert.assertTrue((boolean)set.contains("b"));
        Assert.assertTrue((boolean)set.contains("c"));
    }

    protected void test2Common(Object2LongFrequencyDistribution<String> fd) {
        fd.increment((Comparable)((Object)"a"));
        fd.increment((Comparable)((Object)"a"));
        fd.increment((Comparable)((Object)"b"));
        fd.increment((Comparable)((Object)"c"));
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)4L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get((Comparable)((Object)"a")));
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"b")));
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"c")));
        fd.set((Comparable)((Object)"d"), 5L);
        Assert.assertEquals((long)4L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)9L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get((Comparable)((Object)"a")));
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"b")));
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"c")));
        Assert.assertEquals((long)5L, (long)fd.get((Comparable)((Object)"d")));
        fd.set((Comparable)((Object)"a"), 5L);
        Assert.assertEquals((long)4L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)12L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)5L, (long)fd.get((Comparable)((Object)"a")));
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"b")));
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"c")));
        Assert.assertEquals((long)5L, (long)fd.get((Comparable)((Object)"d")));
        fd.increment((Comparable)((Object)"c"));
        fd.increment((Comparable)((Object)"c"));
        fd.increment((Comparable)((Object)"c"));
        Assert.assertEquals((long)4L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)15L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)5L, (long)fd.get((Comparable)((Object)"a")));
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"b")));
        Assert.assertEquals((long)4L, (long)fd.get((Comparable)((Object)"c")));
        Assert.assertEquals((long)5L, (long)fd.get((Comparable)((Object)"d")));
        fd.set((Comparable)((Object)"c"), 1L);
        Assert.assertEquals((long)4L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)12L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)5L, (long)fd.get((Comparable)((Object)"a")));
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"b")));
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"c")));
        Assert.assertEquals((long)5L, (long)fd.get((Comparable)((Object)"d")));
    }

    protected void test3Common(Object2LongFrequencyDistribution<String> fd) {
        fd.increment((Comparable)((Object)"a"));
        fd.increment((Comparable)((Object)"a"));
        fd.increment((Comparable)((Object)"b"));
        fd.increment((Comparable)((Object)"c"));
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)4L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get((Comparable)((Object)"a")));
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"b")));
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"c")));
        fd.clear();
        Assert.assertEquals((long)0L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)0L, (long)fd.getSumOfCounts());
    }

    protected void testFailedDecrement1Common(Object2LongFrequencyDistribution<String> fd) {
        fd.increment((Comparable)((Object)"a"));
        Assert.assertEquals((long)1L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)1L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"a")));
        fd.decrement((Comparable)((Object)"a"));
        Assert.assertEquals((long)0L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)0L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)0L, (long)fd.get((Comparable)((Object)"a")));
        fd.decrement((Comparable)((Object)"a"));
    }

    protected void testFailedDecrement2Common(Object2LongFrequencyDistribution<String> fd) {
        fd.increment((Comparable)((Object)"a"), 1000L);
        Assert.assertEquals((long)1L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)1000L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)1000L, (long)fd.get((Comparable)((Object)"a")));
        fd.decrement((Comparable)((Object)"a"), 997L);
        Assert.assertEquals((long)1L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)3L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)3L, (long)fd.get((Comparable)((Object)"a")));
        fd.decrement((Comparable)((Object)"a"), 3L);
        Assert.assertEquals((long)0L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)0L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)0L, (long)fd.get((Comparable)((Object)"a")));
        fd.increment((Comparable)((Object)"a"), 3L);
        fd.decrement((Comparable)((Object)"a"), 4L);
    }

    protected void testMultiIncrementDecrementCommon(Object2LongFrequencyDistribution<String> fd) {
        fd.increment((Comparable)((Object)"a"), 2L);
        fd.increment((Comparable)((Object)"b"), 3L);
        fd.increment((Comparable)((Object)"c"), 4L);
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)9L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get((Comparable)((Object)"a")));
        Assert.assertEquals((long)3L, (long)fd.get((Comparable)((Object)"b")));
        Assert.assertEquals((long)4L, (long)fd.get((Comparable)((Object)"c")));
        fd.decrement((Comparable)((Object)"b"), 2L);
        Assert.assertEquals((long)3L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)7L, (long)fd.getSumOfCounts());
        Assert.assertEquals((long)2L, (long)fd.get((Comparable)((Object)"a")));
        Assert.assertEquals((long)1L, (long)fd.get((Comparable)((Object)"b")));
        Assert.assertEquals((long)4L, (long)fd.get((Comparable)((Object)"c")));
    }

    protected void testGetFrequencySortedCommon(Object2LongFrequencyDistribution<String> fd) {
        fd.set((Comparable)((Object)"a"), 5L);
        fd.set((Comparable)((Object)"d"), 2L);
        fd.set((Comparable)((Object)"b"), 5L);
        fd.set((Comparable)((Object)"e"), 2L);
        fd.set((Comparable)((Object)"f"), 1L);
        fd.set((Comparable)((Object)"c"), 5L);
        Assert.assertEquals((long)6L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)20L, (long)fd.getSumOfCounts());
        List list = fd.getEntries(SortableEntries.Order.ByRightElementDescending);
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals((Object)"a", (Object)((PairOfObjectLong)list.get(0)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectLong)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"b", (Object)((PairOfObjectLong)list.get(1)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectLong)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"c", (Object)((PairOfObjectLong)list.get(2)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectLong)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"d", (Object)((PairOfObjectLong)list.get(3)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectLong)list.get(3)).getRightElement());
        Assert.assertEquals((Object)"e", (Object)((PairOfObjectLong)list.get(4)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectLong)list.get(4)).getRightElement());
        Assert.assertEquals((Object)"f", (Object)((PairOfObjectLong)list.get(5)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfObjectLong)list.get(5)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByRightElementAscending);
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals((Object)"f", (Object)((PairOfObjectLong)list.get(0)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfObjectLong)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"d", (Object)((PairOfObjectLong)list.get(1)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectLong)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"e", (Object)((PairOfObjectLong)list.get(2)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectLong)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"a", (Object)((PairOfObjectLong)list.get(3)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectLong)list.get(3)).getRightElement());
        Assert.assertEquals((Object)"b", (Object)((PairOfObjectLong)list.get(4)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectLong)list.get(4)).getRightElement());
        Assert.assertEquals((Object)"c", (Object)((PairOfObjectLong)list.get(5)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectLong)list.get(5)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByRightElementDescending, 4);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"a", (Object)((PairOfObjectLong)list.get(0)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectLong)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"b", (Object)((PairOfObjectLong)list.get(1)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectLong)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"c", (Object)((PairOfObjectLong)list.get(2)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectLong)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"d", (Object)((PairOfObjectLong)list.get(3)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectLong)list.get(3)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByRightElementAscending, 4);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"f", (Object)((PairOfObjectLong)list.get(0)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfObjectLong)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"d", (Object)((PairOfObjectLong)list.get(1)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectLong)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"e", (Object)((PairOfObjectLong)list.get(2)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectLong)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"a", (Object)((PairOfObjectLong)list.get(3)).getLeftElement());
        Assert.assertEquals((long)5L, (long)((PairOfObjectLong)list.get(3)).getRightElement());
    }

    protected void testGetSortedEventsCommon(Object2LongFrequencyDistribution<String> fd) {
        fd.set((Comparable)((Object)"a"), 1L);
        fd.set((Comparable)((Object)"d"), 3L);
        fd.set((Comparable)((Object)"b"), 4L);
        fd.set((Comparable)((Object)"e"), 7L);
        fd.set((Comparable)((Object)"f"), 9L);
        fd.set((Comparable)((Object)"c"), 2L);
        Assert.assertEquals((long)6L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)26L, (long)fd.getSumOfCounts());
        List list = fd.getEntries(SortableEntries.Order.ByLeftElementAscending);
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals((Object)"a", (Object)((PairOfObjectLong)list.get(0)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfObjectLong)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"b", (Object)((PairOfObjectLong)list.get(1)).getLeftElement());
        Assert.assertEquals((long)4L, (long)((PairOfObjectLong)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"c", (Object)((PairOfObjectLong)list.get(2)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectLong)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"d", (Object)((PairOfObjectLong)list.get(3)).getLeftElement());
        Assert.assertEquals((long)3L, (long)((PairOfObjectLong)list.get(3)).getRightElement());
        Assert.assertEquals((Object)"e", (Object)((PairOfObjectLong)list.get(4)).getLeftElement());
        Assert.assertEquals((long)7L, (long)((PairOfObjectLong)list.get(4)).getRightElement());
        Assert.assertEquals((Object)"f", (Object)((PairOfObjectLong)list.get(5)).getLeftElement());
        Assert.assertEquals((long)9L, (long)((PairOfObjectLong)list.get(5)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByLeftElementDescending);
        Assert.assertEquals((long)6L, (long)list.size());
        Assert.assertEquals((Object)"f", (Object)((PairOfObjectLong)list.get(0)).getLeftElement());
        Assert.assertEquals((long)9L, (long)((PairOfObjectLong)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"e", (Object)((PairOfObjectLong)list.get(1)).getLeftElement());
        Assert.assertEquals((long)7L, (long)((PairOfObjectLong)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"d", (Object)((PairOfObjectLong)list.get(2)).getLeftElement());
        Assert.assertEquals((long)3L, (long)((PairOfObjectLong)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"c", (Object)((PairOfObjectLong)list.get(3)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectLong)list.get(3)).getRightElement());
        Assert.assertEquals((Object)"b", (Object)((PairOfObjectLong)list.get(4)).getLeftElement());
        Assert.assertEquals((long)4L, (long)((PairOfObjectLong)list.get(4)).getRightElement());
        Assert.assertEquals((Object)"a", (Object)((PairOfObjectLong)list.get(5)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfObjectLong)list.get(5)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByLeftElementAscending, 4);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"a", (Object)((PairOfObjectLong)list.get(0)).getLeftElement());
        Assert.assertEquals((long)1L, (long)((PairOfObjectLong)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"b", (Object)((PairOfObjectLong)list.get(1)).getLeftElement());
        Assert.assertEquals((long)4L, (long)((PairOfObjectLong)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"c", (Object)((PairOfObjectLong)list.get(2)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectLong)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"d", (Object)((PairOfObjectLong)list.get(3)).getLeftElement());
        Assert.assertEquals((long)3L, (long)((PairOfObjectLong)list.get(3)).getRightElement());
        list = fd.getEntries(SortableEntries.Order.ByLeftElementDescending, 4);
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"f", (Object)((PairOfObjectLong)list.get(0)).getLeftElement());
        Assert.assertEquals((long)9L, (long)((PairOfObjectLong)list.get(0)).getRightElement());
        Assert.assertEquals((Object)"e", (Object)((PairOfObjectLong)list.get(1)).getLeftElement());
        Assert.assertEquals((long)7L, (long)((PairOfObjectLong)list.get(1)).getRightElement());
        Assert.assertEquals((Object)"d", (Object)((PairOfObjectLong)list.get(2)).getLeftElement());
        Assert.assertEquals((long)3L, (long)((PairOfObjectLong)list.get(2)).getRightElement());
        Assert.assertEquals((Object)"c", (Object)((PairOfObjectLong)list.get(3)).getLeftElement());
        Assert.assertEquals((long)2L, (long)((PairOfObjectLong)list.get(3)).getRightElement());
    }

    protected void testIterableCommon(Object2LongFrequencyDistribution<String> fd) {
        fd.set((Comparable)((Object)"a"), 1L);
        fd.set((Comparable)((Object)"d"), 3L);
        fd.set((Comparable)((Object)"b"), 4L);
        fd.set((Comparable)((Object)"e"), 7L);
        fd.set((Comparable)((Object)"f"), 9L);
        fd.set((Comparable)((Object)"c"), 2L);
        Assert.assertEquals((long)6L, (long)fd.getNumberOfEvents());
        Assert.assertEquals((long)26L, (long)fd.getSumOfCounts());
        TreeSet<PairOfObjectLong> list = new TreeSet<PairOfObjectLong>();
        for (PairOfObjectLong pair : fd) {
            list.add(pair.clone());
        }
        Assert.assertEquals((long)6L, (long)list.size());
        Iterator iter = list.iterator();
        PairOfObjectLong e = (PairOfObjectLong)iter.next();
        Assert.assertEquals((Object)"a", (Object)e.getLeftElement());
        Assert.assertEquals((long)1L, (long)e.getRightElement());
        e = (PairOfObjectLong)iter.next();
        Assert.assertEquals((Object)"b", (Object)e.getLeftElement());
        Assert.assertEquals((long)4L, (long)e.getRightElement());
        e = (PairOfObjectLong)iter.next();
        Assert.assertEquals((Object)"c", (Object)e.getLeftElement());
        Assert.assertEquals((long)2L, (long)e.getRightElement());
        e = (PairOfObjectLong)iter.next();
        Assert.assertEquals((Object)"d", (Object)e.getLeftElement());
        Assert.assertEquals((long)3L, (long)e.getRightElement());
        e = (PairOfObjectLong)iter.next();
        Assert.assertEquals((Object)"e", (Object)e.getLeftElement());
        Assert.assertEquals((long)7L, (long)e.getRightElement());
        e = (PairOfObjectLong)iter.next();
        Assert.assertEquals((Object)"f", (Object)e.getLeftElement());
        Assert.assertEquals((long)9L, (long)e.getRightElement());
    }
}

