/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import tl.lin.data.map.HMapIFW;

public class HMapIFWTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        HMapIFW m = new HMapIFW();
        m.put(2, 5.0f);
        m.put(1, 22.0f);
        Assert.assertEquals((long)m.size(), (long)2L);
        float value = m.get(2);
        Assert.assertTrue((value == 5.0f ? 1 : 0) != 0);
        value = m.remove(2);
        Assert.assertEquals((long)m.size(), (long)1L);
        value = m.get(1);
        Assert.assertTrue((value == 22.0f ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testSerialize1() throws IOException {
        HMapIFW m1 = new HMapIFW();
        m1.put(3, 5.0f);
        m1.put(4, 22.0f);
        byte[] bytes = m1.serialize();
        HMapIFW n2 = HMapIFW.create((byte[])bytes);
        Assert.assertEquals((long)n2.size(), (long)2L);
        float value = n2.get(3);
        Assert.assertTrue((value == 5.0f ? 1 : 0) != 0);
        value = n2.remove(3);
        Assert.assertEquals((long)n2.size(), (long)1L);
        value = n2.get(4);
        Assert.assertTrue((value == 22.0f ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testSerializeLazy1() throws IOException {
        HMapIFW.setLazyDecodeFlag((boolean)true);
        HMapIFW m1 = new HMapIFW();
        m1.put(3, 5.0f);
        m1.put(4, 22.0f);
        byte[] bytes = m1.serialize();
        HMapIFW m2 = HMapIFW.create((byte[])bytes);
        Assert.assertFalse((boolean)m2.isDecoded());
        Assert.assertEquals((long)2L, (long)m2.size());
        int[] keys = m2.getKeys();
        float[] values = m2.getValues();
        Assert.assertTrue((keys[0] == 3 ? 1 : 0) != 0);
        Assert.assertTrue((keys[1] == 4 ? 1 : 0) != 0);
        Assert.assertTrue((values[0] == 5.0f ? 1 : 0) != 0);
        Assert.assertTrue((values[1] == 22.0f ? 1 : 0) != 0);
        m2.decode();
        Assert.assertTrue((boolean)m2.isDecoded());
        Assert.assertEquals((long)m2.size(), (long)2L);
        float value = m2.get(3);
        Assert.assertTrue((value == 5.0f ? 1 : 0) != 0);
        value = m2.remove(3);
        Assert.assertEquals((long)1L, (long)m2.size());
        value = m2.get(4);
        Assert.assertTrue((value == 22.0f ? 1 : 0) != 0);
        HMapIFW.setLazyDecodeFlag((boolean)false);
    }

    @org.junit.Test
    public void testSerializeLazy2() throws IOException {
        HMapIFW.setLazyDecodeFlag((boolean)true);
        HMapIFW m1 = new HMapIFW();
        m1.put(3, 5.0f);
        m1.put(4, 22.0f);
        byte[] bytes = m1.serialize();
        HMapIFW m2 = HMapIFW.create((byte[])bytes);
        Assert.assertFalse((boolean)m2.isDecoded());
        Assert.assertEquals((long)2L, (long)m2.size());
        int[] keys = m2.getKeys();
        float[] values = m2.getValues();
        Assert.assertTrue((keys[0] == 3 ? 1 : 0) != 0);
        Assert.assertTrue((keys[1] == 4 ? 1 : 0) != 0);
        Assert.assertTrue((values[0] == 5.0f ? 1 : 0) != 0);
        Assert.assertTrue((values[1] == 22.0f ? 1 : 0) != 0);
        m2.decode();
        Assert.assertEquals((long)m2.size(), (long)2L);
        float value = m2.get(3);
        Assert.assertTrue((value == 5.0f ? 1 : 0) != 0);
        value = m2.remove(3);
        Assert.assertEquals((long)m2.size(), (long)1L);
        value = m2.get(4);
        Assert.assertTrue((value == 22.0f ? 1 : 0) != 0);
        HMapIFW.setLazyDecodeFlag((boolean)false);
    }

    @org.junit.Test
    public void testLazyPlus1() throws IOException {
        HMapIFW.setLazyDecodeFlag((boolean)true);
        HMapIFW m1 = new HMapIFW();
        m1.put(3, 5.0f);
        m1.put(4, 22.0f);
        byte[] bytes1 = m1.serialize();
        HMapIFW m2 = new HMapIFW();
        m2.put(3, 1.0f);
        m2.put(4, 1.0f);
        m2.put(5, 1.0f);
        byte[] bytes2 = m2.serialize();
        HMapIFW n1 = HMapIFW.create((byte[])bytes1);
        HMapIFW n2 = HMapIFW.create((byte[])bytes2);
        Assert.assertFalse((boolean)n1.isDecoded());
        Assert.assertEquals((long)2L, (long)n1.size());
        Assert.assertFalse((boolean)n2.isDecoded());
        Assert.assertEquals((long)3L, (long)n2.size());
        n1.plus(n2);
        Assert.assertTrue((n1.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((n1.get(3) == 6.0f ? 1 : 0) != 0);
        Assert.assertTrue((n1.get(4) == 23.0f ? 1 : 0) != 0);
        Assert.assertTrue((n1.get(5) == 1.0f ? 1 : 0) != 0);
        Assert.assertTrue((boolean)n1.isDecoded());
        Assert.assertFalse((boolean)n2.isDecoded());
        HMapIFW.setLazyDecodeFlag((boolean)false);
    }

    @org.junit.Test
    public void testLazyPlus2() throws IOException {
        HMapIFW.setLazyDecodeFlag((boolean)true);
        HMapIFW m1 = new HMapIFW();
        m1.put(3, 5.0f);
        m1.put(4, 22.0f);
        byte[] bytes1 = m1.serialize();
        HMapIFW m2 = new HMapIFW();
        m2.put(3, 1.0f);
        m2.put(4, 1.0f);
        m2.put(5, 1.0f);
        byte[] bytes2 = m2.serialize();
        HMapIFW n1 = HMapIFW.create((byte[])bytes1);
        HMapIFW n2 = HMapIFW.create((byte[])bytes2);
        Assert.assertFalse((boolean)n1.isDecoded());
        Assert.assertEquals((long)2L, (long)n1.size());
        Assert.assertFalse((boolean)n2.isDecoded());
        Assert.assertEquals((long)3L, (long)n2.size());
        n2.decode();
        n1.plus(n2);
        Assert.assertTrue((n1.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((n1.get(3) == 6.0f ? 1 : 0) != 0);
        Assert.assertTrue((n1.get(4) == 23.0f ? 1 : 0) != 0);
        Assert.assertTrue((n1.get(5) == 1.0f ? 1 : 0) != 0);
        Assert.assertTrue((boolean)n1.isDecoded());
        Assert.assertTrue((boolean)n2.isDecoded());
        HMapIFW.setLazyDecodeFlag((boolean)false);
    }

    @org.junit.Test
    public void testLazyPlus3() throws IOException {
        HMapIFW.setLazyDecodeFlag((boolean)true);
        HMapIFW m1 = new HMapIFW();
        m1.put(3, 5.0f);
        m1.put(4, 22.0f);
        byte[] bytes1 = m1.serialize();
        HMapIFW m2 = new HMapIFW();
        m2.put(3, 1.0f);
        m2.put(4, 1.0f);
        m2.put(5, 1.0f);
        byte[] bytes2 = m2.serialize();
        HMapIFW n1 = HMapIFW.create((byte[])bytes1);
        HMapIFW n2 = HMapIFW.create((byte[])bytes2);
        Assert.assertFalse((boolean)n1.isDecoded());
        Assert.assertEquals((long)2L, (long)n1.size());
        Assert.assertFalse((boolean)n2.isDecoded());
        Assert.assertEquals((long)3L, (long)n2.size());
        n1.decode();
        n1.plus(n2);
        Assert.assertTrue((n1.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((n1.get(3) == 6.0f ? 1 : 0) != 0);
        Assert.assertTrue((n1.get(4) == 23.0f ? 1 : 0) != 0);
        Assert.assertTrue((n1.get(5) == 1.0f ? 1 : 0) != 0);
        Assert.assertTrue((boolean)n1.isDecoded());
        Assert.assertFalse((boolean)n2.isDecoded());
        HMapIFW.setLazyDecodeFlag((boolean)false);
    }

    @org.junit.Test
    public void testLazyPlus4() throws IOException {
        HMapIFW.setLazyDecodeFlag((boolean)true);
        HMapIFW m1 = new HMapIFW();
        m1.put(3, 5.0f);
        m1.put(4, 22.0f);
        byte[] bytes1 = m1.serialize();
        HMapIFW m2 = new HMapIFW();
        m2.put(3, 1.0f);
        m2.put(4, 1.0f);
        m2.put(5, 1.0f);
        byte[] bytes2 = m2.serialize();
        HMapIFW n1 = HMapIFW.create((byte[])bytes1);
        HMapIFW n2 = HMapIFW.create((byte[])bytes2);
        Assert.assertFalse((boolean)n1.isDecoded());
        Assert.assertEquals((long)2L, (long)n1.size());
        Assert.assertFalse((boolean)n2.isDecoded());
        Assert.assertEquals((long)3L, (long)n2.size());
        n1.decode();
        n2.decode();
        n1.plus(n2);
        Assert.assertTrue((n1.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((n1.get(3) == 6.0f ? 1 : 0) != 0);
        Assert.assertTrue((n1.get(4) == 23.0f ? 1 : 0) != 0);
        Assert.assertTrue((n1.get(5) == 1.0f ? 1 : 0) != 0);
        Assert.assertTrue((boolean)n1.isDecoded());
        Assert.assertTrue((boolean)n2.isDecoded());
        HMapIFW.setLazyDecodeFlag((boolean)false);
    }

    @org.junit.Test
    public void testSerializeEmpty() throws IOException {
        HMapIFW m1 = new HMapIFW();
        m1.decode();
        Assert.assertTrue((m1.size() == 0 ? 1 : 0) != 0);
        byte[] bytes = m1.serialize();
        HMapIFW m2 = HMapIFW.create((byte[])bytes);
        Assert.assertTrue((m2.size() == 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(HMapIFWTest.class);
    }
}

