/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import java.io.IOException;
import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import tl.lin.data.map.HMapII;
import tl.lin.data.map.MapII;

public class HMapIITest {
    @org.junit.Test
    public void testRandomInsert() {
        int i;
        int size = 100000;
        Random r = new Random();
        int[] ints = new int[size];
        HMapII map = new HMapII();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            map.put(i, k);
            ints[i] = k;
        }
        for (i = 0; i < size; ++i) {
            int v = map.get(i);
            Assert.assertEquals((long)ints[i], (long)v);
            Assert.assertTrue((boolean)map.containsKey(i));
        }
    }

    @org.junit.Test
    public void testRandomUpdate() {
        int i;
        int size = 100000;
        Random r = new Random();
        int[] ints = new int[size];
        HMapII map = new HMapII();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            map.put(i, k);
            ints[i] = k;
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            map.put(i, ints[i] + 1);
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            int v = map.get(i);
            Assert.assertEquals((long)(ints[i] + 1), (long)v);
            Assert.assertTrue((boolean)map.containsKey(i));
        }
    }

    @org.junit.Test
    public void testBasic() throws IOException {
        HMapII m = new HMapII();
        m.put(1, 5);
        m.put(2, 22);
        Assert.assertEquals((long)m.size(), (long)2L);
        float value = m.get(1);
        Assert.assertTrue((value == 5.0f ? 1 : 0) != 0);
        value = m.remove(1);
        Assert.assertEquals((long)m.size(), (long)1L);
        value = m.get(2);
        Assert.assertTrue((value == 22.0f ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testPlus() throws IOException {
        HMapII m1 = new HMapII();
        m1.put(1, 5);
        m1.put(2, 22);
        HMapII m2 = new HMapII();
        m2.put(1, 4);
        m2.put(3, 5);
        m1.plus((MapII)m2);
        Assert.assertEquals((long)m1.size(), (long)3L);
        Assert.assertTrue((m1.get(1) == 9 ? 1 : 0) != 0);
        Assert.assertTrue((m1.get(2) == 22 ? 1 : 0) != 0);
        Assert.assertTrue((m1.get(3) == 5 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testDot() throws IOException {
        HMapII m1 = new HMapII();
        m1.put(1, 2);
        m1.put(2, 1);
        m1.put(3, 3);
        HMapII m2 = new HMapII();
        m2.put(1, 1);
        m2.put(2, 4);
        m2.put(4, 5);
        Assert.assertEquals((long)6L, (long)m1.dot((MapII)m2));
    }

    @org.junit.Test
    public void testIncrement() {
        HMapII m = new HMapII();
        Assert.assertEquals((long)0L, (long)m.get(1));
        m.increment(1);
        Assert.assertEquals((long)1L, (long)m.get(1));
        m.increment(1, 5);
        m.increment(2, 0);
        m.increment(3, 2);
        Assert.assertEquals((long)6L, (long)m.get(1));
        Assert.assertEquals((long)0L, (long)m.get(2));
        Assert.assertEquals((long)2L, (long)m.get(3));
    }

    @org.junit.Test
    public void testSortedEntries1() {
        HMapII m = new HMapII();
        m.put(1, 5);
        m.put(2, 2);
        m.put(3, 3);
        m.put(4, 3);
        m.put(5, 1);
        MapII.Entry[] e = m.getEntriesSortedByValue();
        Assert.assertEquals((long)5L, (long)e.length);
        Assert.assertEquals((long)1L, (long)e[0].getKey());
        Assert.assertEquals((long)5L, (long)e[0].getValue());
        Assert.assertEquals((long)3L, (long)e[1].getKey());
        Assert.assertEquals((long)3L, (long)e[1].getValue());
        Assert.assertEquals((long)4L, (long)e[2].getKey());
        Assert.assertEquals((long)3L, (long)e[2].getValue());
        Assert.assertEquals((long)2L, (long)e[3].getKey());
        Assert.assertEquals((long)2L, (long)e[3].getValue());
        Assert.assertEquals((long)5L, (long)e[4].getKey());
        Assert.assertEquals((long)1L, (long)e[4].getValue());
    }

    @org.junit.Test
    public void testSortedEntries2() {
        HMapII m = new HMapII();
        m.put(1, 5);
        m.put(2, 2);
        m.put(3, 3);
        m.put(4, 3);
        m.put(5, 1);
        MapII.Entry[] e = m.getEntriesSortedByValue(2);
        Assert.assertEquals((long)2L, (long)e.length);
        Assert.assertEquals((long)1L, (long)e[0].getKey());
        Assert.assertEquals((long)5L, (long)e[0].getValue());
        Assert.assertEquals((long)3L, (long)e[1].getKey());
        Assert.assertEquals((long)3L, (long)e[1].getValue());
    }

    @org.junit.Test
    public void testSortedEntries3() {
        HMapII m = new HMapII();
        m.put(1, 5);
        m.put(2, 2);
        MapII.Entry[] e = m.getEntriesSortedByValue(5);
        Assert.assertEquals((long)2L, (long)e.length);
        Assert.assertEquals((long)1L, (long)e[0].getKey());
        Assert.assertEquals((long)5L, (long)e[0].getValue());
        Assert.assertEquals((long)2L, (long)e[1].getKey());
        Assert.assertEquals((long)2L, (long)e[1].getValue());
    }

    @org.junit.Test
    public void testSortedEntries4() {
        HMapII m = new HMapII();
        MapII.Entry[] e = m.getEntriesSortedByValue();
        Assert.assertTrue((e == null ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testPut() {
        HMapII m = new HMapII();
        Assert.assertEquals((long)0L, (long)m.put(1, 5));
        Assert.assertEquals((long)5L, (long)m.put(1, 6));
        Assert.assertEquals((long)6L, (long)m.put(1, 2));
        Assert.assertEquals((long)2L, (long)m.get(1));
    }

    public static Test suite() {
        return new JUnit4TestAdapter(HMapIITest.class);
    }
}

