/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import tl.lin.data.map.HMapIFW;
import tl.lin.data.map.HMapIIW;

public class HMapIIWTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        HMapIIW m = new HMapIIW();
        m.put(2, 5);
        m.put(1, 22);
        Assert.assertEquals((long)m.size(), (long)2L);
        int value = m.get(2);
        Assert.assertEquals((long)5L, (long)value);
        value = m.remove(2);
        Assert.assertEquals((long)m.size(), (long)1L);
        value = m.get(1);
        Assert.assertEquals((long)22L, (long)value);
    }

    @org.junit.Test
    public void testSerialize1() throws IOException {
        HMapIIW m1 = new HMapIIW();
        m1.put(3, 5);
        m1.put(4, 22);
        HMapIIW n2 = HMapIIW.create((byte[])m1.serialize());
        Assert.assertEquals((long)n2.size(), (long)2L);
        int value = n2.get(3);
        Assert.assertEquals((long)5L, (long)value);
        value = n2.remove(3);
        Assert.assertEquals((long)n2.size(), (long)1L);
        value = n2.get(4);
        Assert.assertEquals((long)value, (long)22L);
    }

    @org.junit.Test
    public void testSerializeLazy1() throws IOException {
        HMapIIW.setLazyDecodeFlag((boolean)true);
        HMapIIW m1 = new HMapIIW();
        m1.put(3, 5);
        m1.put(4, 22);
        HMapIIW m2 = HMapIIW.create((byte[])m1.serialize());
        Assert.assertEquals((long)2L, (long)m2.size());
        int[] keys = m2.getKeys();
        int[] values = m2.getValues();
        Assert.assertTrue((keys[0] == 3 ? 1 : 0) != 0);
        Assert.assertTrue((keys[1] == 4 ? 1 : 0) != 0);
        Assert.assertTrue((values[0] == 5 ? 1 : 0) != 0);
        Assert.assertTrue((values[1] == 22 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)m2.isDecoded());
        Assert.assertEquals((long)m2.size(), (long)2L);
        m2.decode();
        Assert.assertTrue((boolean)m2.isDecoded());
        Assert.assertEquals((long)m2.size(), (long)2L);
        int value = m2.get(3);
        Assert.assertTrue((value == 5 ? 1 : 0) != 0);
        value = m2.remove(3);
        Assert.assertEquals((long)m2.size(), (long)1L);
        value = m2.get(4);
        Assert.assertTrue((value == 22 ? 1 : 0) != 0);
        HMapIIW.setLazyDecodeFlag((boolean)false);
    }

    @org.junit.Test
    public void testSerializeEmpty() throws IOException {
        HMapIIW m1 = new HMapIIW();
        m1.decode();
        Assert.assertTrue((m1.size() == 0 ? 1 : 0) != 0);
        HMapIFW m2 = HMapIFW.create((byte[])m1.serialize());
        Assert.assertTrue((m2.size() == 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(HMapIIWTest.class);
    }
}

