/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import java.io.IOException;
import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import tl.lin.data.map.HMapIL;
import tl.lin.data.map.MapIL;

public class HMapILTest {
    @org.junit.Test
    public void testRandomInsert() {
        int i;
        int size = 100000;
        Random r = new Random();
        long[] longs = new long[size];
        HMapIL map = new HMapIL();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            map.put(i, (long)(k * Integer.MAX_VALUE));
            longs[i] = k * Integer.MAX_VALUE;
        }
        for (i = 0; i < size; ++i) {
            long v = map.get(i);
            Assert.assertEquals((long)longs[i], (long)v);
            Assert.assertTrue((boolean)map.containsKey(i));
        }
    }

    @org.junit.Test
    public void testRandomUpdate() {
        int i;
        int size = 100000;
        Random r = new Random();
        long[] longs = new long[size];
        HMapIL map = new HMapIL();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            map.put(i, (long)k + Integer.MAX_VALUE);
            longs[i] = (long)k + Integer.MAX_VALUE;
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            map.put(i, longs[i] + Integer.MAX_VALUE);
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            long v = map.get(i);
            Assert.assertEquals((long)(longs[i] + Integer.MAX_VALUE), (long)v);
            Assert.assertTrue((boolean)map.containsKey(i));
        }
    }

    @org.junit.Test
    public void testBasic() throws IOException {
        HMapIL m = new HMapIL();
        m.put(1, 0x80000004L);
        m.put(2, 2147483669L);
        Assert.assertEquals((long)2L, (long)m.size());
        long value = m.get(1);
        Assert.assertEquals((long)0x80000004L, (long)value);
        value = m.remove(1);
        Assert.assertEquals((long)m.size(), (long)1L);
        value = m.get(2);
        Assert.assertEquals((long)2147483669L, (long)value);
    }

    @org.junit.Test
    public void testPlus() throws IOException {
        HMapIL m1 = new HMapIL();
        m1.put(1, 0x80000004L);
        m1.put(2, 2147483669L);
        m1.put(Integer.MAX_VALUE, Integer.MAX_VALUE);
        HMapIL m2 = new HMapIL();
        m2.put(1, 4L);
        m2.put(3, 0x80000004L);
        m2.put(Integer.MAX_VALUE, Integer.MAX_VALUE);
        m1.plus((MapIL)m2);
        Assert.assertEquals((long)m1.size(), (long)4L);
        Assert.assertTrue((m1.get(1) == 0x80000008L ? 1 : 0) != 0);
        Assert.assertTrue((m1.get(2) == 2147483669L ? 1 : 0) != 0);
        Assert.assertTrue((m1.get(3) == 0x80000004L ? 1 : 0) != 0);
        Assert.assertTrue((m1.get(Integer.MAX_VALUE) == 0xFFFFFFFEL ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testDot() throws IOException {
        HMapIL m1 = new HMapIL();
        m1.put(1, 2L);
        m1.put(2, 1L);
        m1.put(3, 3L);
        m1.put(Integer.MAX_VALUE, Integer.MAX_VALUE);
        HMapIL m2 = new HMapIL();
        m2.put(1, 1L);
        m2.put(2, 4L);
        m2.put(4, 5L);
        m2.put(Integer.MAX_VALUE, Integer.MAX_VALUE);
        long s = m1.dot((MapIL)m2);
        Assert.assertTrue((s > Integer.MAX_VALUE ? 1 : 0) != 0);
        Assert.assertEquals((long)4611686014132420615L, (long)s);
    }

    @org.junit.Test
    public void testIncrement() {
        HMapIL m = new HMapIL();
        Assert.assertEquals((long)0L, (long)m.get(1));
        m.increment(1, 1L);
        Assert.assertEquals((long)1L, (long)m.get(1));
        m.increment(1, 1L);
        m.increment(2, 0L);
        m.increment(3, -1L);
        Assert.assertEquals((long)2L, (long)m.get(1));
        Assert.assertEquals((long)0L, (long)m.get(2));
        Assert.assertEquals((long)-1L, (long)m.get(3));
        m.increment(Integer.MAX_VALUE, Integer.MAX_VALUE);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)m.get(Integer.MAX_VALUE));
        m.increment(Integer.MAX_VALUE);
        Assert.assertEquals((long)0x80000000L, (long)m.get(Integer.MAX_VALUE));
    }

    @org.junit.Test
    public void testSortedEntries1() {
        HMapIL m = new HMapIL();
        m.put(1, 5L);
        m.put(2, 2L);
        m.put(3, 3L);
        m.put(4, 3L);
        m.put(5, 1L);
        MapIL.Entry[] e = m.getEntriesSortedByValue();
        Assert.assertEquals((long)5L, (long)e.length);
        Assert.assertEquals((long)1L, (long)e[0].getKey());
        Assert.assertEquals((long)5L, (long)e[0].getValue());
        Assert.assertEquals((long)3L, (long)e[1].getKey());
        Assert.assertEquals((long)3L, (long)e[1].getValue());
        Assert.assertEquals((long)4L, (long)e[2].getKey());
        Assert.assertEquals((long)3L, (long)e[2].getValue());
        Assert.assertEquals((long)2L, (long)e[3].getKey());
        Assert.assertEquals((long)2L, (long)e[3].getValue());
        Assert.assertEquals((long)5L, (long)e[4].getKey());
        Assert.assertEquals((long)1L, (long)e[4].getValue());
    }

    @org.junit.Test
    public void testSortedEntries2() {
        HMapIL m = new HMapIL();
        m.put(1, 5L);
        m.put(2, 2L);
        m.put(3, 3L);
        m.put(4, 3L);
        m.put(5, 1L);
        MapIL.Entry[] e = m.getEntriesSortedByValue(2);
        Assert.assertEquals((long)2L, (long)e.length);
        Assert.assertEquals((long)1L, (long)e[0].getKey());
        Assert.assertEquals((long)5L, (long)e[0].getValue());
        Assert.assertEquals((long)3L, (long)e[1].getKey());
        Assert.assertEquals((long)3L, (long)e[1].getValue());
    }

    @org.junit.Test
    public void testSortedEntries3() {
        HMapIL m = new HMapIL();
        m.put(1, 5L);
        m.put(2, 2L);
        MapIL.Entry[] e = m.getEntriesSortedByValue(5);
        Assert.assertEquals((long)2L, (long)e.length);
        Assert.assertEquals((long)1L, (long)e[0].getKey());
        Assert.assertEquals((long)5L, (long)e[0].getValue());
        Assert.assertEquals((long)2L, (long)e[1].getKey());
        Assert.assertEquals((long)2L, (long)e[1].getValue());
    }

    @org.junit.Test
    public void testSortedEntries4() {
        HMapIL m = new HMapIL();
        MapIL.Entry[] e = m.getEntriesSortedByValue();
        Assert.assertTrue((e == null ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(HMapILTest.class);
    }
}

