/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import tl.lin.data.map.HMapIFW;
import tl.lin.data.map.HMapILW;

public class HMapILWTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        HMapILW m = new HMapILW();
        m.put(2, 0x80000004L);
        m.put(1, 2147483669L);
        Assert.assertEquals((long)m.size(), (long)2L);
        long value = m.get(2);
        Assert.assertEquals((long)0x80000004L, (long)value);
        Assert.assertTrue((value > 0L ? 1 : 0) != 0);
        value = m.remove(2);
        Assert.assertEquals((long)m.size(), (long)1L);
        value = m.get(1);
        Assert.assertEquals((long)2147483669L, (long)value);
        Assert.assertTrue((value > 0L ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testSerialize1() throws IOException {
        HMapILW m1 = new HMapILW();
        m1.put(3, 0x80000004L);
        m1.put(4, 2147483669L);
        HMapILW n2 = HMapILW.create((byte[])m1.serialize());
        Assert.assertEquals((long)n2.size(), (long)2L);
        long value = n2.get(3);
        Assert.assertEquals((long)0x80000004L, (long)value);
        Assert.assertTrue((value > 0L ? 1 : 0) != 0);
        value = n2.remove(3);
        Assert.assertEquals((long)n2.size(), (long)1L);
        value = n2.get(4);
        Assert.assertEquals((long)2147483669L, (long)value);
        Assert.assertTrue((value > 0L ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testSerializeLazy1() throws IOException {
        HMapILW.setLazyDecodeFlag((boolean)true);
        HMapILW m1 = new HMapILW();
        m1.put(3, 0x80000004L);
        m1.put(4, 2147483669L);
        HMapILW m2 = HMapILW.create((byte[])m1.serialize());
        Assert.assertEquals((long)2L, (long)m2.size());
        int[] keys = m2.getKeys();
        long[] values = m2.getValues();
        Assert.assertTrue((keys[0] == 3 ? 1 : 0) != 0);
        Assert.assertTrue((keys[1] == 4 ? 1 : 0) != 0);
        Assert.assertTrue((values[0] == 0x80000004L ? 1 : 0) != 0);
        Assert.assertTrue((values[0] > 0L ? 1 : 0) != 0);
        Assert.assertTrue((values[1] == 2147483669L ? 1 : 0) != 0);
        Assert.assertTrue((values[1] > 0L ? 1 : 0) != 0);
        Assert.assertFalse((boolean)m2.isDecoded());
        Assert.assertEquals((long)m2.size(), (long)2L);
        m2.decode();
        Assert.assertTrue((boolean)m2.isDecoded());
        Assert.assertEquals((long)m2.size(), (long)2L);
        long value = m2.get(3);
        Assert.assertTrue((value == 0x80000004L ? 1 : 0) != 0);
        Assert.assertTrue((value > 0L ? 1 : 0) != 0);
        value = m2.remove(3);
        Assert.assertEquals((long)m2.size(), (long)1L);
        value = m2.get(4);
        Assert.assertTrue((value == 2147483669L ? 1 : 0) != 0);
        Assert.assertTrue((value > 0L ? 1 : 0) != 0);
        HMapILW.setLazyDecodeFlag((boolean)false);
    }

    @org.junit.Test
    public void testSerializeEmpty() throws IOException {
        HMapILW m1 = new HMapILW();
        m1.decode();
        Assert.assertTrue((m1.size() == 0 ? 1 : 0) != 0);
        HMapIFW m2 = HMapIFW.create((byte[])m1.serialize());
        Assert.assertTrue((m2.size() == 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(HMapILWTest.class);
    }
}

