/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import java.io.IOException;
import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import tl.lin.data.map.HMapKF;
import tl.lin.data.map.MapKF;

public class HMapKFTest {
    @org.junit.Test
    public void testRandomInsert1() {
        int i;
        int size = 100000;
        Random r = new Random();
        float[] floats = new float[size];
        HMapKF map = new HMapKF();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            map.put((Object)i, (float)k + 0.1f);
            floats[i] = (float)k + 0.1f;
        }
        for (i = 0; i < size; ++i) {
            float v = map.get((Object)i);
            Assert.assertEquals((float)floats[i], (float)v, (float)0.0f);
            Assert.assertTrue((boolean)map.containsKey((Object)i));
        }
    }

    @org.junit.Test
    public void testRandomInsert2() {
        int i;
        int size = 100000;
        Random r = new Random();
        float[] floats = new float[size];
        String[] strings = new String[size];
        HMapKF map = new HMapKF();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            String s = new Integer(k).toString();
            map.put((Object)s, (float)k + 0.1f);
            floats[i] = (float)k + 0.1f;
            strings[i] = s;
        }
        for (i = 0; i < size; ++i) {
            float v = map.get((Object)strings[i]);
            Assert.assertEquals((float)floats[i], (float)v, (float)0.0f);
            Assert.assertTrue((boolean)map.containsKey((Object)strings[i]));
        }
    }

    @org.junit.Test
    public void testRandomUpdate() {
        int i;
        int size = 100000;
        Random r = new Random();
        float[] floats = new float[size];
        HMapKF map = new HMapKF();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            map.put((Object)i, (float)k + 0.1f);
            floats[i] = (float)k + 0.1f;
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            map.put((Object)i, floats[i] + 1.0f);
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            float v = map.get((Object)i);
            Assert.assertEquals((float)(floats[i] + 1.0f), (float)v, (float)0.0f);
            Assert.assertTrue((boolean)map.containsKey((Object)i));
        }
    }

    @org.junit.Test
    public void testBasic() throws IOException {
        HMapKF m = new HMapKF();
        m.put((Comparable)new Text("hi"), 5.0f);
        m.put((Comparable)new Text("there"), 22.0f);
        Assert.assertEquals((long)m.size(), (long)2L);
        Text key = new Text("hi");
        float value = m.get((Comparable)key);
        Assert.assertTrue((value == 5.0f ? 1 : 0) != 0);
        value = m.remove((Comparable)key);
        Assert.assertEquals((long)m.size(), (long)1L);
        key = new Text("there");
        value = m.get((Comparable)key);
        Assert.assertTrue((value == 22.0f ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testPlus() throws IOException {
        HMapKF m1 = new HMapKF();
        m1.put((Comparable)new Text("hi"), 5.0f);
        m1.put((Comparable)new Text("there"), 22.0f);
        HMapKF m2 = new HMapKF();
        m2.put((Comparable)new Text("hi"), 4.0f);
        m2.put((Comparable)new Text("test"), 5.0f);
        m1.plus((MapKF)m2);
        Assert.assertEquals((long)m1.size(), (long)3L);
        Assert.assertTrue((m1.get((Comparable)new Text("hi")) == 9.0f ? 1 : 0) != 0);
        Assert.assertTrue((m1.get((Comparable)new Text("there")) == 22.0f ? 1 : 0) != 0);
        Assert.assertTrue((m1.get((Comparable)new Text("test")) == 5.0f ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testDot() throws IOException {
        HMapKF m1 = new HMapKF();
        m1.put((Comparable)new Text("hi"), 2.3f);
        m1.put((Comparable)new Text("there"), 1.9f);
        m1.put((Comparable)new Text("empty"), 3.0f);
        HMapKF m2 = new HMapKF();
        m2.put((Comparable)new Text("hi"), 1.2f);
        m2.put((Comparable)new Text("there"), 4.3f);
        m2.put((Comparable)new Text("test"), 5.0f);
        Assert.assertEquals((double)10.93, (double)m1.dot((MapKF)m2), (double)1.0E-5);
    }

    @org.junit.Test
    public void testIncrement() {
        HMapKF m = new HMapKF();
        Assert.assertEquals((double)0.0, (double)m.get((Comparable)((Object)"one")), (double)1.0E-5);
        m.increment((Comparable)((Object)"one"), 0.5f);
        Assert.assertEquals((double)0.5, (double)m.get((Comparable)((Object)"one")), (double)1.0E-5);
        m.increment((Comparable)((Object)"one"), 1.0f);
        m.increment((Comparable)((Object)"two"), 0.0f);
        m.increment((Comparable)((Object)"three"), -0.5f);
        Assert.assertEquals((double)1.5, (double)m.get((Comparable)((Object)"one")), (double)1.0E-5);
        Assert.assertEquals((double)0.0, (double)m.get((Comparable)((Object)"two")), (double)1.0E-5);
        Assert.assertEquals((double)-0.5, (double)m.get((Comparable)((Object)"three")), (double)1.0E-5);
    }

    @org.junit.Test
    public void testLengthAndNormalize() throws IOException {
        HMapKF m1 = new HMapKF();
        m1.put((Comparable)new Text("hi"), 2.3f);
        m1.put((Comparable)new Text("there"), 1.9f);
        m1.put((Comparable)new Text("empty"), 3.0f);
        Assert.assertEquals((double)m1.length(), (double)4.2308393, (double)1.0E-5);
        m1.normalize();
        Assert.assertEquals((double)m1.get((Comparable)new Text("hi")), (double)0.5436274, (double)1.0E-5);
        Assert.assertEquals((double)m1.get((Comparable)new Text("there")), (double)0.44908348, (double)1.0E-5);
        Assert.assertEquals((double)m1.get((Comparable)new Text("empty")), (double)0.70907915, (double)1.0E-5);
        Assert.assertEquals((double)m1.length(), (double)1.0, (double)1.0E-5);
        HMapKF m2 = new HMapKF();
        m2.put((Comparable)new Text("hi"), 1.2f);
        m2.put((Comparable)new Text("there"), 4.3f);
        m2.put((Comparable)new Text("test"), 5.0f);
        Assert.assertEquals((double)m2.length(), (double)6.7029843, (double)1.0E-5);
        m2.normalize();
        Assert.assertEquals((double)m2.get((Comparable)new Text("hi")), (double)0.17902474, (double)1.0E-5);
        Assert.assertEquals((double)m2.get((Comparable)new Text("there")), (double)0.64150536, (double)1.0E-5);
        Assert.assertEquals((double)m2.get((Comparable)new Text("test")), (double)0.7459364, (double)1.0E-5);
        Assert.assertEquals((double)m2.length(), (double)1.0, (double)1.0E-5);
    }

    @org.junit.Test
    public void testSortedEntries1() {
        HMapKF m = new HMapKF();
        m.put((Comparable)new Text("a"), 5.0f);
        m.put((Comparable)new Text("b"), 2.0f);
        m.put((Comparable)new Text("c"), 3.0f);
        m.put((Comparable)new Text("d"), 3.0f);
        m.put((Comparable)new Text("e"), 1.0f);
        MapKF.Entry[] entries = m.getEntriesSortedByValue();
        MapKF.Entry e = null;
        Assert.assertEquals((long)5L, (long)entries.length);
        e = entries[0];
        Assert.assertEquals((Object)new Text("a"), (Object)e.getKey());
        Assert.assertEquals((double)5.0, (double)e.getValue(), (double)1.0E-5);
        e = entries[1];
        Assert.assertEquals((Object)new Text("c"), (Object)e.getKey());
        Assert.assertEquals((double)3.0, (double)e.getValue(), (double)1.0E-5);
        e = entries[2];
        Assert.assertEquals((Object)new Text("d"), (Object)e.getKey());
        Assert.assertEquals((double)3.0, (double)e.getValue(), (double)1.0E-5);
        e = entries[3];
        Assert.assertEquals((Object)new Text("b"), (Object)e.getKey());
        Assert.assertEquals((double)2.0, (double)e.getValue(), (double)1.0E-5);
        e = entries[4];
        Assert.assertEquals((Object)new Text("e"), (Object)e.getKey());
        Assert.assertEquals((double)1.0, (double)e.getValue(), (double)1.0E-5);
    }

    @org.junit.Test
    public void testSortedEntries2() {
        HMapKF m = new HMapKF();
        m.put((Comparable)new Text("a"), 5.0f);
        m.put((Comparable)new Text("b"), 2.0f);
        m.put((Comparable)new Text("c"), 3.0f);
        m.put((Comparable)new Text("d"), 3.0f);
        m.put((Comparable)new Text("e"), 1.0f);
        MapKF.Entry[] entries = m.getEntriesSortedByValue(2);
        MapKF.Entry e = null;
        Assert.assertEquals((long)2L, (long)entries.length);
        e = entries[0];
        Assert.assertEquals((Object)new Text("a"), (Object)e.getKey());
        Assert.assertEquals((double)5.0, (double)e.getValue(), (double)1.0E-5);
        e = entries[1];
        Assert.assertEquals((Object)new Text("c"), (Object)e.getKey());
        Assert.assertEquals((double)3.0, (double)e.getValue(), (double)1.0E-5);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(HMapKFTest.class);
    }
}

