/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import tl.lin.data.map.HMapKIW;

public class HMapKIWTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        HMapKIW m = new HMapKIW();
        m.put((Comparable)new Text("hi"), 5);
        m.put((Comparable)new Text("there"), 22);
        Assert.assertEquals((long)m.size(), (long)2L);
        Text key = new Text("hi");
        int value = m.get((Comparable)key);
        Assert.assertEquals((long)value, (long)5L);
        value = m.remove((Comparable)key);
        Assert.assertEquals((long)m.size(), (long)1L);
        key = new Text("there");
        value = m.get((Comparable)key);
        Assert.assertEquals((long)value, (long)22L);
    }

    @org.junit.Test
    public void testSerialize1() throws IOException {
        HMapKIW m1 = new HMapKIW();
        m1.put((Comparable)new Text("hi"), 5);
        m1.put((Comparable)new Text("there"), 22);
        HMapKIW m2 = HMapKIW.create((byte[])m1.serialize());
        Assert.assertEquals((long)m2.size(), (long)2L);
        Text key = new Text("hi");
        int value = m2.get((Comparable)key);
        Assert.assertEquals((long)value, (long)5L);
        value = m2.remove((Comparable)key);
        Assert.assertEquals((long)m2.size(), (long)1L);
        key = new Text("there");
        value = m2.get((Comparable)key);
        Assert.assertEquals((long)value, (long)22L);
    }

    @org.junit.Test(expected=IOException.class)
    public void testTypeSafety() throws IOException {
        HMapKIW m1 = new HMapKIW();
        m1.put((Comparable)new Text("hi"), 4);
        m1.put((Comparable)new IntWritable(0), 76);
        HMapKIW m2 = HMapKIW.create((byte[])m1.serialize());
        m2.size();
    }

    @org.junit.Test
    public void testSerializeEmpty() throws IOException {
        HMapKIW m1 = new HMapKIW();
        Assert.assertTrue((m1.size() == 0 ? 1 : 0) != 0);
        HMapKIW m2 = HMapKIW.create((byte[])m1.serialize());
        Assert.assertTrue((m2.size() == 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(HMapKIWTest.class);
    }
}

