/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import java.io.IOException;
import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import tl.lin.data.map.HMapKL;
import tl.lin.data.map.MapKL;

public class HMapKLTest {
    @org.junit.Test
    public void testRandomInsert1() {
        int i;
        int size = 100000;
        Random r = new Random();
        long[] longs = new long[size];
        HMapKL map = new HMapKL();
        for (i = 0; i < size; ++i) {
            long k = r.nextLong();
            map.put((Object)i, k);
            longs[i] = k;
        }
        for (i = 0; i < size; ++i) {
            long v = map.get((Object)i);
            Assert.assertEquals((long)longs[i], (long)v);
            Assert.assertTrue((boolean)map.containsKey((Object)i));
        }
    }

    @org.junit.Test
    public void testRandomInsert2() {
        int i;
        int size = 100000;
        Random r = new Random();
        long[] longs = new long[size];
        String[] strings = new String[size];
        HMapKL map = new HMapKL();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            String s = new Integer(k).toString();
            map.put((Object)s, (long)k);
            longs[i] = k;
            strings[i] = s;
        }
        for (i = 0; i < size; ++i) {
            long v = map.get((Object)strings[i]);
            Assert.assertEquals((long)longs[i], (long)v);
            Assert.assertTrue((boolean)map.containsKey((Object)strings[i]));
        }
    }

    @org.junit.Test
    public void testRandomUpdate() {
        int i;
        int size = 100000;
        Random r = new Random();
        long[] longs = new long[size];
        HMapKL map = new HMapKL();
        for (i = 0; i < size; ++i) {
            int k = r.nextInt(size);
            map.put((Object)i, (long)k);
            longs[i] = k;
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            map.put((Object)i, longs[i] + Integer.MAX_VALUE);
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            long v = map.get((Object)i);
            Assert.assertEquals((long)(longs[i] + Integer.MAX_VALUE), (long)v);
            Assert.assertTrue((boolean)map.containsKey((Object)i));
        }
    }

    @org.junit.Test
    public void testBasic() throws IOException {
        HMapKL m = new HMapKL();
        m.put((Object)"1", 0x80000004L);
        m.put((Object)"2", 2147483669L);
        Assert.assertEquals((long)2L, (long)m.size());
        long value = m.get((Object)"1");
        Assert.assertEquals((long)0x80000004L, (long)value);
        value = m.remove((Object)"1");
        Assert.assertEquals((long)m.size(), (long)1L);
        value = m.get((Object)"2");
        Assert.assertEquals((long)2147483669L, (long)value);
    }

    @org.junit.Test
    public void testPlus() throws IOException {
        HMapKL m1 = new HMapKL();
        m1.put((Object)"1", 0x80000004L);
        m1.put((Object)"2", 2147483669L);
        m1.put((Object)"2147483647", Integer.MAX_VALUE);
        HMapKL m2 = new HMapKL();
        m2.put((Object)"1", 4L);
        m2.put((Object)"3", 0x80000004L);
        m2.put((Object)"2147483647", Integer.MAX_VALUE);
        m1.plus((MapKL)m2);
        Assert.assertEquals((long)m1.size(), (long)4L);
        Assert.assertTrue((m1.get((Object)"1") == 0x80000008L ? 1 : 0) != 0);
        Assert.assertTrue((m1.get((Object)"2") == 2147483669L ? 1 : 0) != 0);
        Assert.assertTrue((m1.get((Object)"3") == 0x80000004L ? 1 : 0) != 0);
        Assert.assertTrue((m1.get((Object)"2147483647") == 0xFFFFFFFEL ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testDot() throws IOException {
        HMapKL m1 = new HMapKL();
        m1.put((Object)"1", 2L);
        m1.put((Object)"2", 1L);
        m1.put((Object)"3", 3L);
        m1.put((Object)"2147483647", Integer.MAX_VALUE);
        HMapKL m2 = new HMapKL();
        m2.put((Object)"1", 1L);
        m2.put((Object)"2", 4L);
        m2.put((Object)"4", 5L);
        m2.put((Object)"2147483647", Integer.MAX_VALUE);
        long s = m1.dot((MapKL)m2);
        Assert.assertTrue((s > Integer.MAX_VALUE ? 1 : 0) != 0);
        Assert.assertEquals((long)4611686014132420615L, (long)s);
    }

    @org.junit.Test
    public void testIncrement() {
        HMapKL m = new HMapKL();
        Assert.assertEquals((long)0L, (long)m.get((Object)"1"));
        m.increment((Object)"1", 1L);
        Assert.assertEquals((long)1L, (long)m.get((Object)"1"));
        m.increment((Object)"1", 1L);
        m.increment((Object)"2", 0L);
        m.increment((Object)"3", -1L);
        Assert.assertEquals((long)2L, (long)m.get((Object)"1"));
        Assert.assertEquals((long)0L, (long)m.get((Object)"2"));
        Assert.assertEquals((long)-1L, (long)m.get((Object)"3"));
        m.increment((Object)"2147483647", Integer.MAX_VALUE);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)m.get((Object)"2147483647"));
        m.increment((Object)"2147483647");
        Assert.assertEquals((long)0x80000000L, (long)m.get((Object)"2147483647"));
    }

    public static Test suite() {
        return new JUnit4TestAdapter(HMapKLTest.class);
    }
}

