/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import java.io.IOException;
import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import tl.lin.data.map.HMapKS;
import tl.lin.data.map.MapKS;

public class HMapKSTest {
    @org.junit.Test
    public void testRandomInsert1() {
        int i;
        int size = 100000;
        Random r = new Random();
        short[] shorts = new short[size];
        HMapKS map = new HMapKS();
        for (i = 0; i < size; ++i) {
            short k = (short)r.nextInt(Short.MAX_VALUE);
            map.put((Object)i, k);
            shorts[i] = k;
        }
        for (i = 0; i < size; ++i) {
            short v = map.get((Object)i);
            Assert.assertEquals((long)shorts[i], (long)v);
            Assert.assertTrue((boolean)map.containsKey((Object)i));
        }
    }

    @org.junit.Test
    public void testRandomInsert2() {
        int i;
        int size = 100000;
        Random r = new Random();
        short[] shorts = new short[size];
        String[] strings = new String[size];
        HMapKS map = new HMapKS();
        for (i = 0; i < size; ++i) {
            short k = (short)r.nextInt(Short.MAX_VALUE);
            String s = new Integer(k).toString();
            map.put((Object)s, k);
            shorts[i] = k;
            strings[i] = s;
        }
        for (i = 0; i < size; ++i) {
            short v = map.get((Object)strings[i]);
            Assert.assertEquals((long)shorts[i], (long)v);
            Assert.assertTrue((boolean)map.containsKey((Object)strings[i]));
        }
    }

    @org.junit.Test
    public void testRandomUpdate() {
        int i;
        int size = 100000;
        Random r = new Random();
        short[] shorts = new short[size];
        HMapKS map = new HMapKS();
        for (i = 0; i < size; ++i) {
            short k = (short)r.nextInt(Short.MAX_VALUE);
            map.put((Object)i, k);
            shorts[i] = k;
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            map.put((Object)i, (short)(shorts[i] + 1));
        }
        Assert.assertEquals((long)size, (long)map.size());
        for (i = 0; i < size; ++i) {
            short v = map.get((Object)i);
            Assert.assertEquals((long)(shorts[i] + 1), (long)v);
            Assert.assertTrue((boolean)map.containsKey((Object)i));
        }
    }

    @org.junit.Test
    public void testBasic() throws IOException {
        HMapKS m = new HMapKS();
        m.put((Object)new Text("hi"), (short)5);
        m.put((Object)new Text("there"), (short)22);
        Assert.assertEquals((long)m.size(), (long)2L);
        Text key = new Text("hi");
        short value = m.get((Object)key);
        Assert.assertEquals((long)value, (long)5L);
        value = m.remove((Object)key);
        Assert.assertEquals((long)m.size(), (long)1L);
        key = new Text("there");
        value = m.get((Object)key);
        Assert.assertEquals((long)value, (long)22L);
    }

    @org.junit.Test
    public void testPlus() throws IOException {
        HMapKS m1 = new HMapKS();
        m1.put((Object)new Text("hi"), (short)5);
        m1.put((Object)new Text("there"), (short)22);
        HMapKS m2 = new HMapKS();
        m2.put((Object)new Text("hi"), (short)4);
        m2.put((Object)new Text("test"), (short)5);
        m1.plus((MapKS)m2);
        Assert.assertEquals((long)3L, (long)m1.size());
        Assert.assertTrue((m1.get((Object)new Text("hi")) == 9 ? 1 : 0) != 0);
        Assert.assertTrue((m1.get((Object)new Text("there")) == 22 ? 1 : 0) != 0);
        Assert.assertTrue((m1.get((Object)new Text("test")) == 5 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testDot() throws IOException {
        HMapKS m1 = new HMapKS();
        m1.put((Object)new Text("hi"), (short)5);
        m1.put((Object)new Text("there"), (short)2);
        m1.put((Object)new Text("empty"), (short)3);
        HMapKS m2 = new HMapKS();
        m2.put((Object)new Text("hi"), (short)4);
        m2.put((Object)new Text("there"), (short)4);
        m2.put((Object)new Text("test"), (short)5);
        Assert.assertEquals((long)28L, (long)m1.dot((MapKS)m2));
    }

    @org.junit.Test
    public void testIncrement() {
        HMapKS m = new HMapKS();
        Assert.assertEquals((long)0L, (long)m.get((Object)"one"));
        m.increment((Object)"one", (short)1);
        Assert.assertEquals((long)1L, (long)m.get((Object)"one"));
        m.increment((Object)"one", (short)1);
        m.increment((Object)"two", (short)0);
        m.increment((Object)"three", (short)-1);
        Assert.assertEquals((long)2L, (long)m.get((Object)"one"));
        Assert.assertEquals((long)0L, (long)m.get((Object)"two"));
        Assert.assertEquals((long)-1L, (long)m.get((Object)"three"));
    }

    public static Test suite() {
        return new JUnit4TestAdapter(HMapKSTest.class);
    }
}

