/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import tl.lin.data.map.HMapStFW;

public class HMapStFWTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        HMapStFW m = new HMapStFW();
        m.put((Comparable)((Object)"hi"), 5.0f);
        m.put((Comparable)((Object)"there"), 22.0f);
        Assert.assertEquals((long)2L, (long)m.size());
        Assert.assertEquals((double)5.0, (double)m.get((Comparable)((Object)"hi")), (double)1.0E-5);
        m.remove((Comparable)((Object)"hi"));
        Assert.assertEquals((long)1L, (long)m.size());
        Assert.assertEquals((double)22.0, (double)m.get((Comparable)((Object)"there")), (double)1.0E-5);
    }

    @org.junit.Test
    public void testAccent() throws IOException {
        HMapStFW map1 = new HMapStFW();
        map1.put((Comparable)((Object)"\u00e0"), 1.0f);
        map1.put((Comparable)((Object)"\u00e6"), 2.0f);
        map1.put((Comparable)((Object)"\u00e7"), 3.0f);
        map1.put((Comparable)((Object)"\u00fc"), 4.0f);
        Assert.assertEquals((double)1.0, (double)map1.get((Comparable)((Object)"\u00e0")), (double)1.0E-5);
        Assert.assertEquals((double)2.0, (double)map1.get((Comparable)((Object)"\u00e6")), (double)1.0E-5);
        Assert.assertEquals((double)3.0, (double)map1.get((Comparable)((Object)"\u00e7")), (double)1.0E-5);
        Assert.assertEquals((double)4.0, (double)map1.get((Comparable)((Object)"\u00fc")), (double)1.0E-5);
        map1.put((Comparable)((Object)"\u00e0"), 10.0f);
        map1.remove((Comparable)((Object)"\u00e6"));
        map1.remove((Comparable)((Object)"\u00e7"));
        map1.put((Comparable)((Object)"\u00e7"), 2.0f);
        Assert.assertEquals((double)10.0, (double)map1.get((Comparable)((Object)"\u00e0")), (double)1.0E-5);
        Assert.assertEquals((double)2.0, (double)map1.get((Comparable)((Object)"\u00e7")), (double)1.0E-5);
        Assert.assertEquals((double)4.0, (double)map1.get((Comparable)((Object)"\u00fc")), (double)1.0E-5);
        Assert.assertEquals((long)3L, (long)map1.size());
        HMapStFW map2 = HMapStFW.create((byte[])map1.serialize());
        Assert.assertEquals((double)10.0, (double)map2.get((Comparable)((Object)"\u00e0")), (double)1.0E-5);
        Assert.assertEquals((double)2.0, (double)map2.get((Comparable)((Object)"\u00e7")), (double)1.0E-5);
        Assert.assertEquals((double)4.0, (double)map2.get((Comparable)((Object)"\u00fc")), (double)1.0E-5);
    }

    @org.junit.Test
    public void testJp() throws IOException {
        int i;
        String line;
        HMapStFW map1 = new HMapStFW();
        BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("jp-sample.txt"), "UTF8"));
        ArrayList list = Lists.newArrayList();
        int cnt = 0;
        while ((line = in.readLine()) != null) {
            list.add(line);
            map1.put((Comparable)((Object)line), (float)cnt++);
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Assert.assertEquals((double)i2, (double)map1.get((Comparable)list.get(i2)), (double)1.0E-5);
        }
        Assert.assertEquals((long)5L, (long)map1.size());
        HMapStFW map2 = HMapStFW.create((byte[])map1.serialize());
        for (i = 0; i < list.size(); ++i) {
            Assert.assertEquals((double)i, (double)map2.get((Comparable)list.get(i)), (double)1.0E-5);
        }
        Assert.assertEquals((long)5L, (long)map2.size());
        for (i = 0; i < list.size(); ++i) {
            map2.remove((Comparable)list.get(i));
        }
        Assert.assertEquals((long)5L, (long)map1.size());
        Assert.assertEquals((long)0L, (long)map2.size());
        in.close();
    }

    @org.junit.Test
    public void testSerialize1() throws IOException {
        HMapStFW m1 = new HMapStFW();
        m1.put((Comparable)((Object)"hi"), 5.0f);
        m1.put((Comparable)((Object)"there"), 22.0f);
        HMapStFW n2 = HMapStFW.create((byte[])m1.serialize());
        Assert.assertEquals((long)n2.size(), (long)2L);
        String key = "hi";
        float value = n2.get((Comparable)((Object)key));
        Assert.assertTrue((value == 5.0f ? 1 : 0) != 0);
        value = n2.remove((Comparable)((Object)key));
        Assert.assertEquals((long)n2.size(), (long)1L);
        key = "there";
        value = n2.get((Comparable)((Object)key));
        Assert.assertTrue((value == 22.0f ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testSerializeEmpty() throws IOException {
        HMapStFW m1 = new HMapStFW();
        Assert.assertTrue((m1.size() == 0 ? 1 : 0) != 0);
        HMapStFW m2 = HMapStFW.create((byte[])m1.serialize());
        Assert.assertTrue((m2.size() == 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(HMapStFWTest.class);
    }
}

