/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import tl.lin.data.map.HashMapWritable;

public class HashMapWritableTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        HashMapWritable map = new HashMapWritable();
        map.put((Object)new Text("hi"), (Object)new IntWritable(5));
        map.put((Object)new Text("there"), (Object)new IntWritable(22));
        Assert.assertEquals((long)map.size(), (long)2L);
        Text key = new Text("hi");
        IntWritable value = (IntWritable)map.get((Object)key);
        Assert.assertTrue((value != null ? 1 : 0) != 0);
        Assert.assertEquals((long)value.get(), (long)5L);
        value = (IntWritable)map.remove((Object)key);
        Assert.assertEquals((long)map.size(), (long)1L);
        key = new Text("there");
        value = (IntWritable)map.get((Object)key);
        Assert.assertTrue((value != null ? 1 : 0) != 0);
        Assert.assertEquals((long)value.get(), (long)22L);
    }

    @org.junit.Test
    public void testSerialize1() throws IOException {
        HashMapWritable origMap = new HashMapWritable();
        origMap.put((Object)new Text("hi"), (Object)new IntWritable(5));
        origMap.put((Object)new Text("there"), (Object)new IntWritable(22));
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        origMap.write((DataOutput)dataOut);
        HashMapWritable map = new HashMapWritable();
        map.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((long)map.size(), (long)2L);
        Text key = new Text("hi");
        IntWritable value = (IntWritable)map.get((Object)key);
        Assert.assertTrue((value != null ? 1 : 0) != 0);
        Assert.assertEquals((long)value.get(), (long)5L);
        value = (IntWritable)map.remove((Object)key);
        Assert.assertEquals((long)map.size(), (long)1L);
        key = new Text("there");
        value = (IntWritable)map.get((Object)key);
        Assert.assertTrue((value != null ? 1 : 0) != 0);
        Assert.assertEquals((long)value.get(), (long)22L);
    }

    @org.junit.Test
    public void testSerialize2() throws IOException {
        HashMapWritable origMap = new HashMapWritable();
        origMap.put((Object)new Text("hi"), (Object)new LongWritable(52L));
        origMap.put((Object)new Text("there"), (Object)new LongWritable(77L));
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        origMap.write((DataOutput)dataOut);
        HashMapWritable map = new HashMapWritable();
        map.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((long)map.size(), (long)2L);
        Text key = new Text("hi");
        LongWritable value = (LongWritable)map.get((Object)key);
        Assert.assertTrue((value != null ? 1 : 0) != 0);
        Assert.assertEquals((long)value.get(), (long)52L);
        value = (LongWritable)map.remove((Object)key);
        Assert.assertEquals((long)map.size(), (long)1L);
        key = new Text("there");
        value = (LongWritable)map.get((Object)key);
        Assert.assertTrue((value != null ? 1 : 0) != 0);
        Assert.assertEquals((long)value.get(), (long)77L);
    }

    @org.junit.Test
    public void testTypeSafety() throws IOException {
        HashMapWritable origMap = new HashMapWritable();
        origMap.put((Object)new Text("hi"), (Object)new FloatWritable(5.3f));
        origMap.put((Object)new Text("there"), (Object)new Text("bbb"));
        Assert.assertEquals((double)5.3f, (double)((FloatWritable)origMap.get((Object)new Text("hi"))).get(), (double)1.0E-5);
        Assert.assertEquals((Object)"bbb", (Object)((Writable)origMap.get((Object)new Text("there"))).toString());
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        origMap.write((DataOutput)dataOut);
        HashMapWritable map = new HashMapWritable();
        map.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((double)5.3f, (double)((FloatWritable)map.get((Object)new Text("hi"))).get(), (double)1.0E-5);
        Assert.assertNotEquals((Object)"bbb", (Object)((Writable)map.get((Object)new Text("there"))).toString());
    }

    @org.junit.Test
    public void testSerializeEmpty() throws IOException {
        HashMapWritable map = new HashMapWritable();
        Assert.assertTrue((map.size() == 0 ? 1 : 0) != 0);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        map.write((DataOutput)dataOut);
        HashMapWritable newList = new HashMapWritable();
        newList.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertTrue((newList.size() == 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(HashMapWritableTest.class);
    }
}

