/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.pair;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.junit.Assert;
import tl.lin.data.WritableComparatorTestHarness;
import tl.lin.data.pair.PairOfIntString;

public class PairOfIntStringTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        PairOfIntString pair = new PairOfIntString(1, "2");
        Assert.assertEquals((long)1L, (long)pair.getLeftElement());
        Assert.assertEquals((Object)"2", (Object)pair.getRightElement());
    }

    @org.junit.Test
    public void testSerialize() throws IOException {
        PairOfIntString origPair = new PairOfIntString(1, "2");
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        origPair.write((DataOutput)dataOut);
        PairOfIntString pair = new PairOfIntString();
        pair.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((long)1L, (long)pair.getLeftElement());
        Assert.assertEquals((Object)"2", (Object)pair.getRightElement());
    }

    @org.junit.Test
    public void testComparison1() throws IOException {
        PairOfIntString pair1 = new PairOfIntString(1, "2");
        PairOfIntString pair2 = new PairOfIntString(1, "2");
        PairOfIntString pair3 = new PairOfIntString(1, "1");
        PairOfIntString pair4 = new PairOfIntString(0, "9");
        PairOfIntString pair5 = new PairOfIntString(9, "0");
        Assert.assertTrue((boolean)pair1.equals((Object)pair2));
        Assert.assertFalse((boolean)pair1.equals((Object)pair3));
        Assert.assertTrue((pair1.compareTo(pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair3.compareTo(pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair4.compareTo(pair5) < 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testComparison2() throws IOException {
        PairOfIntString.Comparator comparator = new PairOfIntString.Comparator();
        PairOfIntString pair1 = new PairOfIntString(1, "2");
        PairOfIntString pair2 = new PairOfIntString(1, "2");
        PairOfIntString pair3 = new PairOfIntString(1, "1");
        PairOfIntString pair4 = new PairOfIntString(0, "9");
        PairOfIntString pair5 = new PairOfIntString(9, "0");
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair1, (WritableComparable)pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair1, (WritableComparable)pair3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair1, (WritableComparable)pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair1, (WritableComparable)pair5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair3, (WritableComparable)pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair4, (WritableComparable)pair5) < 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(PairOfIntStringTest.class);
    }
}

