/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.pair;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.junit.Assert;
import tl.lin.data.WritableComparatorTestHarness;
import tl.lin.data.pair.PairOfStringFloat;

public class PairOfStringFloatTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        PairOfStringFloat pair = new PairOfStringFloat("hi", 1.0f);
        Assert.assertEquals((Object)"hi", (Object)pair.getLeftElement());
        Assert.assertTrue((pair.getRightElement() == 1.0f ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testSerialize() throws IOException {
        PairOfStringFloat origPair = new PairOfStringFloat("hi", 2.0f);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        origPair.write((DataOutput)dataOut);
        PairOfStringFloat pair = new PairOfStringFloat();
        pair.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((Object)"hi", (Object)pair.getLeftElement());
        Assert.assertTrue((pair.getRightElement() == 2.0f ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testComparison1() throws IOException {
        PairOfStringFloat pair1 = new PairOfStringFloat("hi", 1.0f);
        PairOfStringFloat pair2 = new PairOfStringFloat("hi", 1.0f);
        PairOfStringFloat pair3 = new PairOfStringFloat("hi", 0.0f);
        PairOfStringFloat pair4 = new PairOfStringFloat("a", 0.0f);
        PairOfStringFloat pair5 = new PairOfStringFloat("hi", 2.0f);
        Assert.assertTrue((boolean)pair1.equals((Object)pair2));
        Assert.assertFalse((boolean)pair1.equals((Object)pair3));
        Assert.assertTrue((pair1.compareTo(pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair3.compareTo(pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair4.compareTo(pair5) < 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testComparison2() throws IOException {
        PairOfStringFloat.Comparator comparator = new PairOfStringFloat.Comparator();
        PairOfStringFloat pair1 = new PairOfStringFloat("hi", 1.0f);
        PairOfStringFloat pair2 = new PairOfStringFloat("hi", 1.0f);
        PairOfStringFloat pair3 = new PairOfStringFloat("hi", 0.0f);
        PairOfStringFloat pair4 = new PairOfStringFloat("a", 0.0f);
        PairOfStringFloat pair5 = new PairOfStringFloat("hi", 2.0f);
        Assert.assertTrue((boolean)pair1.equals((Object)pair2));
        Assert.assertFalse((boolean)pair1.equals((Object)pair3));
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair1, (WritableComparable)pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair1, (WritableComparable)pair3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair1, (WritableComparable)pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair1, (WritableComparable)pair5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair3, (WritableComparable)pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair4, (WritableComparable)pair5) < 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(PairOfStringFloatTest.class);
    }
}

