/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.pair;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.junit.Assert;
import tl.lin.data.WritableComparatorTestHarness;
import tl.lin.data.pair.PairOfStringInt;

public class PairOfStringIntTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        PairOfStringInt pair = new PairOfStringInt("hi", 1);
        Assert.assertEquals((Object)"hi", (Object)pair.getLeftElement());
        Assert.assertEquals((long)1L, (long)pair.getRightElement());
    }

    @org.junit.Test
    public void testSerialize() throws IOException {
        PairOfStringInt origPair = new PairOfStringInt("hi", 2);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        origPair.write((DataOutput)dataOut);
        PairOfStringInt pair = new PairOfStringInt();
        pair.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((Object)"hi", (Object)pair.getLeftElement());
        Assert.assertEquals((long)2L, (long)pair.getRightElement());
    }

    @org.junit.Test
    public void testComparison1() throws IOException {
        PairOfStringInt pair1 = new PairOfStringInt("hi", 1);
        PairOfStringInt pair2 = new PairOfStringInt("hi", 1);
        PairOfStringInt pair3 = new PairOfStringInt("hi", 0);
        PairOfStringInt pair4 = new PairOfStringInt("a", 0);
        PairOfStringInt pair5 = new PairOfStringInt("hi", 2);
        Assert.assertTrue((boolean)pair1.equals((Object)pair2));
        Assert.assertFalse((boolean)pair1.equals((Object)pair3));
        Assert.assertTrue((pair1.compareTo(pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair1.compareTo(pair5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair3.compareTo(pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((pair4.compareTo(pair5) < 0 ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void testComparison2() throws IOException {
        PairOfStringInt.Comparator comparator = new PairOfStringInt.Comparator();
        PairOfStringInt pair1 = new PairOfStringInt("hi", 1);
        PairOfStringInt pair2 = new PairOfStringInt("hi", 1);
        PairOfStringInt pair3 = new PairOfStringInt("hi", 0);
        PairOfStringInt pair4 = new PairOfStringInt("a", 0);
        PairOfStringInt pair5 = new PairOfStringInt("hi", 2);
        Assert.assertTrue((boolean)pair1.equals((Object)pair2));
        Assert.assertFalse((boolean)pair1.equals((Object)pair3));
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair1, (WritableComparable)pair2) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair1, (WritableComparable)pair3) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair1, (WritableComparable)pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair1, (WritableComparable)pair5) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair3, (WritableComparable)pair4) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((WritableComparatorTestHarness.compare((WritableComparator)comparator, (WritableComparable)pair4, (WritableComparable)pair5) < 0 ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(PairOfStringIntTest.class);
    }
}

