/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.pair;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.junit.Assert;
import tl.lin.data.pair.PairOfWritables;

public class PairOfWritablesTest {
    @org.junit.Test
    public void testBasic() throws IOException {
        PairOfWritables pair1 = new PairOfWritables((Writable)new Text("hi"), (Writable)new IntWritable(1));
        Assert.assertEquals((Object)new Text("hi"), (Object)pair1.getLeftElement());
        Assert.assertEquals((Object)new IntWritable(1), (Object)pair1.getRightElement());
        PairOfWritables pair2 = new PairOfWritables((Writable)new IntWritable(1), (Writable)new FloatWritable(1.0f));
        Assert.assertEquals((Object)new IntWritable(1), (Object)pair2.getLeftElement());
        Assert.assertEquals((Object)new FloatWritable(1.0f), (Object)pair2.getRightElement());
    }

    @org.junit.Test
    public void testSerialize() throws IOException {
        PairOfWritables origPair = new PairOfWritables((Writable)new Text("hi"), (Writable)new IntWritable(1));
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        origPair.write((DataOutput)dataOut);
        PairOfWritables pair = new PairOfWritables();
        pair.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((Object)new Text("hi"), (Object)pair.getLeftElement());
        Assert.assertEquals((Object)new IntWritable(1), (Object)pair.getRightElement());
    }

    public static Test suite() {
        return new JUnit4TestAdapter(PairOfWritablesTest.class);
    }
}

