/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.queue;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.util.Random;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import tl.lin.data.pair.PairOfIntFloat;
import tl.lin.data.queue.TopScoredInts;

public class TopScoredIntsTest {
    @org.junit.Test
    public void testRandom() {
        Random random = new Random();
        TopScoredInts set = new TopScoredInts(10);
        for (int i = 0; i < 10000; ++i) {
            set.add(random.nextInt(Integer.MAX_VALUE), random.nextFloat());
        }
        Assert.assertEquals((long)10L, (long)set.getMaxElements());
        Assert.assertEquals((long)10L, (long)set.size());
        PairOfIntFloat[] arr = set.extractAll();
        Assert.assertEquals((long)10L, (long)arr.length);
        for (int i = 0; i < arr.length - 1; ++i) {
            Assert.assertTrue((arr[i].getValue() > arr[i + 1].getValue() ? 1 : 0) != 0);
        }
    }

    @org.junit.Test
    public void testBasic1() {
        TopScoredInts set = new TopScoredInts(5);
        set.add(1, 0.0f);
        set.add(2, 5.0f);
        set.add(3, 4.0f);
        set.add(4, 6.0f);
        set.add(5, 1.0f);
        set.add(6, 199.0f);
        set.add(7, -31.0f);
        PairOfIntFloat[] arr = set.extractAll();
        Assert.assertEquals((long)5L, (long)arr.length);
        Assert.assertEquals((long)6L, (long)arr[0].getLeftElement());
        Assert.assertEquals((double)199.0, (double)arr[0].getRightElement(), (double)1.0E-5);
        Assert.assertEquals((long)4L, (long)arr[1].getLeftElement());
        Assert.assertEquals((double)6.0, (double)arr[1].getRightElement(), (double)1.0E-5);
        Assert.assertEquals((long)2L, (long)arr[2].getLeftElement());
        Assert.assertEquals((double)5.0, (double)arr[2].getRightElement(), (double)1.0E-5);
        Assert.assertEquals((long)3L, (long)arr[3].getLeftElement());
        Assert.assertEquals((double)4.0, (double)arr[3].getRightElement(), (double)1.0E-5);
        Assert.assertEquals((long)5L, (long)arr[4].getLeftElement());
        Assert.assertEquals((double)1.0, (double)arr[4].getRightElement(), (double)1.0E-5);
    }

    @org.junit.Test
    public void testBasic2() {
        TopScoredInts set = new TopScoredInts(5);
        set.add(1, 5.0f);
        set.add(2, 5.0f);
        set.add(3, 4.0f);
        set.add(4, 6.0f);
        set.add(5, 1.0f);
        set.add(6, 1.0f);
        PairOfIntFloat[] arr = set.extractAll();
        Assert.assertEquals((long)5L, (long)arr.length);
        Assert.assertEquals((long)4L, (long)arr[0].getLeftElement());
        Assert.assertEquals((double)6.0, (double)arr[0].getRightElement(), (double)1.0E-5);
        Assert.assertEquals((long)2L, (long)arr[1].getLeftElement());
        Assert.assertEquals((double)5.0, (double)arr[2].getRightElement(), (double)1.0E-5);
        Assert.assertEquals((long)1L, (long)arr[2].getLeftElement());
        Assert.assertEquals((double)5.0, (double)arr[2].getRightElement(), (double)1.0E-5);
        Assert.assertEquals((long)3L, (long)arr[3].getLeftElement());
        Assert.assertEquals((double)4.0, (double)arr[3].getRightElement(), (double)1.0E-5);
        Assert.assertEquals((long)6L, (long)arr[4].getLeftElement());
        Assert.assertEquals((double)1.0, (double)arr[4].getRightElement(), (double)1.0E-5);
    }

    @org.junit.Test
    public void testBasic3() {
        TopScoredInts set = new TopScoredInts(5);
        set.add(1, 5.0f);
        set.add(2, 4.0f);
        set.add(3, 6.0f);
        Assert.assertEquals((long)5L, (long)set.getMaxElements());
        Assert.assertEquals((long)3L, (long)set.size());
        PairOfIntFloat[] arr = set.extractAll();
        Assert.assertEquals((long)3L, (long)arr.length);
        Assert.assertEquals((long)3L, (long)arr[0].getLeftElement());
        Assert.assertEquals((double)6.0, (double)arr[0].getRightElement(), (double)1.0E-5);
        Assert.assertEquals((long)1L, (long)arr[1].getLeftElement());
        Assert.assertEquals((double)5.0, (double)arr[1].getRightElement(), (double)1.0E-5);
        Assert.assertEquals((long)2L, (long)arr[2].getLeftElement());
        Assert.assertEquals((double)4.0, (double)arr[2].getRightElement(), (double)1.0E-5);
    }

    @org.junit.Test
    public void testTieBreaking() {
        TopScoredInts set = new TopScoredInts(5);
        set.add(1, 1.0f);
        set.add(2, 1.0f);
        set.add(3, 1.0f);
        set.add(4, 1.0f);
        set.add(5, 1.0f);
        set.add(6, 1.0f);
        set.add(7, 1.0f);
        PairOfIntFloat[] arr = set.extractAll();
        Assert.assertEquals((long)5L, (long)arr.length);
        Assert.assertEquals((long)7L, (long)arr[0].getLeftElement());
        Assert.assertEquals((double)1.0, (double)arr[0].getRightElement(), (double)1.0E-5);
        Assert.assertEquals((long)6L, (long)arr[1].getLeftElement());
        Assert.assertEquals((double)1.0, (double)arr[1].getRightElement(), (double)1.0E-5);
        Assert.assertEquals((long)5L, (long)arr[2].getLeftElement());
        Assert.assertEquals((double)1.0, (double)arr[2].getRightElement(), (double)1.0E-5);
        Assert.assertEquals((long)4L, (long)arr[3].getLeftElement());
        Assert.assertEquals((double)1.0, (double)arr[3].getRightElement(), (double)1.0E-5);
        Assert.assertEquals((long)3L, (long)arr[4].getLeftElement());
        Assert.assertEquals((double)1.0, (double)arr[4].getRightElement(), (double)1.0E-5);
    }

    @org.junit.Test
    public void testSerialization() throws Exception {
        TopScoredInts set = new TopScoredInts(5);
        set.add(1, 5.0f);
        set.add(2, 5.0f);
        set.add(3, 4.0f);
        set.add(4, 6.0f);
        set.add(5, 1.0f);
        set.add(6, 1.0f);
        Assert.assertEquals((long)5L, (long)set.getMaxElements());
        Assert.assertEquals((long)5L, (long)set.size());
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        set.write((DataOutput)dataOut);
        TopScoredInts reconstructed = new TopScoredInts();
        reconstructed.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(bytesOut.toByteArray())));
        Assert.assertEquals((long)5L, (long)set.getMaxElements());
        Assert.assertEquals((long)0L, (long)set.size());
        Assert.assertEquals((long)5L, (long)reconstructed.getMaxElements());
        Assert.assertEquals((long)5L, (long)reconstructed.size());
        PairOfIntFloat[] arr = reconstructed.extractAll();
        Assert.assertEquals((long)5L, (long)arr.length);
        Assert.assertEquals((long)4L, (long)arr[0].getLeftElement());
        Assert.assertEquals((double)6.0, (double)arr[0].getRightElement(), (double)1.0E-5);
        Assert.assertEquals((long)2L, (long)arr[1].getLeftElement());
        Assert.assertEquals((double)5.0, (double)arr[2].getRightElement(), (double)1.0E-5);
        Assert.assertEquals((long)1L, (long)arr[2].getLeftElement());
        Assert.assertEquals((double)5.0, (double)arr[2].getRightElement(), (double)1.0E-5);
        Assert.assertEquals((long)3L, (long)arr[3].getLeftElement());
        Assert.assertEquals((double)4.0, (double)arr[3].getRightElement(), (double)1.0E-5);
        Assert.assertEquals((long)6L, (long)arr[4].getLeftElement());
        Assert.assertEquals((double)1.0, (double)arr[4].getRightElement(), (double)1.0E-5);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(TopScoredIntsTest.class);
    }
}

