/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.fd;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import tl.lin.data.fd.Int2LongFrequencyDistribution;
import tl.lin.data.fd.SortableEntries;
import tl.lin.data.map.HMapILW;
import tl.lin.data.map.MapIL;
import tl.lin.data.pair.PairOfIntLong;

public class Int2LongFrequencyDistributionEntry
implements Int2LongFrequencyDistribution {
    private HMapILW counts = new HMapILW();
    private long sumOfCounts = 0L;
    private final Comparator<PairOfIntLong> comparatorRightDescending = new Comparator<PairOfIntLong>(){

        @Override
        public int compare(PairOfIntLong e1, PairOfIntLong e2) {
            if (e1.getRightElement() > e2.getRightElement()) {
                return -1;
            }
            if (e1.getRightElement() < e2.getRightElement()) {
                return 1;
            }
            if (e1.getLeftElement() == e2.getLeftElement()) {
                throw new RuntimeException("Event observed twice!");
            }
            return e1.getLeftElement() < e2.getLeftElement() ? -1 : 1;
        }
    };
    private final Comparator<PairOfIntLong> comparatorRightAscending = new Comparator<PairOfIntLong>(){

        @Override
        public int compare(PairOfIntLong e1, PairOfIntLong e2) {
            if (e1.getRightElement() > e2.getRightElement()) {
                return 1;
            }
            if (e1.getRightElement() < e2.getRightElement()) {
                return -1;
            }
            if (e1.getLeftElement() == e2.getLeftElement()) {
                throw new RuntimeException("Event observed twice!");
            }
            return e1.getLeftElement() < e2.getLeftElement() ? -1 : 1;
        }
    };
    private final Comparator<PairOfIntLong> comparatorLeftAscending = new Comparator<PairOfIntLong>(){

        @Override
        public int compare(PairOfIntLong e1, PairOfIntLong e2) {
            if (e1.getLeftElement() > e2.getLeftElement()) {
                return 1;
            }
            if (e1.getLeftElement() < e2.getLeftElement()) {
                return -1;
            }
            throw new RuntimeException("Event observed twice!");
        }
    };
    private final Comparator<PairOfIntLong> comparatorLeftDescending = new Comparator<PairOfIntLong>(){

        @Override
        public int compare(PairOfIntLong e1, PairOfIntLong e2) {
            if (e1.getLeftElement() > e2.getLeftElement()) {
                return -1;
            }
            if (e1.getLeftElement() < e2.getLeftElement()) {
                return 1;
            }
            throw new RuntimeException("Event observed twice!");
        }
    };

    @Override
    public void increment(int key) {
        if (this.contains(key)) {
            this.set(key, this.get(key) + 1L);
        } else {
            this.set(key, 1L);
        }
    }

    @Override
    public void increment(int key, long cnt) {
        if (this.contains(key)) {
            this.set(key, this.get(key) + cnt);
        } else {
            this.set(key, cnt);
        }
    }

    @Override
    public void decrement(int key) {
        if (this.contains(key)) {
            long v = this.get(key);
            if (v == 1L) {
                this.remove(key);
            } else {
                this.set(key, v - 1L);
            }
        } else {
            throw new RuntimeException("Can't decrement non-existent event!");
        }
    }

    @Override
    public void decrement(int key, long cnt) {
        if (this.contains(key)) {
            long v = this.get(key);
            if (v < cnt) {
                throw new RuntimeException("Can't decrement past zero!");
            }
            if (v == cnt) {
                this.remove(key);
            } else {
                this.set(key, v - cnt);
            }
        } else {
            throw new RuntimeException("Can't decrement non-existent event!");
        }
    }

    @Override
    public boolean contains(int key) {
        return this.counts.containsKey(key);
    }

    @Override
    public long get(int key) {
        return this.counts.get(key);
    }

    @Override
    public double computeRelativeFrequency(int k) {
        return (double)this.counts.get(k) / (double)this.getSumOfCounts();
    }

    @Override
    public double computeLogRelativeFrequency(int k) {
        return Math.log(this.counts.get(k)) - Math.log(this.getSumOfCounts());
    }

    @Override
    public long set(int k, long v) {
        long rv = this.counts.put(k, v);
        this.sumOfCounts = this.sumOfCounts - rv + v;
        return rv;
    }

    @Override
    public long remove(int k) {
        long rv = this.counts.remove(k);
        this.sumOfCounts -= rv;
        return rv;
    }

    @Override
    public void clear() {
        this.counts.clear();
        this.sumOfCounts = 0L;
    }

    @Override
    public int getNumberOfEvents() {
        return this.counts.size();
    }

    @Override
    public long getSumOfCounts() {
        return this.sumOfCounts;
    }

    @Override
    public Iterator<PairOfIntLong> iterator() {
        return new Iterator<PairOfIntLong>(){
            private Iterator<MapIL.Entry> iter;
            private final PairOfIntLong pair;
            {
                this.iter = Int2LongFrequencyDistributionEntry.this.counts.entrySet().iterator();
                this.pair = new PairOfIntLong();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public PairOfIntLong next() {
                if (!this.hasNext()) {
                    return null;
                }
                MapIL.Entry entry = this.iter.next();
                this.pair.set(entry.getKey(), entry.getValue());
                return this.pair;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public List<PairOfIntLong> getEntries(SortableEntries.Order ordering) {
        if (ordering.equals((Object)SortableEntries.Order.ByRightElementDescending)) {
            return this.getEntriesSorted(this.comparatorRightDescending);
        }
        if (ordering.equals((Object)SortableEntries.Order.ByLeftElementAscending)) {
            return this.getEntriesSorted(this.comparatorLeftAscending);
        }
        if (ordering.equals((Object)SortableEntries.Order.ByRightElementAscending)) {
            return this.getEntriesSorted(this.comparatorRightAscending);
        }
        if (ordering.equals((Object)SortableEntries.Order.ByLeftElementDescending)) {
            return this.getEntriesSorted(this.comparatorLeftDescending);
        }
        return null;
    }

    @Override
    public List<PairOfIntLong> getEntries(SortableEntries.Order ordering, int n) {
        if (ordering.equals((Object)SortableEntries.Order.ByRightElementDescending)) {
            return this.getEntriesSorted(this.comparatorRightDescending, n);
        }
        if (ordering.equals((Object)SortableEntries.Order.ByLeftElementAscending)) {
            return this.getEntriesSorted(this.comparatorLeftAscending, n);
        }
        if (ordering.equals((Object)SortableEntries.Order.ByRightElementAscending)) {
            return this.getEntriesSorted(this.comparatorRightAscending, n);
        }
        if (ordering.equals((Object)SortableEntries.Order.ByLeftElementDescending)) {
            return this.getEntriesSorted(this.comparatorLeftDescending, n);
        }
        return null;
    }

    private List<PairOfIntLong> getEntriesSorted(Comparator<PairOfIntLong> comparator) {
        ArrayList list = Lists.newArrayList();
        for (MapIL.Entry e : this.counts.entrySet()) {
            list.add(new PairOfIntLong(e.getKey(), e.getValue()));
        }
        Collections.sort(list, comparator);
        return list;
    }

    private List<PairOfIntLong> getEntriesSorted(Comparator<PairOfIntLong> comparator, int n) {
        List<PairOfIntLong> list = this.getEntriesSorted(comparator);
        return list.subList(0, n);
    }

    public void readFields(DataInput in) throws IOException {
        this.sumOfCounts = in.readLong();
        this.counts.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.sumOfCounts);
        this.counts.write(out);
    }
}

