/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import tl.lin.data.map.HMapIF;
import tl.lin.data.map.MapIF;

public class HMapIFW
extends HMapIF
implements Writable {
    private static boolean LazyDecode = false;
    private static final long serialVersionUID = 4760032853L;
    private int numEntries = 0;
    private int[] keys = null;
    private float[] values = null;

    public void readFields(DataInput in) throws IOException {
        this.clear();
        this.numEntries = in.readInt();
        if (this.numEntries == 0) {
            return;
        }
        if (LazyDecode) {
            this.keys = new int[this.numEntries];
            this.values = new float[this.numEntries];
            for (int i = 0; i < this.numEntries; ++i) {
                this.keys[i] = in.readInt();
                this.values[i] = in.readFloat();
            }
        } else {
            for (int i = 0; i < this.numEntries; ++i) {
                this.put(in.readInt(), in.readFloat());
            }
        }
    }

    public void decode() {
        if (this.keys == null) {
            return;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            this.put(this.keys[i], this.values[i]);
        }
        this.keys = null;
        this.values = null;
    }

    public boolean isDecoded() {
        if (!HMapIFW.getLazyDecodeFlag()) {
            return true;
        }
        return this.keys == null;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.size() == 0) {
            return;
        }
        for (MapIF.Entry e : this.entrySet()) {
            out.writeInt(e.getKey());
            out.writeFloat(e.getValue());
        }
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        this.write(dataOut);
        return bytesOut.toByteArray();
    }

    public static HMapIFW create(DataInput in) throws IOException {
        HMapIFW m = new HMapIFW();
        m.readFields(in);
        return m;
    }

    public static HMapIFW create(byte[] bytes) throws IOException {
        return HMapIFW.create(new DataInputStream(new ByteArrayInputStream(bytes)));
    }

    public static void setLazyDecodeFlag(boolean b) {
        LazyDecode = b;
    }

    public static boolean getLazyDecodeFlag() {
        return LazyDecode;
    }

    public int[] getKeys() {
        return this.keys;
    }

    public float[] getValues() {
        return this.values;
    }

    public void plus(HMapIFW m) {
        if (!this.isDecoded()) {
            this.decode();
        }
        if (!m.isDecoded()) {
            int[] k = m.getKeys();
            float[] v = m.getValues();
            for (int i = 0; i < k.length; ++i) {
                if (this.containsKey(k[i])) {
                    this.put(k[i], this.get(k[i]) + v[i]);
                    continue;
                }
                this.put(k[i], v[i]);
            }
        } else {
            super.plus(m);
        }
    }

    @Override
    public int size() {
        if (!this.isDecoded()) {
            return this.keys.length;
        }
        return super.size();
    }
}

