/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import tl.lin.data.map.HMapIL;
import tl.lin.data.map.MapIL;

public class HMapILW
extends HMapIL
implements Writable {
    private static boolean LazyDecode = false;
    private static final long serialVersionUID = 2794563945L;
    private int numEntries = 0;
    private int[] keys = null;
    private long[] values = null;

    public void readFields(DataInput in) throws IOException {
        this.clear();
        this.numEntries = in.readInt();
        if (this.numEntries == 0) {
            return;
        }
        if (LazyDecode) {
            this.keys = new int[this.numEntries];
            this.values = new long[this.numEntries];
            for (int i = 0; i < this.numEntries; ++i) {
                this.keys[i] = in.readInt();
                this.values[i] = in.readLong();
            }
        } else {
            for (int i = 0; i < this.numEntries; ++i) {
                this.put(in.readInt(), in.readLong());
            }
        }
    }

    public void decode() throws IOException {
        if (this.keys == null) {
            return;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            this.put(this.keys[i], this.values[i]);
        }
        this.keys = null;
        this.values = null;
    }

    public boolean isDecoded() {
        if (!HMapILW.getLazyDecodeFlag()) {
            return true;
        }
        return this.keys == null;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.size() == 0) {
            return;
        }
        for (MapIL.Entry e : this.entrySet()) {
            out.writeInt(e.getKey());
            out.writeLong(e.getValue());
        }
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        this.write(dataOut);
        return bytesOut.toByteArray();
    }

    public static HMapILW create(DataInput in) throws IOException {
        HMapILW m = new HMapILW();
        m.readFields(in);
        return m;
    }

    public static HMapILW create(byte[] bytes) throws IOException {
        return HMapILW.create(new DataInputStream(new ByteArrayInputStream(bytes)));
    }

    public static void setLazyDecodeFlag(boolean b) {
        LazyDecode = b;
    }

    public static boolean getLazyDecodeFlag() {
        return LazyDecode;
    }

    public int[] getKeys() {
        return this.keys;
    }

    public long[] getValues() {
        return this.values;
    }

    public void lazyplus(HMapILW m) {
        int[] k = m.getKeys();
        long[] v = m.getValues();
        for (int i = 0; i < k.length; ++i) {
            if (this.containsKey(k[i])) {
                this.put(k[i], this.get(k[i]) + v[i]);
                continue;
            }
            this.put(k[i], v[i]);
        }
    }

    @Override
    public int size() {
        if (!this.isDecoded()) {
            return this.keys.length;
        }
        return super.size();
    }
}

