/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import tl.lin.data.map.HMapKI;
import tl.lin.data.map.MapKI;

public class HMapStIW
extends HMapKI<String>
implements Writable {
    private static final long serialVersionUID = -9179978557431493856L;

    public void readFields(DataInput in) throws IOException {
        this.clear();
        int numEntries = in.readInt();
        if (numEntries == 0) {
            return;
        }
        for (int i = 0; i < numEntries; ++i) {
            String k = in.readUTF();
            int v = in.readInt();
            this.put(k, v);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.size() == 0) {
            return;
        }
        for (MapKI.Entry e : this.entrySet()) {
            out.writeUTF((String)e.getKey());
            out.writeInt(e.getValue());
        }
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        this.write(dataOut);
        return bytesOut.toByteArray();
    }

    public static HMapStIW create(DataInput in) throws IOException {
        HMapStIW m = new HMapStIW();
        m.readFields(in);
        return m;
    }

    public static HMapStIW create(byte[] bytes) throws IOException {
        return HMapStIW.create(new DataInputStream(new ByteArrayInputStream(bytes)));
    }
}

