/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.pair;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;

public class PairOfFloatString
implements WritableComparable<PairOfFloatString> {
    private float leftElement;
    private String rightElement;

    public PairOfFloatString() {
    }

    public PairOfFloatString(float left, String right) {
        this.set(left, right);
    }

    public void readFields(DataInput in) throws IOException {
        this.leftElement = in.readFloat();
        this.rightElement = Text.readString((DataInput)in);
    }

    public void write(DataOutput out) throws IOException {
        out.writeFloat(this.leftElement);
        Text.writeString((DataOutput)out, (String)this.rightElement);
    }

    public float getLeftElement() {
        return this.leftElement;
    }

    public String getRightElement() {
        return this.rightElement;
    }

    public String getValue() {
        return this.rightElement;
    }

    public float getKey() {
        return this.leftElement;
    }

    public void set(float left, String right) {
        this.rightElement = right;
        this.leftElement = left;
    }

    public boolean equals(Object obj) {
        PairOfFloatString pair = (PairOfFloatString)obj;
        return this.rightElement.equals(pair.getRightElement()) && this.leftElement == pair.getLeftElement();
    }

    public int compareTo(PairOfFloatString pair) {
        String pr = pair.getRightElement();
        float pl = pair.getLeftElement();
        if (this.leftElement == pl) {
            if (this.rightElement.equals(pr)) {
                return 0;
            }
            return this.rightElement.compareTo(pr);
        }
        return this.leftElement < pl ? -1 : 1;
    }

    public int hashCode() {
        return (int)this.leftElement + this.rightElement.hashCode();
    }

    public String toString() {
        return "(" + this.leftElement + ", " + this.rightElement + ")";
    }

    public PairOfFloatString clone() {
        return new PairOfFloatString(this.leftElement, this.rightElement);
    }

    static {
        WritableComparator.define(PairOfFloatString.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(PairOfFloatString.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            float thatLeftValue;
            float thisLeftValue = Comparator.readFloat((byte[])b1, (int)s1);
            if (thisLeftValue == (thatLeftValue = Comparator.readFloat((byte[])b2, (int)s2))) {
                int n1 = WritableUtils.decodeVIntSize((byte)b1[s1 + 4]);
                int n2 = WritableUtils.decodeVIntSize((byte)b2[s2 + 4]);
                return Comparator.compareBytes((byte[])b1, (int)(s1 + 4 + n1), (int)(l1 - n1 - 4), (byte[])b2, (int)(s2 + n2 + 4), (int)(l2 - n2 - 4));
            }
            return thisLeftValue < thatLeftValue ? -1 : 1;
        }
    }
}

