/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.pair;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;

public class PairOfIntString
implements WritableComparable<PairOfIntString> {
    private int leftElement;
    private String rightElement;

    public PairOfIntString() {
    }

    public PairOfIntString(int left, String right) {
        this.set(left, right);
    }

    public void readFields(DataInput in) throws IOException {
        this.leftElement = in.readInt();
        this.rightElement = Text.readString((DataInput)in);
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.leftElement);
        Text.writeString((DataOutput)out, (String)this.rightElement);
    }

    public int getLeftElement() {
        return this.leftElement;
    }

    public String getRightElement() {
        return this.rightElement;
    }

    public int getKey() {
        return this.leftElement;
    }

    public String getValue() {
        return this.rightElement;
    }

    public void set(int left, String right) {
        this.leftElement = left;
        this.rightElement = right;
    }

    public boolean equals(Object obj) {
        PairOfIntString pair = (PairOfIntString)obj;
        return this.leftElement == pair.getLeftElement() && this.rightElement.equals(pair.getRightElement());
    }

    public int compareTo(PairOfIntString pair) {
        int pl = pair.getLeftElement();
        String pr = pair.getRightElement();
        if (this.leftElement == pl) {
            return this.rightElement.compareTo(pr);
        }
        return this.leftElement < pl ? -1 : 1;
    }

    public int hashCode() {
        return this.leftElement + this.rightElement.hashCode();
    }

    public String toString() {
        return "(" + this.leftElement + ", " + this.rightElement + ")";
    }

    public PairOfIntString clone() {
        return new PairOfIntString(this.leftElement, this.rightElement);
    }

    static {
        WritableComparator.define(PairOfIntString.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(PairOfIntString.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            int thatLeftValue;
            int thisLeftValue = Comparator.readInt((byte[])b1, (int)s1);
            if (thisLeftValue == (thatLeftValue = Comparator.readInt((byte[])b2, (int)s2))) {
                int n1 = WritableUtils.decodeVIntSize((byte)b1[s1 + 4]);
                int n2 = WritableUtils.decodeVIntSize((byte)b2[s2 + 4]);
                return Comparator.compareBytes((byte[])b1, (int)(s1 + 4 + n1), (int)(l1 - n1 - 4), (byte[])b2, (int)(s2 + n2 + 4), (int)(l2 - n2 - 4));
            }
            return thisLeftValue < thatLeftValue ? -1 : (thisLeftValue == thatLeftValue ? 0 : 1);
        }
    }
}

