/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.pair;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

public class PairOfLongInt
implements WritableComparable<PairOfLongInt> {
    private long leftElement;
    private int rightElement;

    public PairOfLongInt() {
    }

    public PairOfLongInt(long left, int right) {
        this.set(left, right);
    }

    public void readFields(DataInput in) throws IOException {
        this.leftElement = in.readLong();
        this.rightElement = in.readInt();
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.leftElement);
        out.writeInt(this.rightElement);
    }

    public long getLeftElement() {
        return this.leftElement;
    }

    public int getRightElement() {
        return this.rightElement;
    }

    public long getKey() {
        return this.leftElement;
    }

    public int getValue() {
        return this.rightElement;
    }

    public void set(long left, int right) {
        this.leftElement = left;
        this.rightElement = right;
    }

    public boolean equals(Object obj) {
        PairOfLongInt pair = (PairOfLongInt)obj;
        return this.leftElement == pair.getLeftElement() && this.rightElement == pair.getRightElement();
    }

    public int compareTo(PairOfLongInt pair) {
        long pl = pair.getLeftElement();
        int pr = pair.getRightElement();
        if (this.leftElement == pl) {
            if (this.rightElement < pr) {
                return -1;
            }
            if (this.rightElement > pr) {
                return 1;
            }
            return 0;
        }
        if (this.leftElement < pl) {
            return -1;
        }
        return 1;
    }

    public int hashCode() {
        return (int)this.leftElement & this.rightElement;
    }

    public String toString() {
        return "(" + this.leftElement + ", " + this.rightElement + ")";
    }

    public PairOfLongInt clone() {
        return new PairOfLongInt(this.leftElement, this.rightElement);
    }

    static {
        WritableComparator.define(PairOfLongInt.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(PairOfLongInt.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            long thatLeftValue;
            long thisLeftValue = Comparator.readLong((byte[])b1, (int)s1);
            if (thisLeftValue == (thatLeftValue = Comparator.readLong((byte[])b2, (int)s2))) {
                int thatRightValue;
                int thisRightValue = Comparator.readInt((byte[])b1, (int)(s1 + 8));
                return thisRightValue < (thatRightValue = Comparator.readInt((byte[])b2, (int)(s2 + 8))) ? -1 : (thisRightValue == thatRightValue ? 0 : 1);
            }
            return thisLeftValue < thatLeftValue ? -1 : (thisLeftValue == thatLeftValue ? 0 : 1);
        }
    }
}

