/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.lucene;

import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.BufferedIndexOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemDirectory
extends Directory {
    private final FileSystem fs;
    private final Path directory;
    private final int ioFileBufferSize;

    public FileSystemDirectory(FileSystem fs, Path directory, boolean create, Configuration conf) throws IOException {
        this.fs = fs;
        this.directory = directory;
        this.ioFileBufferSize = conf.getInt("io.file.buffer.size", 4096);
        if (create) {
            this.create();
        }
        boolean isDir = false;
        try {
            FileStatus status = fs.getFileStatus(directory);
            if (status != null) {
                isDir = status.isDir();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (!isDir) {
            throw new IOException(directory + " is not a directory");
        }
    }

    private void create() throws IOException {
        if (!this.fs.exists(this.directory)) {
            this.fs.mkdirs(this.directory);
        }
        boolean isDir = false;
        try {
            FileStatus status = this.fs.getFileStatus(this.directory);
            if (status != null) {
                isDir = status.isDir();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!isDir) {
            throw new IOException(this.directory + " is not a directory");
        }
        this.fs.delete(this.directory, true);
    }

    public String[] list() throws IOException {
        FileStatus[] fileStatus = this.fs.listStatus(this.directory);
        String[] result = new String[fileStatus.length];
        for (int i = 0; i < fileStatus.length; ++i) {
            result[i] = fileStatus[i].getPath().getName();
        }
        return result;
    }

    public boolean fileExists(String name) throws IOException {
        return this.fs.exists(new Path(this.directory, name));
    }

    public long fileModified(String name) {
        throw new UnsupportedOperationException();
    }

    public void touchFile(String name) {
        throw new UnsupportedOperationException();
    }

    public long fileLength(String name) throws IOException {
        return this.fs.getFileStatus(new Path(this.directory, name)).getLen();
    }

    public void deleteFile(String name) throws IOException {
        if (!this.fs.delete(new Path(this.directory, name))) {
            throw new IOException("Cannot delete index file " + name);
        }
    }

    public void renameFile(String from, String to) throws IOException {
        this.fs.rename(new Path(this.directory, from), new Path(this.directory, to));
    }

    public IndexOutput createOutput(String name) throws IOException {
        Path file = new Path(this.directory, name);
        if (this.fs.exists(file) && !this.fs.delete(file)) {
            throw new IOException("Cannot overwrite index file " + file);
        }
        return new FileSystemIndexOutput(file, this.ioFileBufferSize);
    }

    public IndexInput openInput(String name) throws IOException {
        return this.openInput(name, this.ioFileBufferSize);
    }

    public IndexInput openInput(String name, int bufferSize) throws IOException {
        return new FileSystemIndexInput(new Path(this.directory, name), bufferSize);
    }

    public Lock makeLock(final String name) {
        return new Lock(){

            public boolean obtain() {
                return true;
            }

            public void release() {
            }

            public boolean isLocked() {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return "Lock@" + new Path(FileSystemDirectory.this.directory, name);
            }
        };
    }

    public void close() throws IOException {
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "@" + this.directory;
    }

    public IndexOutput createOutput(String arg0, IOContext arg1) throws IOException {
        return null;
    }

    public String[] listAll() throws IOException {
        return null;
    }

    public IndexInput openInput(String arg0, IOContext arg1) throws IOException {
        return this.openInput(arg0);
    }

    public void sync(Collection<String> arg0) throws IOException {
    }

    private class FileSystemIndexOutput
    extends BufferedIndexOutput {
        private final Path filePath;
        private final FSDataOutputStream out;
        private boolean isOpen;

        public FileSystemIndexOutput(Path path, int ioFileBufferSize) throws IOException {
            this.filePath = path;
            this.out = FileSystemDirectory.this.fs.create(path, true, ioFileBufferSize);
            this.isOpen = true;
        }

        public void flushBuffer(byte[] b, int offset, int size) throws IOException {
            this.out.write(b, offset, size);
        }

        public void close() throws IOException {
            if (!this.isOpen) {
                throw new IOException("Index file " + this.filePath + " already closed");
            }
            super.close();
            this.out.close();
            this.isOpen = false;
        }

        public void seek(long pos) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long length() throws IOException {
            return this.out.getPos();
        }

        protected void finalize() throws IOException {
            if (this.isOpen) {
                this.close();
            }
        }
    }

    private class FileSystemIndexInput
    extends BufferedIndexInput {
        private final Path filePath;
        private final Descriptor descriptor;
        private final long length;
        private boolean isOpen;
        private boolean isClone;

        public FileSystemIndexInput(Path path, int ioFileBufferSize) throws IOException {
            super(path.toString(), ioFileBufferSize);
            this.filePath = path;
            this.descriptor = new Descriptor(path, ioFileBufferSize);
            this.length = FileSystemDirectory.this.fs.getFileStatus(path).getLen();
            this.isOpen = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void readInternal(byte[] b, int offset, int len) throws IOException {
            Descriptor descriptor = this.descriptor;
            synchronized (descriptor) {
                int i;
                long position = this.getFilePointer();
                if (position != this.descriptor.position) {
                    this.descriptor.in.seek(position);
                    this.descriptor.position = position;
                }
                int total = 0;
                do {
                    if ((i = this.descriptor.in.read(b, offset + total, len - total)) == -1) {
                        throw new IOException("Read past EOF");
                    }
                    this.descriptor.position += (long)i;
                } while ((total += i) < len);
            }
        }

        public void close() throws IOException {
            if (!this.isClone) {
                if (this.isOpen) {
                    this.descriptor.in.close();
                    this.isOpen = false;
                } else {
                    throw new IOException("Index file " + this.filePath + " already closed");
                }
            }
        }

        protected void seekInternal(long position) {
        }

        public long length() {
            return this.length;
        }

        protected void finalize() throws IOException {
            if (!this.isClone && this.isOpen) {
                this.close();
            }
        }

        public BufferedIndexInput clone() {
            FileSystemIndexInput clone = (FileSystemIndexInput)super.clone();
            clone.isClone = true;
            return clone;
        }

        private class Descriptor {
            public final FSDataInputStream in;
            public long position;

            public Descriptor(Path file, int ioFileBufferSize) throws IOException {
                this.in = FileSystemDirectory.this.fs.open(file, ioFileBufferSize);
            }
        }
    }
}

