/*
 * DomUI Java User Interface - shared code
 * Copyright (c) 2010 by Frits Jalvingh, Itris B.V.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * See the "sponsors" file for a list of supporters.
 *
 * The latest version of DomUI and related code, support and documentation
 * can be found at http://www.domui.org/
 * The contact for the project is Frits Jalvingh <jal@etc.to>.
 */
/** Auto-generated by HtmlEntity on Fri Jan 18 15:57:41 CET 2002 */
package to.etc.util;

public class HtmlEntityTables {

	static public final String[]	m_nameStrTbl	= {"AElig", "Aacute", "Acirc", "Agrave", "Alpha", "Aring", "Atilde", "Auml", "Beta", "Ccedil", "Chi", "Dagger", "Delta", "ETH", "Eacute", "Ecirc",
		"Egrave", "Epsilon", "Eta", "Euml", "Gamma", "Iacute", "Icirc", "Igrave", "Iota", "Iuml", "Kappa", "Lambda", "Mu", "Ntilde", "Nu", "OElig", "Oacute", "Ocirc", "Ograve", "Omega", "Omicron",
		"Oslash", "Otilde", "Ouml", "Phi", "Pi", "Prime", "Psi", "Rho", "Scaron", "Sigma", "THORN", "Tau", "Theta", "Uacute", "Ucirc", "Ugrave", "Upsilon", "Uuml", "Xi", "Yacute", "Yuml", "Zeta",
		"aacute", "acirc", "acute", "aelig", "agrave", "alefsym", "alpha", "amp", "and", "ang", "aring", "asymp", "atilde", "auml", "bdquo", "beta", "brvbar", "bull", "cap", "ccedil", "cedil",
		"cent", "chi", "circ", "clubs", "cong", "copy", "crarr", "cup", "curren", "dArr", "dagger", "darr", "deg", "delta", "diams", "divide", "eacute", "ecirc", "egrave", "empty", "emsp", "ensp",
		"epsilon", "equiv", "eta", "eth", "euml", "euro", "exist", "fnof", "forall", "frac12", "frac14", "frac34", "frasl", "gamma", "ge", "gt", "hArr", "harr", "hearts", "hellip", "iacute", "icirc",
		"iexcl", "igrave", "image", "infin", "int", "iota", "iquest", "isin", "iuml", "kappa", "lArr", "lambda", "lang", "laquo", "larr", "lceil", "ldquo", "le", "lfloor", "lowast", "loz", "lrm",
		"lsaquo", "lsquo", "lt", "macr", "mdash", "micro", "middot", "minus", "mu", "nabla", "nbsp", "ndash", "ne", "ni", "not", "notin", "nsub", "ntilde", "nu", "oacute", "ocirc", "oelig", "ograve",
		"oline", "omega", "omicron", "oplus", "or", "ordf", "ordm", "oslash", "otilde", "otimes", "ouml", "para", "part", "permil", "perp", "phi", "pi", "piv", "plusmn", "pound", "prime", "prod",
		"prop", "psi", "quot", "rArr", "radic", "rang", "raquo", "rarr", "rceil", "rdquo", "real", "reg", "rfloor", "rho", "rlm", "rsaquo", "rsquo", "sbquo", "scaron", "sdot", "sect", "shy", "sigma",
		"sigmaf", "sim", "spades", "sub", "sube", "sum", "sup", "sup1", "sup2", "sup3", "supe", "szlig", "tau", "there4", "theta", "thetasym", "thinsp", "thorn", "tilde", "times", "trade", "uArr",
		"uacute", "uarr", "ucirc", "ugrave", "uml", "upsih", "upsilon", "uuml", "weierp", "xi", "yacute", "yen", "yuml", "zeta", "zwj", "zwnj"};


	static public final int[]		m_nameCodeTbl	= {198, 193, 194, 192, 913, 197, 195, 196, 914, 199, 935, 8225, 916, 208, 201, 202, 200, 917, 919, 203, 915, 205, 206, 204, 921, 207, 922, 923,
		924, 209, 925, 338, 211, 212, 210, 937, 927, 216, 213, 214, 934, 928, 8243, 936, 929, 352, 931, 222, 932, 920, 218, 219, 217, 933, 220, 926, 221, 376, 918, 225, 226, 180, 230, 224, 8501, 945,
		38, 8743, 8736, 229, 8776, 227, 228, 8222, 946, 166, 8226, 8745, 231, 184, 162, 967, 710, 9827, 8773, 169, 8629, 8746, 164, 8659, 8224, 8595, 176, 948, 9830, 247, 233, 234, 232, 8709, 8195,
		8194, 949, 8801, 951, 240, 235, 8364, 8707, 402, 8704, 189, 188, 190, 8260, 947, 8805, 62, 8660, 8596, 9829, 8230, 237, 238, 161, 236, 8465, 8734, 8747, 953, 191, 8712, 239, 954, 8656, 955,
		9001, 171, 8592, 8968, 8220, 8804, 8970, 8727, 9674, 8206, 8249, 8216, 60, 175, 8212, 181, 183, 8722, 956, 8711, 160, 8211, 8800, 8715, 172, 8713, 8836, 241, 957, 243, 244, 339, 242, 8254,
		969, 959, 8853, 8744, 170, 186, 248, 245, 8855, 246, 182, 8706, 8240, 8869, 966, 960, 982, 177, 163, 8242, 8719, 8733, 968, 34, 8658, 8730, 9002, 187, 8594, 8969, 8221, 8476, 174, 8971, 961,
		8207, 8250, 8217, 8218, 353, 8901, 167, 173, 963, 962, 8764, 9824, 8834, 8838, 8721, 8835, 185, 178, 179, 8839, 223, 964, 8756, 952, 977, 8201, 254, 732, 215, 8482, 8657, 250, 8593, 251, 249,
		168, 978, 965, 252, 8472, 958, 253, 165, 255, 950, 8205, 8204};


	static public final String[]	m_codeStrTbl	= {"quot", "amp", "lt", "gt", "nbsp", "iexcl", "cent", "pound", "curren", "yen", "brvbar", "sect", "uml", "copy", "ordf", "laquo", "not", "shy",
		"reg", "macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro", "para", "middot", "cedil", "sup1", "ordm", "raquo", "frac14", "frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc",
		"Atilde", "Auml", "Aring", "AElig", "Ccedil", "Egrave", "Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc", "Iuml", "ETH", "Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde", "Ouml",
		"times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml", "Yacute", "THORN", "szlig", "agrave", "aacute", "acirc", "atilde", "auml", "aring", "aelig", "ccedil", "egrave", "eacute", "ecirc",
		"euml", "igrave", "iacute", "icirc", "iuml", "eth", "ntilde", "ograve", "oacute", "ocirc", "otilde", "ouml", "divide", "oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn",
		"yuml", "OElig", "oelig", "Scaron", "scaron", "Yuml", "fnof", "circ", "tilde", "Alpha", "Beta", "Gamma", "Delta", "Epsilon", "Zeta", "Eta", "Theta", "Iota", "Kappa", "Lambda", "Mu", "Nu",
		"Xi", "Omicron", "Pi", "Rho", "Sigma", "Tau", "Upsilon", "Phi", "Chi", "Psi", "Omega", "alpha", "beta", "gamma", "delta", "epsilon", "zeta", "eta", "theta", "iota", "kappa", "lambda", "mu",
		"nu", "xi", "omicron", "pi", "rho", "sigmaf", "sigma", "tau", "upsilon", "phi", "chi", "psi", "omega", "thetasym", "upsih", "piv", "ensp", "emsp", "thinsp", "zwnj", "zwj", "lrm", "rlm",
		"ndash", "mdash", "lsquo", "rsquo", "sbquo", "ldquo", "rdquo", "bdquo", "dagger", "Dagger", "bull", "hellip", "permil", "prime", "Prime", "lsaquo", "rsaquo", "oline", "frasl", "euro",
		"image", "weierp", "real", "trade", "alefsym", "larr", "uarr", "rarr", "darr", "harr", "crarr", "lArr", "uArr", "rArr", "dArr", "hArr", "forall", "part", "exist", "empty", "nabla", "isin",
		"notin", "ni", "prod", "sum", "minus", "lowast", "radic", "prop", "infin", "ang", "and", "or", "cap", "cup", "int", "there4", "sim", "cong", "asymp", "ne", "equiv", "le", "ge", "sub", "sup",
		"nsub", "sube", "supe", "oplus", "otimes", "perp", "sdot", "lceil", "rceil", "lfloor", "rfloor", "lang", "rang", "loz", "spades", "clubs", "hearts", "diams"};


	static public final String[]	m_codeDescTbl	= {"quotation mark = APL quote", "ampersand", "less-than sign", "greater-than sign", "no-break space = non-breaking space",
		"inverted exclamation mark", "cent sign", "pound sign", "currency sign", "yen sign = yuan sign", "broken bar = broken vertical bar", "section sign", "diaeresis = spacing diaeresis",
		"copyright sign", "feminine ordinal indicator", "left-pointing double angle quotation mark = left pointing guillemet", "not sign", "soft hyphen = discretionary hyphen",
		"registered sign = registered trade mark sign", "macron = spacing macron = overline = APL overbar", "degree sign", "plus-minus sign = plus-or-minus sign",
		"superscript two = superscript digit two = squared", "superscript three = superscript digit three = cubed", "acute accent = spacing acute", "micro sign", "pilcrow sign = paragraph sign",
		"middle dot = Georgian comma = Greek middle dot", "cedilla = spacing cedilla", "superscript one = superscript digit one", "masculine ordinal indicator",
		"right-pointing double angle quotation mark = right pointing guillemet", "vulgar fraction one quarter = fraction one quarter", "vulgar fraction one half = fraction one half",
		"vulgar fraction three quarters = fraction three quarters", "inverted question mark = turned question mark", "latin capital letter A with grave = latin capital letter A grave",
		"latin capital letter A with acute", "latin capital letter A with circumflex", "latin capital letter A with tilde", "latin capital letter A with diaeresis",
		"latin capital letter A with ring above = latin capital letter A ring", "latin capital letter AE = latin capital ligature AE", "latin capital letter C with cedilla",
		"latin capital letter E with grave", "latin capital letter E with acute", "latin capital letter E with circumflex", "latin capital letter E with diaeresis",
		"latin capital letter I with grave", "latin capital letter I with acute", "latin capital letter I with circumflex", "latin capital letter I with diaeresis", "latin capital letter ETH",
		"latin capital letter N with tilde", "latin capital letter O with grave", "latin capital letter O with acute", "latin capital letter O with circumflex", "latin capital letter O with tilde",
		"latin capital letter O with diaeresis", "multiplication sign", "latin capital letter O with stroke = latin capital letter O slash", "latin capital letter U with grave",
		"latin capital letter U with acute", "latin capital letter U with circumflex", "latin capital letter U with diaeresis", "latin capital letter Y with acute", "latin capital letter THORN",
		"latin small letter sharp s = ess-zed", "latin small letter a with grave = latin small letter a grave", "latin small letter a with acute", "latin small letter a with circumflex",
		"latin small letter a with tilde", "latin small letter a with diaeresis", "latin small letter a with ring above = latin small letter a ring",
		"latin small letter ae = latin small ligature ae", "latin small letter c with cedilla", "latin small letter e with grave", "latin small letter e with acute",
		"latin small letter e with circumflex", "latin small letter e with diaeresis", "latin small letter i with grave", "latin small letter i with acute", "latin small letter i with circumflex",
		"latin small letter i with diaeresis", "latin small letter eth", "latin small letter n with tilde", "latin small letter o with grave", "latin small letter o with acute",
		"latin small letter o with circumflex", "latin small letter o with tilde", "latin small letter o with diaeresis", "division sign",
		"latin small letter o with stroke, = latin small letter o slash", "latin small letter u with grave", "latin small letter u with acute", "latin small letter u with circumflex",
		"latin small letter u with diaeresis", "latin small letter y with acute", "latin small letter thorn", "latin small letter y with diaeresis", "latin capital ligature OE",
		"latin small ligature oe", "latin capital letter S with caron", "latin small letter s with caron", "latin capital letter Y with diaeresis", "latin small f with hook = function = florin",
		"modifier letter circumflex accent", "small tilde", "greek capital letter alpha", "greek capital letter beta", "greek capital letter gamma", "greek capital letter delta",
		"greek capital letter epsilon", "greek capital letter zeta", "greek capital letter eta", "greek capital letter theta", "greek capital letter iota", "greek capital letter kappa",
		"greek capital letter lambda", "greek capital letter mu", "greek capital letter nu", "greek capital letter xi", "greek capital letter omicron", "greek capital letter pi",
		"greek capital letter rho", "greek capital letter sigma", "greek capital letter tau", "greek capital letter upsilon", "greek capital letter phi", "greek capital letter chi",
		"greek capital letter psi", "greek capital letter omega", "greek small letter alpha", "greek small letter beta", "greek small letter gamma", "greek small letter delta",
		"greek small letter epsilon", "greek small letter zeta", "greek small letter eta", "greek small letter theta", "greek small letter iota", "greek small letter kappa",
		"greek small letter lambda", "greek small letter mu", "greek small letter nu", "greek small letter xi", "greek small letter omicron", "greek small letter pi", "greek small letter rho",
		"greek small letter final sigma", "greek small letter sigma", "greek small letter tau", "greek small letter upsilon", "greek small letter phi", "greek small letter chi",
		"greek small letter psi", "greek small letter omega", "greek small letter theta symbol", "greek upsilon with hook symbol", "greek pi symbol", "en space", "em space", "thin space",
		"zero width non-joiner", "zero width joiner", "left-to-right mark", "right-to-left mark", "en dash", "em dash", "left single quotation mark", "right single quotation mark",
		"single low-9 quotation mark", "left double quotation mark", "right double quotation mark", "double low-9 quotation mark", "dagger", "double dagger", "bullet = black small circle",
		"horizontal ellipsis = three dot leader", "per mille sign", "prime = minutes = feet", "double prime = seconds = inches", "single left-pointing angle quotation mark",
		"single right-pointing angle quotation mark", "overline = spacing overscore", "fraction slash", "euro sign", "blackletter capital I = imaginary part",
		"script capital P = power set = Weierstrass p", "blackletter capital R = real part symbol", "trade mark sign", "alef symbol = first transfinite cardinal", "leftwards arrow", "upwards arrow",
		"rightwards arrow", "downwards arrow", "left right arrow", "downwards arrow with corner leftwards = carriage return", "leftwards double arrow", "upwards double arrow",
		"rightwards double arrow", "downwards double arrow", "left right double arrow", "for all", "partial differential", "there exists", "empty set = null set = diameter",
		"nabla = backward difference", "element of", "not an element of", "contains as member", "n-ary product = product sign", "n-ary sumation", "minus sign", "asterisk operator",
		"square root = radical sign", "proportional to", "infinity", "angle", "logical and = wedge", "logical or = vee", "intersection = cap", "union = cup", "integral", "therefore",
		"tilde operator = varies with = similar to", "approximately equal to", "almost equal to = asymptotic to", "not equal to", "identical to", "less-than or equal to", "greater-than or equal to",
		"subset of", "superset of", "not a subset of", "subset of or equal to", "superset of or equal to", "circled plus = direct sum", "circled times = vector product",
		"up tack = orthogonal to = perpendicular", "dot operator", "left ceiling = apl upstile", "right ceiling", "left floor = apl downstile", "right floor", "left-pointing angle bracket = bra",
		"right-pointing angle bracket = ket", "lozenge", "black spade suit", "black club suit = shamrock", "black heart suit = valentine", "black diamond suit"};


	static public final int[]		m_codeCodeTbl	= {34, 38, 60, 62, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184,
		185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222,
		223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 338, 339, 352, 353, 376,
		402, 710, 732, 913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 923, 924, 925, 926, 927, 928, 929, 931, 932, 933, 934, 935, 936, 937, 945, 946, 947, 948, 949, 950, 951, 952, 953, 954, 955,
		956, 957, 958, 959, 960, 961, 962, 963, 964, 965, 966, 967, 968, 969, 977, 978, 982, 8194, 8195, 8201, 8204, 8205, 8206, 8207, 8211, 8212, 8216, 8217, 8218, 8220, 8221, 8222, 8224, 8225,
		8226, 8230, 8240, 8242, 8243, 8249, 8250, 8254, 8260, 8364, 8465, 8472, 8476, 8482, 8501, 8592, 8593, 8594, 8595, 8596, 8629, 8656, 8657, 8658, 8659, 8660, 8704, 8706, 8707, 8709, 8711, 8712,
		8713, 8715, 8719, 8721, 8722, 8727, 8730, 8733, 8734, 8736, 8743, 8744, 8745, 8746, 8747, 8756, 8764, 8773, 8776, 8800, 8801, 8804, 8805, 8834, 8835, 8836, 8838, 8839, 8853, 8855, 8869, 8901,
		8968, 8969, 8970, 8971, 9001, 9002, 9674, 9824, 9827, 9829, 9830};

	static public int findCode(String name) {
		int rv;
		rv = name.compareTo("image");
		if(rv == 0)
			return 8465;
		else if(rv < 0) {
			rv = name.compareTo("agrave");
			if(rv == 0)
				return 224;
			else if(rv < 0) {
				rv = name.compareTo("OElig");
				if(rv == 0)
					return 338;
				else if(rv < 0) {
					rv = name.compareTo("Ecirc");
					if(rv == 0)
						return 202;
					else if(rv < 0) {
						rv = name.compareTo("Auml");
						if(rv == 0)
							return 196;
						else if(rv < 0) {
							rv = name.compareTo("Agrave");
							if(rv == 0)
								return 192;
							else if(rv < 0) {
								rv = name.compareTo("Aacute");
								if(rv == 0)
									return 193;
								else if(rv < 0) {
									if(name.equals("AElig"))
										return 198;
									else
										return -1;
								} else {
									if(name.equals("Acirc"))
										return 194;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("Aring");
								if(rv == 0)
									return 197;
								else if(rv < 0) {
									if(name.equals("Alpha"))
										return 913;
									else
										return -1;
								} else {
									if(name.equals("Atilde"))
										return 195;
									else
										return -1;
								}
							}
						} else {
							rv = name.compareTo("Dagger");
							if(rv == 0)
								return 8225;
							else if(rv < 0) {
								rv = name.compareTo("Ccedil");
								if(rv == 0)
									return 199;
								else if(rv < 0) {
									if(name.equals("Beta"))
										return 914;
									else
										return -1;
								} else {
									if(name.equals("Chi"))
										return 935;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("ETH");
								if(rv == 0)
									return 208;
								else if(rv < 0) {
									if(name.equals("Delta"))
										return 916;
									else
										return -1;
								} else {
									if(name.equals("Eacute"))
										return 201;
									else
										return -1;
								}
							}
						}
					} else {
						rv = name.compareTo("Igrave");
						if(rv == 0)
							return 204;
						else if(rv < 0) {
							rv = name.compareTo("Euml");
							if(rv == 0)
								return 203;
							else if(rv < 0) {
								rv = name.compareTo("Epsilon");
								if(rv == 0)
									return 917;
								else if(rv < 0) {
									if(name.equals("Egrave"))
										return 200;
									else
										return -1;
								} else {
									if(name.equals("Eta"))
										return 919;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("Iacute");
								if(rv == 0)
									return 205;
								else if(rv < 0) {
									if(name.equals("Gamma"))
										return 915;
									else
										return -1;
								} else {
									if(name.equals("Icirc"))
										return 206;
									else
										return -1;
								}
							}
						} else {
							rv = name.compareTo("Lambda");
							if(rv == 0)
								return 923;
							else if(rv < 0) {
								rv = name.compareTo("Iuml");
								if(rv == 0)
									return 207;
								else if(rv < 0) {
									if(name.equals("Iota"))
										return 921;
									else
										return -1;
								} else {
									if(name.equals("Kappa"))
										return 922;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("Ntilde");
								if(rv == 0)
									return 209;
								else if(rv < 0) {
									if(name.equals("Mu"))
										return 924;
									else
										return -1;
								} else {
									if(name.equals("Nu"))
										return 925;
									else
										return -1;
								}
							}
						}
					}
				} else {
					rv = name.compareTo("THORN");
					if(rv == 0)
						return 222;
					else if(rv < 0) {
						rv = name.compareTo("Ouml");
						if(rv == 0)
							return 214;
						else if(rv < 0) {
							rv = name.compareTo("Omega");
							if(rv == 0)
								return 937;
							else if(rv < 0) {
								rv = name.compareTo("Ocirc");
								if(rv == 0)
									return 212;
								else if(rv < 0) {
									if(name.equals("Oacute"))
										return 211;
									else
										return -1;
								} else {
									if(name.equals("Ograve"))
										return 210;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("Oslash");
								if(rv == 0)
									return 216;
								else if(rv < 0) {
									if(name.equals("Omicron"))
										return 927;
									else
										return -1;
								} else {
									if(name.equals("Otilde"))
										return 213;
									else
										return -1;
								}
							}
						} else {
							rv = name.compareTo("Psi");
							if(rv == 0)
								return 936;
							else if(rv < 0) {
								rv = name.compareTo("Pi");
								if(rv == 0)
									return 928;
								else if(rv < 0) {
									if(name.equals("Phi"))
										return 934;
									else
										return -1;
								} else {
									if(name.equals("Prime"))
										return 8243;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("Scaron");
								if(rv == 0)
									return 352;
								else if(rv < 0) {
									if(name.equals("Rho"))
										return 929;
									else
										return -1;
								} else {
									if(name.equals("Sigma"))
										return 931;
									else
										return -1;
								}
							}
						}
					} else {
						rv = name.compareTo("Xi");
						if(rv == 0)
							return 926;
						else if(rv < 0) {
							rv = name.compareTo("Ucirc");
							if(rv == 0)
								return 219;
							else if(rv < 0) {
								rv = name.compareTo("Theta");
								if(rv == 0)
									return 920;
								else if(rv < 0) {
									if(name.equals("Tau"))
										return 932;
									else
										return -1;
								} else {
									if(name.equals("Uacute"))
										return 218;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("Upsilon");
								if(rv == 0)
									return 933;
								else if(rv < 0) {
									if(name.equals("Ugrave"))
										return 217;
									else
										return -1;
								} else {
									if(name.equals("Uuml"))
										return 220;
									else
										return -1;
								}
							}
						} else {
							rv = name.compareTo("aacute");
							if(rv == 0)
								return 225;
							else if(rv < 0) {
								rv = name.compareTo("Yuml");
								if(rv == 0)
									return 376;
								else if(rv < 0) {
									if(name.equals("Yacute"))
										return 221;
									else
										return -1;
								} else {
									if(name.equals("Zeta"))
										return 918;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("acute");
								if(rv == 0)
									return 180;
								else if(rv < 0) {
									if(name.equals("acirc"))
										return 226;
									else
										return -1;
								} else {
									if(name.equals("aelig"))
										return 230;
									else
										return -1;
								}
							}
						}
					}
				}
			} else {
				rv = name.compareTo("divide");
				if(rv == 0)
					return 247;
				else if(rv < 0) {
					rv = name.compareTo("cedil");
					if(rv == 0)
						return 184;
					else if(rv < 0) {
						rv = name.compareTo("atilde");
						if(rv == 0)
							return 227;
						else if(rv < 0) {
							rv = name.compareTo("and");
							if(rv == 0)
								return 8743;
							else if(rv < 0) {
								rv = name.compareTo("alpha");
								if(rv == 0)
									return 945;
								else if(rv < 0) {
									if(name.equals("alefsym"))
										return 8501;
									else
										return -1;
								} else {
									if(name.equals("amp"))
										return 38;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("aring");
								if(rv == 0)
									return 229;
								else if(rv < 0) {
									if(name.equals("ang"))
										return 8736;
									else
										return -1;
								} else {
									if(name.equals("asymp"))
										return 8776;
									else
										return -1;
								}
							}
						} else {
							rv = name.compareTo("brvbar");
							if(rv == 0)
								return 166;
							else if(rv < 0) {
								rv = name.compareTo("bdquo");
								if(rv == 0)
									return 8222;
								else if(rv < 0) {
									if(name.equals("auml"))
										return 228;
									else
										return -1;
								} else {
									if(name.equals("beta"))
										return 946;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("cap");
								if(rv == 0)
									return 8745;
								else if(rv < 0) {
									if(name.equals("bull"))
										return 8226;
									else
										return -1;
								} else {
									if(name.equals("ccedil"))
										return 231;
									else
										return -1;
								}
							}
						}
					} else {
						rv = name.compareTo("cup");
						if(rv == 0)
							return 8746;
						else if(rv < 0) {
							rv = name.compareTo("clubs");
							if(rv == 0)
								return 9827;
							else if(rv < 0) {
								rv = name.compareTo("chi");
								if(rv == 0)
									return 967;
								else if(rv < 0) {
									if(name.equals("cent"))
										return 162;
									else
										return -1;
								} else {
									if(name.equals("circ"))
										return 710;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("copy");
								if(rv == 0)
									return 169;
								else if(rv < 0) {
									if(name.equals("cong"))
										return 8773;
									else
										return -1;
								} else {
									if(name.equals("crarr"))
										return 8629;
									else
										return -1;
								}
							}
						} else {
							rv = name.compareTo("darr");
							if(rv == 0)
								return 8595;
							else if(rv < 0) {
								rv = name.compareTo("dArr");
								if(rv == 0)
									return 8659;
								else if(rv < 0) {
									if(name.equals("curren"))
										return 164;
									else
										return -1;
								} else {
									if(name.equals("dagger"))
										return 8224;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("delta");
								if(rv == 0)
									return 948;
								else if(rv < 0) {
									if(name.equals("deg"))
										return 176;
									else
										return -1;
								} else {
									if(name.equals("diams"))
										return 9830;
									else
										return -1;
								}
							}
						}
					}
				} else {
					rv = name.compareTo("frac12");
					if(rv == 0)
						return 189;
					else if(rv < 0) {
						rv = name.compareTo("equiv");
						if(rv == 0)
							return 8801;
						else if(rv < 0) {
							rv = name.compareTo("empty");
							if(rv == 0)
								return 8709;
							else if(rv < 0) {
								rv = name.compareTo("ecirc");
								if(rv == 0)
									return 234;
								else if(rv < 0) {
									if(name.equals("eacute"))
										return 233;
									else
										return -1;
								} else {
									if(name.equals("egrave"))
										return 232;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("ensp");
								if(rv == 0)
									return 8194;
								else if(rv < 0) {
									if(name.equals("emsp"))
										return 8195;
									else
										return -1;
								} else {
									if(name.equals("epsilon"))
										return 949;
									else
										return -1;
								}
							}
						} else {
							rv = name.compareTo("euro");
							if(rv == 0)
								return 8364;
							else if(rv < 0) {
								rv = name.compareTo("eth");
								if(rv == 0)
									return 240;
								else if(rv < 0) {
									if(name.equals("eta"))
										return 951;
									else
										return -1;
								} else {
									if(name.equals("euml"))
										return 235;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("fnof");
								if(rv == 0)
									return 402;
								else if(rv < 0) {
									if(name.equals("exist"))
										return 8707;
									else
										return -1;
								} else {
									if(name.equals("forall"))
										return 8704;
									else
										return -1;
								}
							}
						}
					} else {
						rv = name.compareTo("harr");
						if(rv == 0)
							return 8596;
						else if(rv < 0) {
							rv = name.compareTo("gamma");
							if(rv == 0)
								return 947;
							else if(rv < 0) {
								rv = name.compareTo("frac34");
								if(rv == 0)
									return 190;
								else if(rv < 0) {
									if(name.equals("frac14"))
										return 188;
									else
										return -1;
								} else {
									if(name.equals("frasl"))
										return 8260;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("gt");
								if(rv == 0)
									return 62;
								else if(rv < 0) {
									if(name.equals("ge"))
										return 8805;
									else
										return -1;
								} else {
									if(name.equals("hArr"))
										return 8660;
									else
										return -1;
								}
							}
						} else {
							rv = name.compareTo("icirc");
							if(rv == 0)
								return 238;
							else if(rv < 0) {
								rv = name.compareTo("hellip");
								if(rv == 0)
									return 8230;
								else if(rv < 0) {
									if(name.equals("hearts"))
										return 9829;
									else
										return -1;
								} else {
									if(name.equals("iacute"))
										return 237;
									else
										return -1;
								}
							} else {
								if(name.equals("iexcl"))
									return 161;
								if(name.equals("igrave"))
									return 236;
								return -1;
							}
						}
					}
				}
			}
		} else {
			rv = name.compareTo("prime");
			if(rv == 0)
				return 8242;
			else if(rv < 0) {
				rv = name.compareTo("ne");
				if(rv == 0)
					return 8800;
				else if(rv < 0) {
					rv = name.compareTo("lfloor");
					if(rv == 0)
						return 8970;
					else if(rv < 0) {
						rv = name.compareTo("lArr");
						if(rv == 0)
							return 8656;
						else if(rv < 0) {
							rv = name.compareTo("iquest");
							if(rv == 0)
								return 191;
							else if(rv < 0) {
								rv = name.compareTo("int");
								if(rv == 0)
									return 8747;
								else if(rv < 0) {
									if(name.equals("infin"))
										return 8734;
									else
										return -1;
								} else {
									if(name.equals("iota"))
										return 953;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("iuml");
								if(rv == 0)
									return 239;
								else if(rv < 0) {
									if(name.equals("isin"))
										return 8712;
									else
										return -1;
								} else {
									if(name.equals("kappa"))
										return 954;
									else
										return -1;
								}
							}
						} else {
							rv = name.compareTo("larr");
							if(rv == 0)
								return 8592;
							else if(rv < 0) {
								rv = name.compareTo("lang");
								if(rv == 0)
									return 9001;
								else if(rv < 0) {
									if(name.equals("lambda"))
										return 955;
									else
										return -1;
								} else {
									if(name.equals("laquo"))
										return 171;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("ldquo");
								if(rv == 0)
									return 8220;
								else if(rv < 0) {
									if(name.equals("lceil"))
										return 8968;
									else
										return -1;
								} else {
									if(name.equals("le"))
										return 8804;
									else
										return -1;
								}
							}
						}
					} else {
						rv = name.compareTo("mdash");
						if(rv == 0)
							return 8212;
						else if(rv < 0) {
							rv = name.compareTo("lsaquo");
							if(rv == 0)
								return 8249;
							else if(rv < 0) {
								rv = name.compareTo("loz");
								if(rv == 0)
									return 9674;
								else if(rv < 0) {
									if(name.equals("lowast"))
										return 8727;
									else
										return -1;
								} else {
									if(name.equals("lrm"))
										return 8206;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("lt");
								if(rv == 0)
									return 60;
								else if(rv < 0) {
									if(name.equals("lsquo"))
										return 8216;
									else
										return -1;
								} else {
									if(name.equals("macr"))
										return 175;
									else
										return -1;
								}
							}
						} else {
							rv = name.compareTo("mu");
							if(rv == 0)
								return 956;
							else if(rv < 0) {
								rv = name.compareTo("middot");
								if(rv == 0)
									return 183;
								else if(rv < 0) {
									if(name.equals("micro"))
										return 181;
									else
										return -1;
								} else {
									if(name.equals("minus"))
										return 8722;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("nbsp");
								if(rv == 0)
									return 160;
								else if(rv < 0) {
									if(name.equals("nabla"))
										return 8711;
									else
										return -1;
								} else {
									if(name.equals("ndash"))
										return 8211;
									else
										return -1;
								}
							}
						}
					}
				} else {
					rv = name.compareTo("ordf");
					if(rv == 0)
						return 170;
					else if(rv < 0) {
						rv = name.compareTo("ocirc");
						if(rv == 0)
							return 244;
						else if(rv < 0) {
							rv = name.compareTo("nsub");
							if(rv == 0)
								return 8836;
							else if(rv < 0) {
								rv = name.compareTo("not");
								if(rv == 0)
									return 172;
								else if(rv < 0) {
									if(name.equals("ni"))
										return 8715;
									else
										return -1;
								} else {
									if(name.equals("notin"))
										return 8713;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("nu");
								if(rv == 0)
									return 957;
								else if(rv < 0) {
									if(name.equals("ntilde"))
										return 241;
									else
										return -1;
								} else {
									if(name.equals("oacute"))
										return 243;
									else
										return -1;
								}
							}
						} else {
							rv = name.compareTo("omega");
							if(rv == 0)
								return 969;
							else if(rv < 0) {
								rv = name.compareTo("ograve");
								if(rv == 0)
									return 242;
								else if(rv < 0) {
									if(name.equals("oelig"))
										return 339;
									else
										return -1;
								} else {
									if(name.equals("oline"))
										return 8254;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("oplus");
								if(rv == 0)
									return 8853;
								else if(rv < 0) {
									if(name.equals("omicron"))
										return 959;
									else
										return -1;
								} else {
									if(name.equals("or"))
										return 8744;
									else
										return -1;
								}
							}
						}
					} else {
						rv = name.compareTo("permil");
						if(rv == 0)
							return 8240;
						else if(rv < 0) {
							rv = name.compareTo("otimes");
							if(rv == 0)
								return 8855;
							else if(rv < 0) {
								rv = name.compareTo("oslash");
								if(rv == 0)
									return 248;
								else if(rv < 0) {
									if(name.equals("ordm"))
										return 186;
									else
										return -1;
								} else {
									if(name.equals("otilde"))
										return 245;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("para");
								if(rv == 0)
									return 182;
								else if(rv < 0) {
									if(name.equals("ouml"))
										return 246;
									else
										return -1;
								} else {
									if(name.equals("part"))
										return 8706;
									else
										return -1;
								}
							}
						} else {
							rv = name.compareTo("piv");
							if(rv == 0)
								return 982;
							else if(rv < 0) {
								rv = name.compareTo("phi");
								if(rv == 0)
									return 966;
								else if(rv < 0) {
									if(name.equals("perp"))
										return 8869;
									else
										return -1;
								} else {
									if(name.equals("pi"))
										return 960;
									else
										return -1;
								}
							} else {
								if(name.equals("plusmn"))
									return 177;
								if(name.equals("pound"))
									return 163;
								return -1;
							}
						}
					}
				}
			} else {
				rv = name.compareTo("sup1");
				if(rv == 0)
					return 185;
				else if(rv < 0) {
					rv = name.compareTo("rlm");
					if(rv == 0)
						return 8207;
					else if(rv < 0) {
						rv = name.compareTo("raquo");
						if(rv == 0)
							return 187;
						else if(rv < 0) {
							rv = name.compareTo("quot");
							if(rv == 0)
								return 34;
							else if(rv < 0) {
								rv = name.compareTo("prop");
								if(rv == 0)
									return 8733;
								else if(rv < 0) {
									if(name.equals("prod"))
										return 8719;
									else
										return -1;
								} else {
									if(name.equals("psi"))
										return 968;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("radic");
								if(rv == 0)
									return 8730;
								else if(rv < 0) {
									if(name.equals("rArr"))
										return 8658;
									else
										return -1;
								} else {
									if(name.equals("rang"))
										return 9002;
									else
										return -1;
								}
							}
						} else {
							rv = name.compareTo("real");
							if(rv == 0)
								return 8476;
							else if(rv < 0) {
								rv = name.compareTo("rceil");
								if(rv == 0)
									return 8969;
								else if(rv < 0) {
									if(name.equals("rarr"))
										return 8594;
									else
										return -1;
								} else {
									if(name.equals("rdquo"))
										return 8221;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("rfloor");
								if(rv == 0)
									return 8971;
								else if(rv < 0) {
									if(name.equals("reg"))
										return 174;
									else
										return -1;
								} else {
									if(name.equals("rho"))
										return 961;
									else
										return -1;
								}
							}
						}
					} else {
						rv = name.compareTo("sigma");
						if(rv == 0)
							return 963;
						else if(rv < 0) {
							rv = name.compareTo("scaron");
							if(rv == 0)
								return 353;
							else if(rv < 0) {
								rv = name.compareTo("rsquo");
								if(rv == 0)
									return 8217;
								else if(rv < 0) {
									if(name.equals("rsaquo"))
										return 8250;
									else
										return -1;
								} else {
									if(name.equals("sbquo"))
										return 8218;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("sect");
								if(rv == 0)
									return 167;
								else if(rv < 0) {
									if(name.equals("sdot"))
										return 8901;
									else
										return -1;
								} else {
									if(name.equals("shy"))
										return 173;
									else
										return -1;
								}
							}
						} else {
							rv = name.compareTo("sub");
							if(rv == 0)
								return 8834;
							else if(rv < 0) {
								rv = name.compareTo("sim");
								if(rv == 0)
									return 8764;
								else if(rv < 0) {
									if(name.equals("sigmaf"))
										return 962;
									else
										return -1;
								} else {
									if(name.equals("spades"))
										return 9824;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("sum");
								if(rv == 0)
									return 8721;
								else if(rv < 0) {
									if(name.equals("sube"))
										return 8838;
									else
										return -1;
								} else {
									if(name.equals("sup"))
										return 8835;
									else
										return -1;
								}
							}
						}
					}
				} else {
					rv = name.compareTo("uarr");
					if(rv == 0)
						return 8593;
					else if(rv < 0) {
						rv = name.compareTo("thetasym");
						if(rv == 0)
							return 977;
						else if(rv < 0) {
							rv = name.compareTo("szlig");
							if(rv == 0)
								return 223;
							else if(rv < 0) {
								rv = name.compareTo("sup3");
								if(rv == 0)
									return 179;
								else if(rv < 0) {
									if(name.equals("sup2"))
										return 178;
									else
										return -1;
								} else {
									if(name.equals("supe"))
										return 8839;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("there4");
								if(rv == 0)
									return 8756;
								else if(rv < 0) {
									if(name.equals("tau"))
										return 964;
									else
										return -1;
								} else {
									if(name.equals("theta"))
										return 952;
									else
										return -1;
								}
							}
						} else {
							rv = name.compareTo("times");
							if(rv == 0)
								return 215;
							else if(rv < 0) {
								rv = name.compareTo("thorn");
								if(rv == 0)
									return 254;
								else if(rv < 0) {
									if(name.equals("thinsp"))
										return 8201;
									else
										return -1;
								} else {
									if(name.equals("tilde"))
										return 732;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("uArr");
								if(rv == 0)
									return 8657;
								else if(rv < 0) {
									if(name.equals("trade"))
										return 8482;
									else
										return -1;
								} else {
									if(name.equals("uacute"))
										return 250;
									else
										return -1;
								}
							}
						}
					} else {
						rv = name.compareTo("xi");
						if(rv == 0)
							return 958;
						else if(rv < 0) {
							rv = name.compareTo("upsih");
							if(rv == 0)
								return 978;
							else if(rv < 0) {
								rv = name.compareTo("ugrave");
								if(rv == 0)
									return 249;
								else if(rv < 0) {
									if(name.equals("ucirc"))
										return 251;
									else
										return -1;
								} else {
									if(name.equals("uml"))
										return 168;
									else
										return -1;
								}
							} else {
								rv = name.compareTo("uuml");
								if(rv == 0)
									return 252;
								else if(rv < 0) {
									if(name.equals("upsilon"))
										return 965;
									else
										return -1;
								} else {
									if(name.equals("weierp"))
										return 8472;
									else
										return -1;
								}
							}
						} else {
							rv = name.compareTo("zeta");
							if(rv == 0)
								return 950;
							else if(rv < 0) {
								rv = name.compareTo("yen");
								if(rv == 0)
									return 165;
								else if(rv < 0) {
									if(name.equals("yacute"))
										return 253;
									else
										return -1;
								} else {
									if(name.equals("yuml"))
										return 255;
									else
										return -1;
								}
							} else {
								if(name.equals("zwj"))
									return 8205;
								if(name.equals("zwnj"))
									return 8204;
								return -1;
							}
						}
					}
				}
			}
		}
	}


	static public String findName(int code) {
		if(code == 932)
			return "Tau";
		else if(code < 932) {
			if(code == 219)
				return "Ucirc";
			else if(code < 219) {
				if(code == 187)
					return "raquo";
				else if(code < 187) {
					if(code == 171)
						return "laquo";
					else if(code < 171) {
						if(code == 163)
							return "pound";
						else if(code < 163) {
							if(code == 62)
								return "gt";
							else if(code < 62) {
								if(code == 38)
									return "amp";
								else if(code < 38) {
									if(code == 34)
										return "quot";
									else
										return null;
								} else {
									if(code == 60)
										return "lt";
									else
										return null;
								}
							} else {
								if(code == 161)
									return "iexcl";
								else if(code < 161) {
									if(code == 160)
										return "nbsp";
									else
										return null;
								} else {
									if(code == 162)
										return "cent";
									else
										return null;
								}
							}
						} else {
							if(code == 167)
								return "sect";
							else if(code < 167) {
								if(code == 165)
									return "yen";
								else if(code < 165) {
									if(code == 164)
										return "curren";
									else
										return null;
								} else {
									if(code == 166)
										return "brvbar";
									else
										return null;
								}
							} else {
								if(code == 169)
									return "copy";
								else if(code < 169) {
									if(code == 168)
										return "uml";
									else
										return null;
								} else {
									if(code == 170)
										return "ordf";
									else
										return null;
								}
							}
						}
					} else {
						if(code == 179)
							return "sup3";
						else if(code < 179) {
							if(code == 175)
								return "macr";
							else if(code < 175) {
								if(code == 173)
									return "shy";
								else if(code < 173) {
									if(code == 172)
										return "not";
									else
										return null;
								} else {
									if(code == 174)
										return "reg";
									else
										return null;
								}
							} else {
								if(code == 177)
									return "plusmn";
								else if(code < 177) {
									if(code == 176)
										return "deg";
									else
										return null;
								} else {
									if(code == 178)
										return "sup2";
									else
										return null;
								}
							}
						} else {
							if(code == 183)
								return "middot";
							else if(code < 183) {
								if(code == 181)
									return "micro";
								else if(code < 181) {
									if(code == 180)
										return "acute";
									else
										return null;
								} else {
									if(code == 182)
										return "para";
									else
										return null;
								}
							} else {
								if(code == 185)
									return "sup1";
								else if(code < 185) {
									if(code == 184)
										return "cedil";
									else
										return null;
								} else {
									if(code == 186)
										return "ordm";
									else
										return null;
								}
							}
						}
					}
				} else {
					if(code == 203)
						return "Euml";
					else if(code < 203) {
						if(code == 195)
							return "Atilde";
						else if(code < 195) {
							if(code == 191)
								return "iquest";
							else if(code < 191) {
								if(code == 189)
									return "frac12";
								else if(code < 189) {
									if(code == 188)
										return "frac14";
									else
										return null;
								} else {
									if(code == 190)
										return "frac34";
									else
										return null;
								}
							} else {
								if(code == 193)
									return "Aacute";
								else if(code < 193) {
									if(code == 192)
										return "Agrave";
									else
										return null;
								} else {
									if(code == 194)
										return "Acirc";
									else
										return null;
								}
							}
						} else {
							if(code == 199)
								return "Ccedil";
							else if(code < 199) {
								if(code == 197)
									return "Aring";
								else if(code < 197) {
									if(code == 196)
										return "Auml";
									else
										return null;
								} else {
									if(code == 198)
										return "AElig";
									else
										return null;
								}
							} else {
								if(code == 201)
									return "Eacute";
								else if(code < 201) {
									if(code == 200)
										return "Egrave";
									else
										return null;
								} else {
									if(code == 202)
										return "Ecirc";
									else
										return null;
								}
							}
						}
					} else {
						if(code == 211)
							return "Oacute";
						else if(code < 211) {
							if(code == 207)
								return "Iuml";
							else if(code < 207) {
								if(code == 205)
									return "Iacute";
								else if(code < 205) {
									if(code == 204)
										return "Igrave";
									else
										return null;
								} else {
									if(code == 206)
										return "Icirc";
									else
										return null;
								}
							} else {
								if(code == 209)
									return "Ntilde";
								else if(code < 209) {
									if(code == 208)
										return "ETH";
									else
										return null;
								} else {
									if(code == 210)
										return "Ograve";
									else
										return null;
								}
							}
						} else {
							if(code == 215)
								return "times";
							else if(code < 215) {
								if(code == 213)
									return "Otilde";
								else if(code < 213) {
									if(code == 212)
										return "Ocirc";
									else
										return null;
								} else {
									if(code == 214)
										return "Ouml";
									else
										return null;
								}
							} else {
								if(code == 217)
									return "Ugrave";
								else if(code < 217) {
									if(code == 216)
										return "Oslash";
									else
										return null;
								} else {
									if(code == 218)
										return "Uacute";
									else
										return null;
								}
							}
						}
					}
				}
			} else {
				if(code == 251)
					return "ucirc";
				else if(code < 251) {
					if(code == 235)
						return "euml";
					else if(code < 235) {
						if(code == 227)
							return "atilde";
						else if(code < 227) {
							if(code == 223)
								return "szlig";
							else if(code < 223) {
								if(code == 221)
									return "Yacute";
								else if(code < 221) {
									if(code == 220)
										return "Uuml";
									else
										return null;
								} else {
									if(code == 222)
										return "THORN";
									else
										return null;
								}
							} else {
								if(code == 225)
									return "aacute";
								else if(code < 225) {
									if(code == 224)
										return "agrave";
									else
										return null;
								} else {
									if(code == 226)
										return "acirc";
									else
										return null;
								}
							}
						} else {
							if(code == 231)
								return "ccedil";
							else if(code < 231) {
								if(code == 229)
									return "aring";
								else if(code < 229) {
									if(code == 228)
										return "auml";
									else
										return null;
								} else {
									if(code == 230)
										return "aelig";
									else
										return null;
								}
							} else {
								if(code == 233)
									return "eacute";
								else if(code < 233) {
									if(code == 232)
										return "egrave";
									else
										return null;
								} else {
									if(code == 234)
										return "ecirc";
									else
										return null;
								}
							}
						}
					} else {
						if(code == 243)
							return "oacute";
						else if(code < 243) {
							if(code == 239)
								return "iuml";
							else if(code < 239) {
								if(code == 237)
									return "iacute";
								else if(code < 237) {
									if(code == 236)
										return "igrave";
									else
										return null;
								} else {
									if(code == 238)
										return "icirc";
									else
										return null;
								}
							} else {
								if(code == 241)
									return "ntilde";
								else if(code < 241) {
									if(code == 240)
										return "eth";
									else
										return null;
								} else {
									if(code == 242)
										return "ograve";
									else
										return null;
								}
							}
						} else {
							if(code == 247)
								return "divide";
							else if(code < 247) {
								if(code == 245)
									return "otilde";
								else if(code < 245) {
									if(code == 244)
										return "ocirc";
									else
										return null;
								} else {
									if(code == 246)
										return "ouml";
									else
										return null;
								}
							} else {
								if(code == 249)
									return "ugrave";
								else if(code < 249) {
									if(code == 248)
										return "oslash";
									else
										return null;
								} else {
									if(code == 250)
										return "uacute";
									else
										return null;
								}
							}
						}
					}
				} else {
					if(code == 916)
						return "Delta";
					else if(code < 916) {
						if(code == 353)
							return "scaron";
						else if(code < 353) {
							if(code == 255)
								return "yuml";
							else if(code < 255) {
								if(code == 253)
									return "yacute";
								else if(code < 253) {
									if(code == 252)
										return "uuml";
									else
										return null;
								} else {
									if(code == 254)
										return "thorn";
									else
										return null;
								}
							} else {
								if(code == 339)
									return "oelig";
								else if(code < 339) {
									if(code == 338)
										return "OElig";
									else
										return null;
								} else {
									if(code == 352)
										return "Scaron";
									else
										return null;
								}
							}
						} else {
							if(code == 732)
								return "tilde";
							else if(code < 732) {
								if(code == 402)
									return "fnof";
								else if(code < 402) {
									if(code == 376)
										return "Yuml";
									else
										return null;
								} else {
									if(code == 710)
										return "circ";
									else
										return null;
								}
							} else {
								if(code == 914)
									return "Beta";
								else if(code < 914) {
									if(code == 913)
										return "Alpha";
									else
										return null;
								} else {
									if(code == 915)
										return "Gamma";
									else
										return null;
								}
							}
						}
					} else {
						if(code == 924)
							return "Mu";
						else if(code < 924) {
							if(code == 920)
								return "Theta";
							else if(code < 920) {
								if(code == 918)
									return "Zeta";
								else if(code < 918) {
									if(code == 917)
										return "Epsilon";
									else
										return null;
								} else {
									if(code == 919)
										return "Eta";
									else
										return null;
								}
							} else {
								if(code == 922)
									return "Kappa";
								else if(code < 922) {
									if(code == 921)
										return "Iota";
									else
										return null;
								} else {
									if(code == 923)
										return "Lambda";
									else
										return null;
								}
							}
						} else {
							if(code == 928)
								return "Pi";
							else if(code < 928) {
								if(code == 926)
									return "Xi";
								else if(code < 926) {
									if(code == 925)
										return "Nu";
									else
										return null;
								} else {
									if(code == 927)
										return "Omicron";
									else
										return null;
								}
							} else {
								if(code == 929)
									return "Rho";
								if(code == 931)
									return "Sigma";
								return null;
							}
						}
					}
				}
			}
		} else {
			if(code == 8476)
				return "real";
			else if(code < 8476) {
				if(code == 978)
					return "upsih";
				else if(code < 978) {
					if(code == 955)
						return "lambda";
					else if(code < 955) {
						if(code == 947)
							return "gamma";
						else if(code < 947) {
							if(code == 936)
								return "Psi";
							else if(code < 936) {
								if(code == 934)
									return "Phi";
								else if(code < 934) {
									if(code == 933)
										return "Upsilon";
									else
										return null;
								} else {
									if(code == 935)
										return "Chi";
									else
										return null;
								}
							} else {
								if(code == 945)
									return "alpha";
								else if(code < 945) {
									if(code == 937)
										return "Omega";
									else
										return null;
								} else {
									if(code == 946)
										return "beta";
									else
										return null;
								}
							}
						} else {
							if(code == 951)
								return "eta";
							else if(code < 951) {
								if(code == 949)
									return "epsilon";
								else if(code < 949) {
									if(code == 948)
										return "delta";
									else
										return null;
								} else {
									if(code == 950)
										return "zeta";
									else
										return null;
								}
							} else {
								if(code == 953)
									return "iota";
								else if(code < 953) {
									if(code == 952)
										return "theta";
									else
										return null;
								} else {
									if(code == 954)
										return "kappa";
									else
										return null;
								}
							}
						}
					} else {
						if(code == 963)
							return "sigma";
						else if(code < 963) {
							if(code == 959)
								return "omicron";
							else if(code < 959) {
								if(code == 957)
									return "nu";
								else if(code < 957) {
									if(code == 956)
										return "mu";
									else
										return null;
								} else {
									if(code == 958)
										return "xi";
									else
										return null;
								}
							} else {
								if(code == 961)
									return "rho";
								else if(code < 961) {
									if(code == 960)
										return "pi";
									else
										return null;
								} else {
									if(code == 962)
										return "sigmaf";
									else
										return null;
								}
							}
						} else {
							if(code == 967)
								return "chi";
							else if(code < 967) {
								if(code == 965)
									return "upsilon";
								else if(code < 965) {
									if(code == 964)
										return "tau";
									else
										return null;
								} else {
									if(code == 966)
										return "phi";
									else
										return null;
								}
							} else {
								if(code == 969)
									return "omega";
								else if(code < 969) {
									if(code == 968)
										return "psi";
									else
										return null;
								} else {
									if(code == 977)
										return "thetasym";
									else
										return null;
								}
							}
						}
					}
				} else {
					if(code == 8222)
						return "bdquo";
					else if(code < 8222) {
						if(code == 8207)
							return "rlm";
						else if(code < 8207) {
							if(code == 8201)
								return "thinsp";
							else if(code < 8201) {
								if(code == 8194)
									return "ensp";
								else if(code < 8194) {
									if(code == 982)
										return "piv";
									else
										return null;
								} else {
									if(code == 8195)
										return "emsp";
									else
										return null;
								}
							} else {
								if(code == 8205)
									return "zwj";
								else if(code < 8205) {
									if(code == 8204)
										return "zwnj";
									else
										return null;
								} else {
									if(code == 8206)
										return "lrm";
									else
										return null;
								}
							}
						} else {
							if(code == 8217)
								return "rsquo";
							else if(code < 8217) {
								if(code == 8212)
									return "mdash";
								else if(code < 8212) {
									if(code == 8211)
										return "ndash";
									else
										return null;
								} else {
									if(code == 8216)
										return "lsquo";
									else
										return null;
								}
							} else {
								if(code == 8220)
									return "ldquo";
								else if(code < 8220) {
									if(code == 8218)
										return "sbquo";
									else
										return null;
								} else {
									if(code == 8221)
										return "rdquo";
									else
										return null;
								}
							}
						}
					} else {
						if(code == 8249)
							return "lsaquo";
						else if(code < 8249) {
							if(code == 8230)
								return "hellip";
							else if(code < 8230) {
								if(code == 8225)
									return "Dagger";
								else if(code < 8225) {
									if(code == 8224)
										return "dagger";
									else
										return null;
								} else {
									if(code == 8226)
										return "bull";
									else
										return null;
								}
							} else {
								if(code == 8242)
									return "prime";
								else if(code < 8242) {
									if(code == 8240)
										return "permil";
									else
										return null;
								} else {
									if(code == 8243)
										return "Prime";
									else
										return null;
								}
							}
						} else {
							if(code == 8364)
								return "euro";
							else if(code < 8364) {
								if(code == 8254)
									return "oline";
								else if(code < 8254) {
									if(code == 8250)
										return "rsaquo";
									else
										return null;
								} else {
									if(code == 8260)
										return "frasl";
									else
										return null;
								}
							} else {
								if(code == 8465)
									return "image";
								if(code == 8472)
									return "weierp";
								return null;
							}
						}
					}
				}
			} else {
				if(code == 8745)
					return "cap";
				else if(code < 8745) {
					if(code == 8707)
						return "exist";
					else if(code < 8707) {
						if(code == 8629)
							return "crarr";
						else if(code < 8629) {
							if(code == 8593)
								return "uarr";
							else if(code < 8593) {
								if(code == 8501)
									return "alefsym";
								else if(code < 8501) {
									if(code == 8482)
										return "trade";
									else
										return null;
								} else {
									if(code == 8592)
										return "larr";
									else
										return null;
								}
							} else {
								if(code == 8595)
									return "darr";
								else if(code < 8595) {
									if(code == 8594)
										return "rarr";
									else
										return null;
								} else {
									if(code == 8596)
										return "harr";
									else
										return null;
								}
							}
						} else {
							if(code == 8659)
								return "dArr";
							else if(code < 8659) {
								if(code == 8657)
									return "uArr";
								else if(code < 8657) {
									if(code == 8656)
										return "lArr";
									else
										return null;
								} else {
									if(code == 8658)
										return "rArr";
									else
										return null;
								}
							} else {
								if(code == 8704)
									return "forall";
								else if(code < 8704) {
									if(code == 8660)
										return "hArr";
									else
										return null;
								} else {
									if(code == 8706)
										return "part";
									else
										return null;
								}
							}
						}
					} else {
						if(code == 8722)
							return "minus";
						else if(code < 8722) {
							if(code == 8713)
								return "notin";
							else if(code < 8713) {
								if(code == 8711)
									return "nabla";
								else if(code < 8711) {
									if(code == 8709)
										return "empty";
									else
										return null;
								} else {
									if(code == 8712)
										return "isin";
									else
										return null;
								}
							} else {
								if(code == 8719)
									return "prod";
								else if(code < 8719) {
									if(code == 8715)
										return "ni";
									else
										return null;
								} else {
									if(code == 8721)
										return "sum";
									else
										return null;
								}
							}
						} else {
							if(code == 8734)
								return "infin";
							else if(code < 8734) {
								if(code == 8730)
									return "radic";
								else if(code < 8730) {
									if(code == 8727)
										return "lowast";
									else
										return null;
								} else {
									if(code == 8733)
										return "prop";
									else
										return null;
								}
							} else {
								if(code == 8743)
									return "and";
								else if(code < 8743) {
									if(code == 8736)
										return "ang";
									else
										return null;
								} else {
									if(code == 8744)
										return "or";
									else
										return null;
								}
							}
						}
					}
				} else {
					if(code == 8853)
						return "oplus";
					else if(code < 8853) {
						if(code == 8801)
							return "equiv";
						else if(code < 8801) {
							if(code == 8764)
								return "sim";
							else if(code < 8764) {
								if(code == 8747)
									return "int";
								else if(code < 8747) {
									if(code == 8746)
										return "cup";
									else
										return null;
								} else {
									if(code == 8756)
										return "there4";
									else
										return null;
								}
							} else {
								if(code == 8776)
									return "asymp";
								else if(code < 8776) {
									if(code == 8773)
										return "cong";
									else
										return null;
								} else {
									if(code == 8800)
										return "ne";
									else
										return null;
								}
							}
						} else {
							if(code == 8835)
								return "sup";
							else if(code < 8835) {
								if(code == 8805)
									return "ge";
								else if(code < 8805) {
									if(code == 8804)
										return "le";
									else
										return null;
								} else {
									if(code == 8834)
										return "sub";
									else
										return null;
								}
							} else {
								if(code == 8838)
									return "sube";
								else if(code < 8838) {
									if(code == 8836)
										return "nsub";
									else
										return null;
								} else {
									if(code == 8839)
										return "supe";
									else
										return null;
								}
							}
						}
					} else {
						if(code == 9001)
							return "lang";
						else if(code < 9001) {
							if(code == 8968)
								return "lceil";
							else if(code < 8968) {
								if(code == 8869)
									return "perp";
								else if(code < 8869) {
									if(code == 8855)
										return "otimes";
									else
										return null;
								} else {
									if(code == 8901)
										return "sdot";
									else
										return null;
								}
							} else {
								if(code == 8970)
									return "lfloor";
								else if(code < 8970) {
									if(code == 8969)
										return "rceil";
									else
										return null;
								} else {
									if(code == 8971)
										return "rfloor";
									else
										return null;
								}
							}
						} else {
							if(code == 9827)
								return "clubs";
							else if(code < 9827) {
								if(code == 9674)
									return "loz";
								else if(code < 9674) {
									if(code == 9002)
										return "rang";
									else
										return null;
								} else {
									if(code == 9824)
										return "spades";
									else
										return null;
								}
							} else {
								if(code == 9829)
									return "hearts";
								if(code == 9830)
									return "diams";
								return null;
							}
						}
					}
				}
			}
		}
	}


}
