/*
 * Decompiled with CFR 0.152.
 */
package to.etc.csv;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import to.etc.csv.iInputField;
import to.etc.csv.iRecordReader;
import to.etc.util.StringTool;

public class CSVRecordReader
implements iRecordReader {
    private String m_name;
    private Reader m_r;
    private LineNumberReader m_line_r;
    int m_lnr;
    private boolean m_skip_ws = true;
    private List<Field> m_fld_al = new ArrayList<Field>();
    private List<String> m_fldsep_al = new ArrayList<String>();
    private StringBuffer m_quote_sb = new StringBuffer();
    private boolean m_ignoreQuotes = false;
    private boolean m_escapeBackslash = true;
    private boolean m_escapeDupQuote = false;
    private boolean m_startWithFieldNames;
    private boolean m_whitespaceSeparator;
    private boolean m_escapeBadly = false;
    private int m_len;
    private int m_ix;
    private int m_fld_ix;
    private String m_line;

    @Override
    public void open(Reader r, String name) throws Exception {
        this.m_name = name;
        this.m_lnr = 0;
        this.m_r = r;
        this.m_line_r = new LineNumberReader(this.m_r);
    }

    @Override
    public void close() throws Exception {
        this.m_line_r.close();
    }

    private void error(String s) throws IOException {
        throw new IOException(this.m_name + "(" + this.m_lnr + ":" + this.m_ix + "): " + s);
    }

    @Override
    public int getCurrentRecNr() {
        return this.m_lnr;
    }

    public void setFieldSeparator(String sep) {
        this.m_fldsep_al.clear();
        this.m_fldsep_al.add(sep);
    }

    public void addFieldSeparator(String sep) {
        if (sep.length() == 1 && Character.isWhitespace(sep.charAt(0))) {
            this.setWhitespaceSeparator(true);
        }
        this.m_fldsep_al.add(sep);
    }

    public void setSkipWhitespace(boolean skip_ws) {
        this.m_skip_ws = skip_ws;
    }

    public void setIgnoreQuotes(boolean ignoreQuotes) {
        this.m_ignoreQuotes = ignoreQuotes;
    }

    public void setEscapeBackslash(boolean escapeBackslash) {
        this.m_escapeBackslash = escapeBackslash;
    }

    public void setEscapeDupQuote(boolean escapeDupQuote) {
        this.m_escapeDupQuote = escapeDupQuote;
    }

    public void setStartWithFieldNames(boolean startWithFieldNames) {
        this.m_startWithFieldNames = startWithFieldNames;
    }

    public void setEscapeBadly(boolean escapeBadly) {
        this.m_escapeBadly = escapeBadly;
    }

    private boolean _nextRecord() throws IOException {
        String line = this.m_line_r.readLine();
        if (line == null) {
            return false;
        }
        ++this.m_lnr;
        this.decode(line);
        return true;
    }

    @Override
    public boolean nextRecord() throws IOException {
        if (this.m_startWithFieldNames && this.m_lnr == 0) {
            if (!this._nextRecord()) {
                return false;
            }
            int i = this.size();
            while (--i >= 0) {
                this.elementAt((int)i).m_fldname = this.elementAt((int)i).m_value;
            }
        }
        return this._nextRecord();
    }

    public boolean isEmptyLine() {
        return this.m_len == 0;
    }

    private void decode(String line) throws IOException {
        this.m_line = line;
        this.m_len = line.length();
        this.m_ix = 0;
        this.m_fld_ix = 0;
        while (this.m_ix < this.m_len) {
            if (this.m_skip_ws) {
                this.m_ix = this.checkForWS(this.m_line, this.m_ix);
            }
            if (this.m_ix >= this.m_len) break;
            this.parseField();
            if (this.m_skip_ws) {
                this.m_ix = this.checkForWS(this.m_line, this.m_ix);
            }
            if (this.m_ix >= this.m_len) break;
            this.parseSeparator();
        }
    }

    public final String getLine() {
        return this.m_line;
    }

    public void defineFields(String fields) {
        StringTokenizer st = new StringTokenizer(fields, ";,");
        int ix = 0;
        while (st.hasMoreTokens()) {
            char ec;
            char c;
            String name = st.nextToken().trim();
            if (name.length() > 2 && ((c = name.charAt(0)) == '\"' || c == '\"' || c == '`') && (ec = name.charAt(name.length() - 1)) == c) {
                name = name.substring(1, name.length() - 1);
            }
            iInputField f = this.getField(ix);
            f.setName(name);
            ++ix;
        }
    }

    private void parseField() throws IOException {
        int sl;
        char c = this.m_line.charAt(this.m_ix);
        if (this.isQuote(c)) {
            this.parseQuoted();
            return;
        }
        int six = this.m_ix;
        while (this.m_ix < this.m_len && (sl = this.checkForSeparator(this.m_line, this.m_ix)) == 0) {
            ++this.m_ix;
        }
        if (this.m_ix == six) {
            this.addField(this.m_ix, null);
        } else {
            this.addLitField(six, this.m_line, this.m_ix - six);
        }
    }

    private void parseQuoted() throws IOException {
        int spos = this.m_ix;
        char qc = this.m_line.charAt(this.m_ix++);
        StringBuffer sb = new StringBuffer();
        while (true) {
            char c;
            int ql;
            if (this.m_ix >= this.m_len) {
                this.error("Missing end quote in field " + this.m_fld_ix);
            }
            if ((ql = this.checkEscapeQuote(this.m_line, this.m_ix, qc)) > 0) {
                sb.append(qc);
                this.m_ix += ql;
                continue;
            }
            if ((c = this.m_line.charAt(this.m_ix++)) == qc) break;
            sb.append(c);
        }
        this.addField(spos, sb.toString());
    }

    private Field elementAt(int i) {
        if (i > this.m_fld_al.size()) {
            return null;
        }
        return this.m_fld_al.get(i);
    }

    @Override
    public iInputField getField(int ix) {
        while (this.m_fld_al.size() <= ix) {
            Field f = new Field();
            this.m_fld_al.add(f);
            f.m_index = this.m_fld_al.size() - 1;
        }
        return this.elementAt(ix);
    }

    @Override
    public int size() {
        return this.m_fld_ix;
    }

    private void addLitField(int spos, String line, int len) {
        if (this.m_fld_ix >= this.m_fld_al.size()) {
            this.m_fld_al.add(new Field());
        }
        Field f = this.m_fld_al.get(this.m_fld_ix);
        f.m_index = this.m_fld_ix++;
        f.setValue(line.substring(spos, spos + len));
    }

    private void addField(int spos, String val) {
        if (this.m_fld_ix >= this.m_fld_al.size()) {
            this.m_fld_al.add(new Field());
        }
        Field f = this.m_fld_al.get(this.m_fld_ix);
        f.m_index = this.m_fld_ix++;
        f.setValue(val);
    }

    @Override
    public iInputField find(String name) {
        if (name.startsWith("#")) {
            int ix = StringTool.strToInt(name.substring(1), -1);
            if (ix < 0 || ix >= this.m_fld_al.size()) {
                return null;
            }
            return this.elementAt(ix);
        }
        int i = this.m_fld_al.size();
        while (--i >= 0) {
            Field f = this.elementAt(i);
            if (!f.getName().equalsIgnoreCase(name)) continue;
            return f;
        }
        return null;
    }

    public String getValue(int ix) {
        iInputField f = this.getField(ix);
        if (f == null) {
            return null;
        }
        return f.getValue();
    }

    public String getValue(String name) {
        iInputField f = this.find(name);
        if (f == null) {
            return null;
        }
        return f.getValue();
    }

    public int getIntValue(String name) throws IOException {
        iInputField f = this.find(name);
        if (f == null || f.isEmpty()) {
            this.error("Expecting an integer value in '" + name + "'");
            return 0;
        }
        return this.convertToInt(f.getValue(), name);
    }

    public int getIntValue(String name, int def) throws IOException {
        iInputField f = this.find(name);
        if (f == null || f.isEmpty()) {
            return def;
        }
        return this.convertToInt(f.getValue(), name);
    }

    private int convertToInt(String val, String field) throws IOException {
        try {
            return Integer.parseInt(val.trim());
        }
        catch (Exception exception) {
            this.error("Expecting integer value in '" + field + "', got '" + val + "'");
            return -1;
        }
    }

    public long getLongValue(String name) throws IOException {
        iInputField f = this.find(name);
        if (f == null || f.isEmpty()) {
            this.error("Expecting an long value in '" + name + "'");
            return 0L;
        }
        return this.convertToLong(f.getValue(), name);
    }

    public long getLongValue(String name, long def) throws IOException {
        iInputField f = this.find(name);
        if (f == null || f.isEmpty()) {
            return def;
        }
        return this.convertToLong(f.getValue(), name);
    }

    private long convertToLong(String val, String field) throws IOException {
        try {
            return Long.parseLong(val.trim());
        }
        catch (Exception exception) {
            this.error("Expecting long value in '" + field + "', got '" + val + "'");
            return -1L;
        }
    }

    private void parseSeparator() throws IOException {
        int sl = this.checkForSeparator(this.m_line, this.m_ix);
        if (sl == 0) {
            this.error("Missing field separator in input file " + this.m_name);
        }
        this.m_ix += sl;
        if (this.m_fld_ix >= this.m_fld_al.size()) {
            this.m_fld_al.add(new Field());
        }
        Field f = this.m_fld_al.get(this.m_fld_ix);
        f.m_index = this.m_fld_ix;
        f.setValue(null);
    }

    private int checkForSeparator(String line, int ix) {
        if (this.m_fldsep_al.size() == 0) {
            this.m_fldsep_al.add(",");
        }
        int i = this.m_fldsep_al.size();
        while (--i >= 0) {
            int sc = this.checkForSeparator(this.m_fldsep_al.get(i), line, ix);
            if (sc <= 0) continue;
            return sc;
        }
        return 0;
    }

    private int checkForSeparator(String sep, String line, int ix) {
        int len = line.length();
        int six = ix;
        if (this.m_skip_ws) {
            ix = this.checkForWS(line, ix);
        }
        if (ix + sep.length() > len) {
            return 0;
        }
        if (line.substring(ix, ix + sep.length()).equalsIgnoreCase(sep)) {
            return ix + sep.length() - six;
        }
        return 0;
    }

    private int checkForWS(String line, int ix) {
        int len = line.length();
        while (ix < len && Character.isWhitespace(line.charAt(ix))) {
            if (this.hasWhitespaceSeparator()) {
                int i = this.m_fldsep_al.size();
                while (--i >= 0) {
                    if (this.m_fldsep_al.get(i).length() != 1 || this.m_fldsep_al.get(i).charAt(0) != line.charAt(ix)) continue;
                    return ix;
                }
            }
            ++ix;
        }
        return ix;
    }

    private int checkEscapeQuote(String line, int ix, char qc) {
        int len = line.length();
        if (this.m_escapeBackslash && ix + 2 <= len && line.charAt(ix) == '\\' && line.charAt(ix + 1) == qc) {
            return 2;
        }
        if (this.m_escapeDupQuote && ix + 2 <= len && line.charAt(ix) == qc && line.charAt(ix + 1) == qc) {
            return 2;
        }
        if (this.m_escapeBadly && ix + 2 <= len && line.charAt(ix) == qc) {
            int sl;
            int tix = ix + 1;
            if (this.m_skip_ws) {
                tix = this.checkForWS(line, tix);
            }
            if ((sl = this.checkForSeparator(line, tix)) == 0) {
                return 1;
            }
        }
        return 0;
    }

    private boolean isQuote(char c) {
        if (!this.m_ignoreQuotes && this.m_quote_sb.length() == 0) {
            this.m_quote_sb.append('\"');
        }
        int i = this.m_quote_sb.length();
        while (--i >= 0) {
            if (this.m_quote_sb.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    private boolean hasWhitespaceSeparator() {
        return this.m_whitespaceSeparator;
    }

    private void setWhitespaceSeparator(boolean separator) {
        this.m_whitespaceSeparator = separator;
    }

    private class Field
    implements iInputField {
        int m_index;
        String m_fldname;
        String m_value;
        int m_field_lnr;

        @Override
        public void setName(String name) {
            this.m_fldname = name;
        }

        @Override
        public String getName() {
            if (this.m_fldname == null) {
                return "#" + this.m_index;
            }
            return this.m_fldname;
        }

        @Override
        public String getValue() {
            return this.m_value;
        }

        @Override
        public boolean isEmpty() {
            return this.m_value == null || CSVRecordReader.this.m_lnr != this.m_field_lnr;
        }

        public void setValue(String s) {
            this.m_field_lnr = CSVRecordReader.this.m_lnr;
            this.m_value = s;
        }
    }
}

